/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.processmodel;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.processmodel.ActivityTypeAttribute;
import oracle.bpm.util.ArrayUtils;

public abstract class Activity {
    protected String name_d;
    protected int type_d;
    private static final Map<Integer, Field> reverseTypesIndex = new HashMap<Integer, Field>(64);
    public static final int AUTOMATIC = 1;
    public static final int INTERACTIVE = 2;
    public static final int GLOBAL = 4;
    public static final int CREATION = 8;
    public static final int GRAB = 16;
    public static final int BEGIN = 33;
    public static final int END = 65;
    public static final int SPLIT = 129;
    public static final int SPLIT_N = 385;
    public static final int JOIN = 513;
    public static final int SUBPROCESS = 1025;
    public static final int PROCESS_CREATION = 2049;
    public static final int TERMINATION_WAIT = 4097;
    public static final int PROCESS_NOTIFICATION = 8193;
    public static final int NOTIFICATION_WAIT = 16385;
    public static final int SUBFLOW = 32769;
    public static final int GROUP = 65537;
    public static final int INTERACTIVE_COMPONENT_CALL = 131072;
    public static final int CONDITIONAL = 262145;
    public static final int COMPENSATE = 524289;
    public static final int GLOBAL_AUTOMATIC = 5;
    public static final int GLOBAL_CREATION = 14;
    public static final int INTERACTIVE_GRAB = 18;
    public static final int DECISION = 0x100002;
    public static final int OR_SPLIT = 2097281;
    public static final int OR_JOIN = 0x400001;
    public static final int TIMER = 0x800001;
    private static final int OFFSET = 0x800000;
    @ActivityTypeAttribute(functionalTypes={0x100002, 1})
    public static final int BPMN_BUSINESS_RULE_TASK = 0x800001;
    @ActivityTypeAttribute(functionalTypes={32769, 1})
    public static final int BPMN_CALL_ACTIVITY = 0x800002;
    @ActivityTypeAttribute(functionalTypes={65, 1})
    public static final int BPMN_END_EVENT = 0x800003;
    @ActivityTypeAttribute(functionalTypes={262145, 1})
    public static final int BPMN_EXCLUSIVE_GATEWAY = 0x800004;
    @ActivityTypeAttribute(functionalTypes={2097281, 129, 1})
    public static final int BPMN_INCLUSIVE_GATEWAY = 0x800005;
    @ActivityTypeAttribute(functionalTypes={129, 1})
    public static final int BPMN_PARALLEL_GATEWAY = 0x800006;
    @ActivityTypeAttribute(functionalTypes={16385, 1})
    public static final int BPMN_RECEIVE_TASK = 0x800007;
    @ActivityTypeAttribute(functionalTypes={1})
    public static final int BPMN_SCRIPT_TASK = 0x800008;
    @ActivityTypeAttribute(functionalTypes={8193, 1})
    public static final int BPMN_SEND_TASK = 0x800009;
    @ActivityTypeAttribute(functionalTypes={1})
    public static final int BPMN_SERVICE_TASK = 0x80000A;
    @ActivityTypeAttribute(functionalTypes={33, 1})
    public static final int BPMN_START_EVENT = 0x80000B;
    @ActivityTypeAttribute(functionalTypes={65537, 1})
    public static final int BPMN_SUBPROCESS = 0x80000C;
    @ActivityTypeAttribute(functionalTypes={2})
    public static final int BPMN_USER_TASK = 0x80000D;
    @ActivityTypeAttribute(functionalTypes={16385, 1})
    public static final int BPMN_CATCH_INTERMEDIATE_EVENT = 0x80000E;
    @ActivityTypeAttribute(functionalTypes={8193, 1})
    public static final int BPMN_THROW_INTERMEDIATE_EVENT = 0x80000F;
    @ActivityTypeAttribute(functionalTypes={2})
    public static final int BPMN_MANUAL_TASK = 0x800010;
    @ActivityTypeAttribute(functionalTypes={262145, 1})
    public static final int BPMN_EVENT_BASED_GATEWAY = 0x800011;
    @ActivityTypeAttribute(functionalTypes={129, 1})
    public static final int BPMN_COMPLEX_GATEWAY = 8388626;
    @ActivityTypeAttribute(functionalTypes={1})
    public static final int BPMN_MEASUREMENT_INTERVAL_START = 8388627;
    @ActivityTypeAttribute(functionalTypes={1})
    public static final int BPMN_MEASUREMENT_INTERVAL_STOP = 8388628;
    @ActivityTypeAttribute(functionalTypes={1})
    public static final int BPMN_MEASUREMENT_MARK = 8388629;

    public abstract String getDescription(Locale var1);

    public String getName() {
        return this.name_d;
    }

    public int getType() {
        return this.type_d;
    }

    public boolean hasType(int type) {
        ActivityTypeAttribute annotation;
        Field field = reverseTypesIndex.get(this.getType());
        if (field != null && (annotation = field.getAnnotation(ActivityTypeAttribute.class)) != null) {
            return ArrayUtils.contains(annotation.functionalTypes(), (Object)type);
        }
        return (this.type_d & type) == type;
    }

    protected void loadType(ActivityType type) {
        if (type == ActivityType.AUTOMATIC) {
            this.type_d = 1;
        } else if (type == ActivityType.BEGIN) {
            this.type_d = 33;
        } else if (type == ActivityType.END) {
            this.type_d = 65;
        } else if (type == ActivityType.GLOBAL) {
            this.type_d = 4;
        } else if (type == ActivityType.GLOBAL_AUTOMATIC) {
            this.type_d = 5;
        } else if (type == ActivityType.GLOBAL_CREATION) {
            this.type_d = 14;
        } else if (type.isGrab()) {
            this.type_d = 18;
        } else if (type == ActivityType.INTERACTIVE) {
            this.type_d = 2;
        } else if (type == ActivityType.DECISION) {
            this.type_d = 0x100002;
        } else if (type == ActivityType.JOIN) {
            this.type_d = 513;
        } else if (type == ActivityType.NOTIFICATION_WAIT) {
            this.type_d = 16385;
        } else if (type == ActivityType.PROCESS_CREATION) {
            this.type_d = 2049;
        } else if (type == ActivityType.PROCESS_NOTIFICATION) {
            this.type_d = 8193;
        } else if (type == ActivityType.SPLIT) {
            this.type_d = 129;
        } else if (type == ActivityType.OR_SPLIT) {
            this.type_d = 2097281;
        } else if (type == ActivityType.SPLIT_N) {
            this.type_d = 385;
        } else if (type == ActivityType.TERMINATION_WAIT) {
            this.type_d = 4097;
        } else if (type == ActivityType.SUBFLOW) {
            this.type_d = 32769;
        } else if (type == ActivityType.GROUP) {
            this.type_d = 65537;
        } else if (type == ActivityType.INTERACTIVE_COMPONENT_CALL) {
            this.type_d = 131072;
        } else if (type.isAnyNop()) {
            this.type_d = 262145;
        } else if (type == ActivityType.COMPENSATE) {
            this.type_d = 524289;
        } else if (type == ActivityType.MEASUREMENT) {
            this.type_d = 1;
        } else if (type == ActivityType.MEASUREMENT_START) {
            this.type_d = 1;
        } else if (type == ActivityType.MEASUREMENT_STOP) {
            this.type_d = 1;
        } else if (type == ActivityType.TIMER) {
            this.type_d = 0x800001;
        } else {
            this.type_d = 0;
            CoreMsg.INVALID_ACTIVITY_TYPE(type.toString(), this.name_d).logSevere();
            throw new RuntimeException(CoreMsg.INVALID_ACTIVITY_TYPE(type.toString(), this.name_d).getString());
        }
    }

    static {
        for (Field field : Activity.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().getName().equals(Integer.TYPE.getName())) continue;
            try {
                reverseTypesIndex.put(field.getInt(null), field);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

