/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pool;

import java.util.Properties;
import oracle.bpm.pool.Cache;
import oracle.bpm.pool.Factory;
import oracle.bpm.pool.TimedMultiValuatedCache;

public class CacheFactory {
    private CacheFactory() {
    }

    public static String[] getPropertiesNames() {
        return new String[]{"fuego.cache.initial_key", "fuego.cache.maxentrysize", "fuego.cache.maxsize", "fuego.cache.minsize", "fuego.cache.policy", "fuego.cache.timeout", "fuego.cache.wait", "fuego.cache.maxretries", "fuego.cache.retrytimeout", "fuego.cache.statistics"};
    }

    public static <K, V> Cache<K, V> createCache(Factory<V> f, Properties p) {
        String maxStr = p.getProperty("fuego.cache.maxsize");
        String timeoutStr = p.getProperty("fuego.cache.timeout");
        String maxEntrySizeStr = p.getProperty("fuego.cache.maxentrysize");
        String minNoDisposableStr = p.getProperty("fuego.cache.minnodisposable");
        String waitForLockStr = p.getProperty("fuego.cache.wait");
        String maxRetriesStr = p.getProperty("fuego.cache.maxretries");
        String waitTimeoutStr = p.getProperty("fuego.cache.retrytimeout");
        String useStatisticsStr = p.getProperty("fuego.cache.statistics", Cache.STATISTICS_ENABLED_DEFAULT);
        int max = 10;
        try {
            max = Integer.parseInt(maxStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        int timeout = 5;
        try {
            timeout = Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        int maxEntrySize = 10;
        try {
            maxEntrySize = Integer.parseInt(maxEntrySizeStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        int minNoDisposable = 0;
        try {
            minNoDisposable = Integer.parseInt(minNoDisposableStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        boolean waitForLock = Boolean.parseBoolean(waitForLockStr);
        int maxRetries = 5;
        try {
            maxRetries = Integer.parseInt(maxRetriesStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        long waitTimeout = 500L;
        try {
            waitTimeout = Long.parseLong(waitTimeoutStr);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        boolean useStatistics = Boolean.valueOf(useStatisticsStr);
        return new TimedMultiValuatedCache(f, max, maxEntrySize, timeout, minNoDisposable, waitForLock, maxRetries, waitTimeout, useStatistics);
    }
}

