/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;

public final class Log {
    public static boolean isDebugging() {
        return LogComponent.DEFAULT.logger().isLoggable(Level.FINE);
    }

    public static boolean logDebug(String msg) {
        Log.logInternal(Level.FINE, msg);
        return true;
    }

    public static boolean logDebug(Msg msg) {
        Log.logInternal(Level.FINE, msg);
        return true;
    }

    public static boolean logDebug(Throwable t) {
        Log.logInternal(Level.FINE, t);
        return true;
    }

    public static void logFatal(ErrorMsg msg) {
        Log.logInternal(Level.SEVERE, msg);
    }

    public static void logFatal(Throwable t) {
        Log.logInternal(Level.SEVERE, t);
    }

    public static void logInfo(Msg msg) {
        Log.logInternal(Level.INFO, msg);
    }

    public static void logInfo(Throwable t) {
        Log.logInternal(Level.INFO, t);
    }

    public static void logSevere(Msg msg) {
        Log.logInternal(Level.SEVERE, msg);
    }

    public static void logSevere(Throwable t) {
        Log.logInternal(Level.INFO, t);
    }

    public static boolean logTrace(String msg) {
        Log.logInternal(Level.FINER, msg);
        return true;
    }

    public static boolean logTrace(Throwable t) {
        Log.logInternal(Level.FINER, t);
        return true;
    }

    public static void logWarning(Msg msg) {
        Log.logInternal(Level.WARNING, msg);
    }

    public static void logWarning(Msg msg, Throwable t) {
        Log.logInternal(Level.WARNING, msg, t);
    }

    public static void logWarning(Throwable t) {
        Log.logInternal(Level.WARNING, t);
    }

    private static Logger getCallerLogger(CallerInfo callerInfo) {
        return LogComponent.findLogComponent(callerInfo.className).logger();
    }

    private static Logger getMsgLogger(Msg msg) {
        return msg == null ? LogComponent.DEFAULT.logger() : msg.getLogComponent().logger();
    }

    private static void logInternal(Level level, String msg) {
        CallerInfo callerInfo = new CallerInfo(4);
        Log.getCallerLogger(callerInfo).logp(level, callerInfo.className, callerInfo.methodName, msg);
    }

    private static void logInternal(Level level, Msg msg) {
        CallerInfo callerInfo = new CallerInfo(4);
        Log.getMsgLogger(msg).logp(level, callerInfo.className, callerInfo.methodName, String.valueOf(msg));
    }

    private static void logInternal(Level level, Throwable t) {
        CallerInfo callerInfo = new CallerInfo(4);
        Log.getCallerLogger(callerInfo).logp(level, callerInfo.className, callerInfo.methodName, t == null ? "<null throwable>" : t.getMessage(), t);
    }

    private static void logInternal(Level level, Msg msg, Throwable t) {
        CallerInfo callerInfo = new CallerInfo(4);
        Log.getMsgLogger(msg).logp(level, callerInfo.className, callerInfo.methodName, String.valueOf(msg), t);
    }

    private static final class CallerInfo {
        public final String className;
        public final String methodName;

        CallerInfo(int depth) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace.length > depth) {
                this.className = stackTrace[depth].getClassName();
                this.methodName = stackTrace[depth].getMethodName();
            } else {
                this.className = "<unknown>";
                this.methodName = "<unknown>";
            }
        }

        public String toString() {
            return this.className + "." + this.methodName;
        }
    }
}

