/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.log;

public enum ErrorRange {
    DEFAULT(-1, -1),
    COMPOSER(20000, 29999),
    ANALYTICS_DASHBOARD_MEASUREMENT(50000, 50999),
    ANALYTICS_DASHBOARD_CUBES(51000, 51999),
    ANALYTICS_DASHBOARD_DASHBOARDS(52000, 52999),
    ANALYTICS_DASHBOARD_BAM(53000, 53999),
    STUDIO(60000, 69999),
    PROCESS_DASHBOARD_SERVICE(70000, 70199),
    INSTANCE_MANAGEMENT_SERVICE(70200, 70399),
    INSTANCE_QUERY_SERVICE(70400, 70599),
    ORGANIZATIONS_SERVICE(70600, 70799),
    PROCESS_METADATA_SERVICE(70800, 70999),
    AG_METADATA_SERVICE(71000, 71024),
    AG_QUERY_SERVICE(71025, 71049),
    USER_AUTHENTICATION_SERVICE(71050, 71199),
    PROCESS_MODEL_SERVICE(71200, 71299),
    AUDIT_CORE(71300, 71399),
    ENGINE_DEPLOY_SCHEMA(71400, 71499),
    PROJECT_CATALOG(71500, 71699),
    PROJECT_COMPILER(71700, 71899),
    LIBRARIES(71900, 72199),
    BAC(73000, 73699),
    MIGRATION(79000, 79999),
    HISTORY_CHANGES(80000, 80099),
    PML_SECURITY(80100, 80199);

    private final int lower;
    private final int upper;

    private ErrorRange(int lowerRange, int upperRange) {
        this.lower = lowerRange;
        this.upper = upperRange;
    }

    public int lower() {
        return this.lower;
    }

    public int upper() {
        return this.upper;
    }

    public boolean contains(int errorCode) {
        return errorCode >= this.lower && errorCode <= this.upper;
    }

    public String toString() {
        return this.name() + "(" + this.lower + ", " + this.upper + ")";
    }
}

