/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.locale;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.locale.LocaleBundleUtil;
import oracle.bpm.locale.LocaleSupport;

public class LocaleSupportImpl
implements LocaleSupport {
    private boolean availableOnIDE;
    private String country;
    private LocaleSupport delegate;
    private String language;
    private Locale locale;
    private String variant;

    public LocaleSupportImpl() {
    }

    public LocaleSupportImpl(Locale locale) {
        this(locale, null);
    }

    public LocaleSupportImpl(Locale locale, LocaleSupport delegate) {
        assert (delegate == null || locale.getLanguage().equals(delegate.getLanguage())) : "Invalid delegate '" + delegate + "' for locale: " + locale;
        this.locale = locale;
        this.delegate = delegate;
        this.setLanguage(locale.getLanguage());
        this.setCountry(locale.getCountry());
        this.setVariant(locale.getVariant());
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public boolean isAvailableOnIDE() {
        return this.availableOnIDE;
    }

    public void setAvailableOnIDE(boolean ide) {
        this.availableOnIDE = ide;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = new Locale(this.language, this.country, this.variant);
        }
        return this.locale;
    }

    @Override
    public Locale asJavaLocale() {
        return this.getLocale();
    }

    @Override
    public boolean isDefault() {
        return Platform.getLocaleService().getDefaultLocale() == this;
    }

    @Override
    public ResourceBundle resolveBundle(Class bundleClass) {
        ResourceBundle result = null;
        result = this.delegate != null ? this.delegate.resolveBundle(bundleClass) : LocaleBundleUtil.resolveBundle(bundleClass, this.getLocale());
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof LocaleSupport) {
            LocaleSupport otherLocale = (LocaleSupport)other;
            return this.asJavaLocale().equals(otherLocale.asJavaLocale());
        }
        return false;
    }

    public int hashCode() {
        return this.asJavaLocale().hashCode();
    }

    @Override
    public int compareTo(LocaleSupport other) {
        int result = this.compare(this.getLanguage(), other.getLanguage());
        if (result == 0) {
            result = this.compare(this.getCountry(), other.getCountry());
        }
        if (result == 0) {
            result = this.compare(this.getVariant(), other.getVariant());
        }
        return result;
    }

    public String toString() {
        return this.asJavaLocale().toString();
    }

    void setLanguage(String language) {
        this.language = language;
    }

    void setCountry(String country) {
        this.country = country;
    }

    void setVariant(String variant) {
        this.variant = variant;
    }

    private int compare(String s1, String s2) {
        return Any.equals(s1, s2) ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo(s2)));
    }
}

