/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.locale;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpm.lang.Str;
import oracle.bpm.locale.LocaleSupportImpl;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.Locales;

public class LocaleBundleUtil {
    private static final Locale EMPTY_LOCALE = new Locale("", "", "");

    public static ResourceBundle resolveBundle(Class bundleClass, Locale locale) {
        String baseName = bundleClass.getName();
        ResourceBundle result = LocaleBundleUtil.resolveBundleInClassLoader(baseName, locale, LocaleSupportImpl.class.getClassLoader());
        if (result == null && (result = LocaleBundleUtil.resolveBundleInClassLoader(baseName, locale, bundleClass.getClassLoader())) == null) {
            result = LocaleBundleUtil.resolveBundleInClassLoader(baseName, locale, Thread.currentThread().getContextClassLoader());
        }
        return result;
    }

    public static ResourceBundle resolveBundleInClassLoader(String baseName, Locale locale, ClassLoader classLoader) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            Locale bundleLocale = bundle.getLocale();
            if (!bundleLocale.getLanguage().equals(locale.getLanguage())) {
                bundle = ResourceBundle.getBundle(baseName, EMPTY_LOCALE, classLoader);
            }
            return bundle;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static Locale getBestMatchLocale(Locale locale) {
        Locale result;
        ResourceBundle resourceBundle;
        block3: {
            resourceBundle = null;
            try {
                resourceBundle = LocaleBundleUtil.resolveBundle(CoreMsg.class, locale);
            }
            catch (Throwable t) {
                if (!Log.isDebugging()) break block3;
                Log.logDebug("Error loading CoreMsg while trying to get the best match locale for [" + locale + "]");
                Log.logDebug(t);
            }
        }
        Locale locale2 = result = resourceBundle != null ? resourceBundle.getLocale() : locale;
        if (result == null || Str.isEmpty(result.toString())) {
            result = Locales.BASE_LOCALE;
        }
        return result;
    }
}

