/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Calendar;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.TZTime;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TimeParser {
    private static final int DEFAULT_HOUR = 0;
    private static final int DEFAULT_MINUTE = 0;
    private static final int DEFAULT_SECOND = 0;
    static final long M = 1000000L;

    private TimeParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static TZTime parseTZ(String text, Calendar cal) {
        Integer timeZone;
        int index;
        if (text.charAt(0) == '-') {
            try {
                index = TimeParser.parseDateOnly(text, cal, false);
            }
            catch (TimeFormatException ignored) {
                index = TimeParser.parseDateOnly(text.substring(1), cal, true);
            }
        } else {
            index = TimeParser.parseDateOnly(text, cal, false);
        }
        long time = 0L;
        if (index < text.length()) {
            time = TimeParser.parseTimeOnly(text, index);
        }
        int offset = (timeZone = TimeParser.parseTimezone(text, index, cal)) == null ? 0 : timeZone - Time.timeZoneOffset(cal);
        TZTime tZTime = new TZTime(Time.valueOf((cal.getTimeInMillis() - (long)offset) * 1000L + time), timeZone);
        if (tZTime == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/TimeParser.parseTZ must not return null");
        }
        return tZTime;
    }

    static int skipWhitespace(int index, String text) {
        while (index < text.length() && Character.isWhitespace(text.charAt(index))) {
            ++index;
        }
        return index;
    }

    @Nullable
    private static Integer parseTimezone(String text, int index, Calendar cal) {
        int timeZone = 0;
        boolean undefinedTZ = true;
        if (text.indexOf(90, index) != -1) {
            undefinedTZ = false;
        } else {
            int j = text.indexOf(43, index);
            if (j != -1 || (j = text.indexOf(45, index)) != -1) {
                undefinedTZ = false;
                boolean negTZ = text.charAt(j) == '-';
                String hourStr = TimeParser.extractNumber(text, ++j);
                String minuteStr = null;
                if ((j += hourStr.length()) == text.length() || text.charAt(j) != ':') {
                    if (hourStr.length() != 4 && hourStr.length() != 2) {
                        throw new TimeFormatException(text);
                    }
                    minuteStr = hourStr.substring(2);
                    hourStr = hourStr.substring(0, 2);
                }
                if (minuteStr == null) {
                    minuteStr = TimeParser.extractNumber(text, j + 1);
                }
                if (hourStr != null) {
                    timeZone += Integer.parseInt(hourStr) * 60;
                }
                if (minuteStr != null && minuteStr.length() != 0) {
                    timeZone += Integer.parseInt(minuteStr);
                }
                if (negTZ) {
                    timeZone = -timeZone;
                }
                timeZone *= 60000;
            }
        }
        return undefinedTZ ? null : Integer.valueOf(timeZone);
    }

    private static String extractNumber(String t, int i) throws TimeFormatException {
        int start = i;
        while (i < t.length() && Character.isDigit(t.charAt(i))) {
            ++i;
        }
        String strNum = t.substring(start, i);
        if (strNum.length() == 0) {
            throw new TimeFormatException(t);
        }
        return strNum;
    }

    private static boolean isComponentDelimiter(String text, int index) {
        boolean isDelimiter = true;
        if (index < text.length()) {
            char ch = text.charAt(index);
            isDelimiter = ch == '-' || ch == 'T' || ch == ' ' || ch == '/';
        }
        return isDelimiter;
    }

    private static int numLength(String text, int start) {
        int i;
        for (i = start; i < text.length() && Character.isDigit(text.charAt(i)); ++i) {
        }
        return i - start;
    }

    private static int parseDateOnly(String text, Calendar cal, boolean bc) {
        int index;
        int dateStart = index = 0;
        int length = text.length();
        DatePart currentComponent = DatePart.DATE_START;
        int ommitedCount = 0;
        boolean hasCentury = false;
        block17: while (index < length) {
            int start = index;
            switch (text.charAt(index)) {
                case '-': {
                    if (currentComponent == DatePart.DATE_END) break block17;
                    ++index;
                    ++ommitedCount;
                    currentComponent = currentComponent.next();
                    continue block17;
                }
                case ':': {
                    cal.clear();
                    index = dateStart;
                    break block17;
                }
                case '+': 
                case 'Z': {
                    break block17;
                }
                case ' ': 
                case 'T': {
                    ++index;
                    break block17;
                }
                case 'W': {
                    ++start;
                    currentComponent = DatePart.WEEK_OF_YEAR;
                    if (++index >= length || text.charAt(index) != '-') break;
                    ++ommitedCount;
                    ++index;
                    continue block17;
                }
                case '.': 
                case 'd': 
                case 'h': 
                case 'm': 
                case 's': {
                    long interval = TimeParser.parseInterval(text);
                    Time time = Time.valueOf(interval);
                    cal.setTime(time.getCalendar().getTime());
                    return length;
                }
                default: {
                    if (!Character.isDigit(text.charAt(index))) {
                        throw new TimeFormatException(text);
                    }
                    currentComponent = currentComponent.next();
                }
            }
            int numLength = TimeParser.numLength(text, start);
            switch (currentComponent) {
                case CENTURY: {
                    int year;
                    boolean isExpandedFmt;
                    int nextPos = start + numLength;
                    char nextChar = length > nextPos ? text.charAt(nextPos) : (char)'\u0000';
                    boolean bl = isExpandedFmt = nextChar == '-';
                    if ((!isExpandedFmt || numLength <= 2) && numLength != 4 && numLength != 7 && numLength != 8 && (numLength != 2 || !TimeParser.isComponentDelimiter(text, start + 3))) break;
                    if (numLength >= 4 || isExpandedFmt) {
                        int yearLength = isExpandedFmt ? numLength : 4;
                        year = TimeParser.parseNumber(text, start, yearLength);
                        index += yearLength;
                        currentComponent = DatePart.YEAR;
                    } else {
                        year = TimeParser.parseNumber(text, start, 2) * 100;
                        index += 2;
                    }
                    hasCentury = true;
                    if (bc || year < 0) {
                        cal.set(0, 0);
                    }
                    cal.set(1, Math.abs(year));
                    break;
                }
                case YEAR: {
                    index = TimeParser.parseYear(numLength, text, start, index, hasCentury, cal);
                    break;
                }
                case MONTH: {
                    index = TimeParser.parseMonth(numLength, text, start, cal, index);
                    break;
                }
                case DAY_OF_MONTH: {
                    index = TimeParser.parseDayOfMonth(numLength, ommitedCount, cal, text, start, index);
                    break;
                }
                case WEEK_OF_YEAR: {
                    cal.set(3, TimeParser.parseNumber(text, start, 2));
                    index += 2;
                    break;
                }
                case DAY_OF_WEEK: {
                    cal.set(7, TimeParser.parseNumber(text, start, 1));
                    ++index;
                    break;
                }
                case DATE_END: {
                    throw new TimeFormatException(text);
                }
                default: {
                    assert (false) : String.valueOf((Object)currentComponent);
                    break;
                }
            }
            if (currentComponent.next() == DatePart.DATE_END) {
                currentComponent = DatePart.DATE_END;
                continue;
            }
            if (index >= text.length() || text.charAt(index) != '-' && text.charAt(index) != '/') continue;
            ++index;
        }
        return index;
    }

    private static int parseYear(int numLength, String text, int start, int index, boolean hasCentury, Calendar cal) {
        int year;
        if (numLength == 1) {
            year = TimeParser.parseNumber(text, start, 1);
            ++index;
        } else {
            year = TimeParser.parseNumber(text, start, 2);
            index += 2;
        }
        int century = hasCentury ? cal.get(1) / 100 : 2000;
        year = century + year;
        if (year < 0) {
            cal.set(0, 0);
        }
        cal.set(1, year < 0 ? -year : year);
        return index;
    }

    private static int parseMonth(int numLength, String text, int start, Calendar cal, int index) {
        if (numLength == 3) {
            int dayOfYear = TimeParser.parseNumber(text, start, 3);
            cal.set(6, dayOfYear);
            index += 3;
        } else {
            int month = TimeParser.parseNumber(text, start, numLength <= 2 ? numLength : 2);
            if (month < 1 || month > 12) {
                throw new TimeFormatException(text);
            }
            cal.set(2, month - 1);
            index += Math.min(numLength, 2);
        }
        return index;
    }

    private static int parseDayOfMonth(int numLength, int ommitedCount, Calendar cal, String text, int start, int index) {
        if (numLength == 1 && ommitedCount == 3) {
            cal.set(7, TimeParser.parseNumber(text, start, 1));
        } else {
            int day = TimeParser.parseNumber(text, start, numLength <= 2 ? numLength : 2);
            if (day < 1 || day > 31) {
                throw new TimeFormatException(text);
            }
            int month = cal.get(2) + 1;
            int year = cal.get(1);
            if (day > 30 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                throw new TimeFormatException(text);
            }
            if (month == 2) {
                if (day > 29) {
                    throw new TimeFormatException(text);
                }
                if (!(day <= 28 || year % 4 == 0 && year % 100 != 0 || year > 1582 && year % 400 == 0)) {
                    throw new TimeFormatException(text);
                }
            }
            cal.set(5, day);
        }
        return index += Math.min(numLength, 2);
    }

    private static long parseInterval(String t) throws TimeFormatException {
        int i;
        for (i = 0; i < t.length() && Character.isWhitespace(t.charAt(i)); ++i) {
        }
        if (i == t.length()) {
            throw new TimeFormatException(t);
        }
        boolean neg = false;
        if (t.charAt(i) == '-') {
            neg = true;
            ++i;
        }
        long micro = 0L;
        while (i < t.length()) {
            while (i < t.length() && Character.isWhitespace(t.charAt(i))) {
                ++i;
            }
            if (i == t.length()) break;
            String num = TimeParser.extractNumber(t, i);
            String decimal = null;
            if ((i += num.length()) < t.length() && t.charAt(i) == '.') {
                decimal = TimeParser.extractNumber(t, ++i);
                i += decimal.length();
            }
            while (i < t.length() && Character.isWhitespace(t.charAt(i))) {
                ++i;
            }
            if (i == t.length()) {
                throw new TimeFormatException(t);
            }
            double magnitude = decimal == null ? (double)Integer.parseInt(num) : Double.parseDouble(num + '.' + decimal);
            switch (t.charAt(i)) {
                case 'd': {
                    micro += (long)(magnitude * 8.64E10);
                    break;
                }
                case 'h': {
                    micro += (long)(magnitude * 3.6E9);
                    break;
                }
                case 'm': {
                    micro += (long)(magnitude * 6.0E7);
                    break;
                }
                case 's': {
                    micro += (long)(magnitude * 1000000.0);
                    break;
                }
                default: {
                    throw new TimeFormatException(t);
                }
            }
            ++i;
        }
        return neg ? -micro : micro;
    }

    private static int parseNumber(String text, int offset, int length) {
        try {
            return Int.parse(text, offset, length);
        }
        catch (NumberFormatException e) {
            throw new TimeFormatException(text);
        }
    }

    private static long parseTimeOnly(String text, int index) throws TimeFormatException {
        while (index < text.length()) {
            char chr = text.charAt(index);
            if (chr == 'Z' || chr == '+' || chr == '-') {
                return 0L;
            }
            if (!Character.isWhitespace(chr)) break;
            ++index;
        }
        String hourStr = TimeParser.extractNumber(text, index);
        String secondStr = null;
        String minuteStr = null;
        if ((index += hourStr.length()) == text.length() || text.charAt(index) != ':') {
            if (hourStr.length() != 6 && hourStr.length() != 4 && hourStr.length() != 2) {
                throw new TimeFormatException(text);
            }
            if (hourStr.length() >= 4) {
                secondStr = hourStr.substring(4);
                minuteStr = hourStr.substring(2, 4);
            }
            hourStr = hourStr.substring(0, 2);
        }
        if (minuteStr == null && index < text.length() && text.charAt(index) == ':') {
            ++index;
            if ((index += (minuteStr = TimeParser.extractNumber(text, index)).length()) < text.length() && text.charAt(index) == ':') {
                secondStr = TimeParser.extractNumber(text, ++index);
                index += secondStr.length();
            }
        }
        String microSecondStr = null;
        if (index < text.length() && text.charAt(index) == '.') {
            microSecondStr = TimeParser.extractNumber(text, ++index);
            index += microSecondStr.length();
        }
        if ((index = TimeParser.skipWhitespace(index, text)) < text.length() && text.charAt(index) != 'Z' && text.charAt(index) != '+' && text.charAt(index) != '-') {
            throw new TimeFormatException(text);
        }
        int hour = 0;
        if (hourStr != null) {
            hour = Integer.parseInt(hourStr);
        }
        int minute = 0;
        if (minuteStr != null) {
            minute = Integer.parseInt(minuteStr);
        }
        int second = 0;
        if (secondStr != null && secondStr.length() != 0) {
            second = Integer.parseInt(secondStr);
        }
        int microSecond = 0;
        if (microSecondStr != null) {
            microSecond = (int)(Double.parseDouble('.' + microSecondStr) * 1000000.0);
        }
        if (hour < 0 || hour > 23 && (hour != 24 || minute != 0 || second != 0 || microSecond != 0) || minute < 0 || minute > 59 || second < 0 || second > 59 || microSecond < 0 || microSecond > 999999) {
            throw new TimeFormatException(text);
        }
        return ((long)hour * 3600L + (long)minute * 60L + (long)second) * 1000000L + (long)microSecond;
    }

    static enum DatePart {
        CENTURY,
        YEAR,
        MONTH,
        DAY_OF_MONTH,
        WEEK_OF_YEAR,
        DAY_OF_WEEK,
        DATE_END,
        DATE_START;


        DatePart next() {
            DatePart next;
            switch (this) {
                case DATE_START: {
                    next = CENTURY;
                    break;
                }
                case CENTURY: {
                    next = YEAR;
                    break;
                }
                case YEAR: {
                    next = MONTH;
                    break;
                }
                case MONTH: {
                    next = DAY_OF_MONTH;
                    break;
                }
                case WEEK_OF_YEAR: {
                    next = DAY_OF_WEEK;
                    break;
                }
                default: {
                    next = DATE_END;
                }
            }
            return next;
        }
    }
}

