/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import org.jetbrains.annotations.NonNls;

public class LowResolutionTimer {
    private LinkedList<LowResolutionTimerListener> interested;
    private TimerTask task;
    private int timerState;
    private static final int STOPPED = 0;
    private static final int RUNNING = 1;
    private static TaskQueue queue_sd = new TaskQueue();
    private static Worker workerThread;
    private static Object workerThreadLock;
    private static WorkerStats stats_sd;

    public LowResolutionTimer(int period) {
        this((long)period * 1000L);
    }

    private LowResolutionTimer(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be greater than zero");
        }
        this.task = new TimerTask(this, period);
        this.interested = new LinkedList();
        this.timerState = 0;
    }

    public long getNextExecutionTime() {
        return this.task.nextExecutionTime;
    }

    public int getPeriod() {
        return (int)this.task.period / 1000;
    }

    public void add(LowResolutionTimerListener l) {
        this.interested.add(l);
    }

    public void remove(LowResolutionTimerListener l) {
        this.interested.remove(l);
    }

    public void restart() {
        this.restart(this.task.period);
    }

    public void restart(int period) {
        this.restart((long)period * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        TaskQueue taskQueue = queue_sd;
        synchronized (taskQueue) {
            if (this.timerState != 0) {
                return;
            }
            this.timerState = 1;
            queue_sd.add(this.task);
            this.ensureWorker();
            queue_sd.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TaskQueue taskQueue = queue_sd;
        synchronized (taskQueue) {
            if (this.timerState != 1) {
                return;
            }
            this.timerState = 0;
            queue_sd.remove(this.task.index);
            this.task.virgin = true;
            queue_sd.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWorker() {
        Object object = workerThreadLock;
        synchronized (object) {
            if (workerThread == null) {
                workerThread = new Worker();
                workerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be greater than zero");
        }
        TaskQueue taskQueue = queue_sd;
        synchronized (taskQueue) {
            this.task.period = period;
            if (this.timerState == 0) {
                this.timerState = 1;
                queue_sd.add(this.task);
                this.ensureWorker();
            } else {
                queue_sd.reschedule(this.task.index, System.currentTimeMillis() + period);
            }
            queue_sd.notify();
        }
    }

    private void timerFired() {
        Iterator it = this.interested.iterator();
        while (it.hasNext()) {
            LowResolutionTimerListener l = (LowResolutionTimerListener)it.next();
            try {
                l.timerFired(this);
            }
            catch (Exception exc) {
                Log.logWarning(exc);
                it.remove();
            }
        }
        if (this.interested.isEmpty()) {
            this.stop();
        }
    }

    static {
        workerThreadLock = new Object();
        stats_sd = new WorkerStats();
    }

    private static class WorkerStats {
        volatile long lastDelay;
        volatile Time nextWillExecuteAt;

        private WorkerStats() {
        }
    }

    private static class Worker
    extends Thread {
        @NonNls
        private static final String LOW_RESOLUTION_TIMER_THREAD = "LowResolutionTimer Thread";

        Worker() {
            super(LOW_RESOLUTION_TIMER_THREAD);
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    TimerTask t;
                    TaskQueue taskQueue = queue_sd;
                    synchronized (taskQueue) {
                        if (queue_sd.isEmpty()) {
                            Object object = workerThreadLock;
                            synchronized (object) {
                                workerThread = null;
                                return;
                            }
                        }
                        t = queue_sd.getMin();
                        long now = System.currentTimeMillis();
                        long period = t.nextExecutionTime - now;
                        if (period > 0L) {
                            stats_sd.nextWillExecuteAt = Time.valueOf(t.nextExecutionTime * 1000L);
                            queue_sd.wait(period);
                            stats_sd.nextWillExecuteAt = null;
                            continue;
                        }
                        queue_sd.reschedule(1, t.period + System.currentTimeMillis());
                        if (t.virgin) {
                            t.virgin = false;
                            continue;
                        }
                        stats_sd.lastDelay = -period;
                    }
                    t.run();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class TimerTask {
        int index;
        long nextExecutionTime;
        volatile long period;
        boolean virgin;
        private WeakReference<LowResolutionTimer> timer;

        TimerTask(LowResolutionTimer timer, long period) {
            this.period = period;
            this.index = -1;
            this.virgin = true;
            this.timer = new WeakReference<LowResolutionTimer>(timer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            LowResolutionTimer t = (LowResolutionTimer)this.timer.get();
            if (t == null) {
                TaskQueue taskQueue = queue_sd;
                synchronized (taskQueue) {
                    queue_sd.remove(this.index);
                    this.virgin = true;
                }
            } else {
                t.timerFired();
            }
        }
    }

    private static class TaskQueue {
        private TimerTask[] queue = new TimerTask[128];
        private int size = 0;

        private TaskQueue() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        TimerTask getMin() {
            return this.queue[1];
        }

        void add(TimerTask task) {
            if (++this.size == this.queue.length) {
                this.queue = Arrays.copyOf(this.queue, 2 * this.size);
            }
            this.queue[this.size] = task;
            this.queue[this.size].index = this.size;
            this.fixUp(this.size);
        }

        void clear() {
            for (int i = 1; i <= this.size; ++i) {
                this.queue[i] = null;
            }
            this.size = 0;
        }

        void remove(int index) {
            this.queue[index] = this.queue[this.size];
            this.queue[index].index = index;
            this.queue[this.size--] = null;
            this.fixDown(index);
        }

        void removeMin() {
            this.queue[1] = this.queue[this.size];
            this.queue[this.size--] = null;
            this.fixDown(1);
        }

        void reschedule(int index, long newTime) {
            if (index == 1) {
                this.queue[1].nextExecutionTime = newTime;
                this.fixDown(1);
            } else {
                TimerTask task = this.queue[index];
                this.queue[index] = this.queue[this.size];
                this.queue[index].index = index;
                this.queue[this.size] = task;
                this.queue[this.size].nextExecutionTime = newTime;
                this.queue[this.size].index = this.size;
                --this.size;
                this.fixDown(index);
                ++this.size;
                this.fixUp(this.size);
            }
        }

        private void fixDown(int k) {
            int j;
            while ((j = k << 1) <= this.size) {
                if (j < this.size && this.queue[j].nextExecutionTime > this.queue[j + 1].nextExecutionTime) {
                    ++j;
                }
                if (this.queue[k].nextExecutionTime <= this.queue[j].nextExecutionTime) break;
                TimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[j].index = j;
                this.queue[k] = tmp;
                this.queue[k].index = k;
                k = j;
            }
        }

        private void fixUp(int k) {
            while (k > 1) {
                int j = k >> 1;
                if (this.queue[j].nextExecutionTime <= this.queue[k].nextExecutionTime) break;
                TimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[j].index = j;
                this.queue[k] = tmp;
                this.queue[k].index = k;
                k = j;
            }
        }
    }
}

