/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.math.BigDecimal;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;

@Component(module="Fuego.Internal", hideInheritance=true)
public final class Int {
    private final Long value;
    public static final Integer ZERO = 0;
    public static final Integer ONE = 1;
    public static final int UNSIGNEDBYTE_SCALE = -10;
    public static final int POSITIVEINTEGER_SCALE = -11;
    public static final int NEGATIVEINTEGER_SCALE = -12;
    public static final int NONNEGATIVEINTEGER_SCALE = -13;
    public static final int NONPOSITIVEINTEGER_SCALE = -14;
    public static final int UNSIGNEDINT_SCALE = -15;
    public static final int UNSIGNEDLONG_SCALE = -16;
    public static final int UNSIGNEDSHORT_SCALE = -17;
    public static final int INTEGER_SCALE = -18;
    public static final int GDAY_SCALE = -20;
    public static final int GMONTH_SCALE = -21;
    public static final int GYEAR_SCALE = -22;

    public Int(int value) {
        this.value = value;
    }

    public Int(long value) {
        this.value = value;
    }

    public Int(Number value) {
        this.value = value != null ? Long.valueOf(value.longValue()) : null;
    }

    public Int(Long value) {
        this.value = value;
    }

    public Int(Integer value) {
        this.value = value.longValue();
    }

    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static Long dec(Long number) {
        return number == null ? -1L : number - 1L;
    }

    public static Integer dec(Integer number) {
        return number == null ? -1 : number - 1;
    }

    public static Short dec(Short number) {
        return (short)(number == null ? -1 : number - 1);
    }

    public static Byte dec(Byte number) {
        return (byte)(number == null ? -1 : number - 1);
    }

    public static Long inc(Long number) {
        return number == null ? 1L : number + 1L;
    }

    public static Integer inc(Integer number) {
        return number == null ? 1 : number + 1;
    }

    public static Short inc(Short number) {
        return (short)(number == null ? 1 : number + 1);
    }

    public static Byte inc(Byte number) {
        return (byte)(number == null ? 1 : number + 1);
    }

    public static int numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    @Deprecated
    public static Integer cachedValue(int value) {
        return value;
    }

    public static Long negate(Long number) {
        return number == null ? 0L : -number.longValue();
    }

    public static Integer negate(Integer number) {
        return number == null ? 0 : -number.intValue();
    }

    public static Short negate(Short number) {
        return number == null ? (short)0 : -number.shortValue();
    }

    public static Byte negate(Byte number) {
        return number == null ? (byte)0 : -number.byteValue();
    }

    public static int parse(String text, int offset, int length) {
        return Int.parse(text, offset, length, 10);
    }

    public static int parse(String text, int offset, int length, int radix) {
        int digit;
        int limit;
        if (text == null) {
            throw new NumberFormatException("null");
        }
        Int.checkRadix(radix);
        int result = 0;
        boolean negative = false;
        int i = offset;
        int max = offset + length;
        Int.checkLength(text, length);
        if (text.charAt(i) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        if (i < max) {
            if ((digit = Character.digit(text.charAt(i++), radix)) < 0) {
                throw new NumberFormatException(text);
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(text.charAt(i++), radix)) < 0) {
                throw new NumberFormatException(text);
            }
            if (result < multmin) {
                throw new NumberFormatException(text);
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException(text);
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(text);
        }
        return -result;
    }

    public static Byte asByte(Object value) {
        return value == null ? null : Byte.valueOf((byte)Int.intValue(value));
    }

    public static Integer asInteger(Object value) {
        return value == null ? null : Integer.valueOf(Int.intValue(value));
    }

    public static Long asLong(Object value) {
        return value == null ? null : Long.valueOf(Int.longValue(value));
    }

    public static Short asShort(Object value) {
        return value == null ? null : Short.valueOf((short)Int.intValue(value));
    }

    public static int intValue(Object value) {
        return (int)Int.longValue(value);
    }

    public static long longValue(Number value) {
        return value == null ? 0L : value.longValue();
    }

    public static long longValue(String value) {
        return value == null || value.length() < 1 ? 0L : Long.parseLong(value);
    }

    public static long longValue(Interval value) {
        return value == null ? 0L : value.getTotalMicroseconds();
    }

    public static long longValue(Time value) {
        return value == null ? 0L : value.getMicroSeconds();
    }

    public static long longValue(Object value) {
        if (value == null || value instanceof Number) {
            return Int.longValue((Number)value);
        }
        if (value instanceof String) {
            return Int.longValue((String)value);
        }
        if (value instanceof Interval) {
            return Int.longValue((Interval)value);
        }
        if (value instanceof Time) {
            return Int.longValue((Time)value);
        }
        if (value instanceof byte[]) {
            return Int.longValue(Binary.deserialize((byte[])value));
        }
        throw new IllegalConversionException(value, "Int");
    }

    @Deprecated
    @Hidden
    public static int valueOf(String s) {
        return Integer.parseInt(s);
    }

    @Deprecated
    public static Integer valueOf(int i) {
        return i;
    }

    @Deprecated
    public long longValue() {
        return this.value();
    }

    @Deprecated
    public int intValue() {
        return Int.intValue(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Int)) {
            return false;
        }
        Int i = (Int)obj;
        if (this.value == null) {
            return i.value == null;
        }
        return this.value.equals(i.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public long abs() {
        return this.value() < 0L ? -this.value() : this.value();
    }

    public double acos() {
        return Math.acos(this.value());
    }

    public double atan() {
        return Math.atan(this.value());
    }

    public double ceil() {
        return this.value();
    }

    public double exp() {
        return Math.exp(this.value());
    }

    public double floor() {
        return this.value();
    }

    public double log() {
        return Math.log(this.value());
    }

    public long max(long number) {
        return this.value() > number ? this.value() : number;
    }

    public double max(double number) {
        return (double)this.value() > number ? (double)this.value() : number;
    }

    public BigDecimal max(BigDecimal number) {
        return number != null ? number.max(BigDecimal.valueOf(this.value())) : BigDecimal.valueOf(this.value());
    }

    public long min(long number) {
        return this.value() < number ? this.value() : number;
    }

    public double min(double number) {
        return (double)this.value() < number ? (double)this.value() : number;
    }

    public BigDecimal min(BigDecimal number) {
        return number != null ? number.min(BigDecimal.valueOf(this.value())) : BigDecimal.valueOf(this.value());
    }

    public double asin() {
        return Math.asin(this.value());
    }

    public double cos() {
        return Math.cos(this.value());
    }

    public double pow(double number) {
        return Math.pow(this.value(), number);
    }

    public double round() {
        return this.value();
    }

    public double sin() {
        return Math.sin(this.value());
    }

    public double sqrt() {
        return Math.sqrt(this.value());
    }

    public double tan() {
        return Math.tan(this.value());
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    private static void checkLength(String text, int length) {
        if (length == 0) {
            throw new NumberFormatException(text);
        }
    }

    private static void checkRadix(int radix) {
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than MAX_RADIX");
        }
    }

    private long value() {
        return this.value != null ? this.value : 0L;
    }

    public static final class ObjHolder {
        public Long value;

        public ObjHolder() {
        }

        public ObjHolder(Long init) {
            this.value = init;
        }

        public void put(Number number) {
            this.value = number == null ? 0L : number.longValue();
        }
    }

    public static final class Holder {
        public long value;

        public Holder() {
        }

        public Holder(long init) {
            this.value = init;
        }

        public void put(Number number) {
            this.value = number == null ? 0L : number.longValue();
        }
    }
}

