/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.AssociativeArray;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.CompositeDynamicObject;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Serializer;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.util.Base64;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.NumberFormatter;
import oracle.bpm.util.PrimitiveTypeUtils;
import org.jetbrains.annotations.NonNls;

public abstract class DynamicObject
implements ArgumentMap {
    @NonNls
    protected static final String PROCESS_CLASSLOADER_PROPERTY = "fuego.process.classloader";
    @NonNls
    public static final String PARENT_REFERENCE_FIELD = "__parent";
    @NonNls
    private static final String STACKTRACE_FIELD = "fuegoStackTrace";
    @NonNls
    private static final String WRITE_DYNAMIC_OBJECT_METHOD = "writeDynamicObject";
    @NonNls
    private static final String VALUEOF_METHOD = "valueOf";
    @NonNls
    private static final String READ_DYNAMIC_OBJECT_METHOD = "readDynamicObject";
    public static final DynamicObject NULL = new Null();
    static final long serialVersionUID = 1004201052112374001L;
    static final long serialCheck = 3466530625058528706L;
    private static final Class<?>[] MAP_ARGS = new Class[]{Map.class};
    private static final Class<?>[] DYNAMIC_OBJECT_ARGS = new Class[]{DynamicObject.class};
    private static final Class<?>[] DYNAMIC_OBJECT_AND_MAP_ARGS = new Class[]{DynamicObject.class, Map.class};
    private static final Class<?>[] DYNAMIC_OBJECT_AND_TYPE_AND_MAP_ARGS = new Class[]{DynamicObject.class, Class.class, Map.class};

    public abstract void serialize(Serializer var1);

    public static DynamicObject create() {
        return new CompositeDynamicObject(false);
    }

    public static DynamicObject createList() {
        return new Array(false);
    }

    public static DynamicObject createMap() {
        return new AssociativeArray(false);
    }

    public static DynamicObject defaultValueOf(Object value) {
        return DynamicObject.defaultValueOf(value, false);
    }

    public static DynamicObject defaultValueOf(Object value, boolean quote) {
        return DynamicObject.defaultValueOf(value, quote, DynamicObject.initReferences());
    }

    public static DynamicObject defaultValueOf(Object value, boolean quote, Map<Object, Object> references) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof DynamicObject) {
            DynamicObject ret = (DynamicObject)value;
            return quote ? DynamicObject.valueOf(ret.quote(), false) : ret;
        }
        if (value instanceof String || value instanceof Character) {
            return new Str(value.toString());
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value instanceof Double || value instanceof Float) {
                return new Real(num.doubleValue());
            }
            if (value instanceof BigDecimal) {
                return new Decimal((BigDecimal)value);
            }
            return new Int(num.longValue());
        }
        if (value instanceof Boolean) {
            return new Bool((Boolean)value);
        }
        if (value instanceof Time) {
            return new TimeObj((Time)value);
        }
        if (value instanceof Date) {
            return new TimeObj((Date)value);
        }
        if (value instanceof Interval) {
            return new IntervalObj((Interval)value);
        }
        if (value instanceof byte[]) {
            return new Binary((byte[])value);
        }
        DynamicObject dobj = (DynamicObject)references.get(value);
        if (dobj != null) {
            return dobj;
        }
        Class<?> cl = value.getClass();
        if (Map.class.isAssignableFrom(cl)) {
            return new AssociativeArray((Map)value, quote, references);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new Array((Collection)value, quote, references);
        }
        if (cl.isArray()) {
            return new Array(value, quote, references);
        }
        if (value instanceof Class) {
            Class javaClass = (Class)value;
            return new Str(javaClass.getName());
        }
        CompositeDynamicObject composite = new CompositeDynamicObject(value, quote, references);
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            StringWriter stackTrace = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stackTrace));
            composite.setField(STACKTRACE_FIELD, stackTrace.toString());
        }
        return composite;
    }

    public static DynamicObject valueOf(long value) {
        return new Int(value);
    }

    public static DynamicObject valueOf(double value) {
        return new Real(value);
    }

    public static DynamicObject valueOf(boolean value) {
        return new Bool(value);
    }

    public static DynamicObject valueOf(Object value) {
        return DynamicObject.valueOf(value, false);
    }

    public static DynamicObject valueOf(Object value, boolean quote) {
        return DynamicObject.valueOf(value, quote, DynamicObject.initReferences());
    }

    public static DynamicObject valueOf(Object value, boolean quote, Map<Object, Object> references) {
        if (value instanceof Dynamizable) {
            try {
                Class<?> cl = value.getClass();
                try {
                    Method write = JavaClass.getDeclaredMethod(cl, WRITE_DYNAMIC_OBJECT_METHOD, MAP_ARGS);
                    write.setAccessible(true);
                    return (DynamicObject)write.invoke(value, references);
                }
                catch (NoSuchMethodException e) {
                    Method write = JavaClass.getDeclaredMethod(cl, WRITE_DYNAMIC_OBJECT_METHOD, null);
                    write.setAccessible(true);
                    return (DynamicObject)write.invoke(value, (Object[])null);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeExceptionShell(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeExceptionShell(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeExceptionShell(e);
            }
        }
        return DynamicObject.defaultValueOf(value, quote, references);
    }

    public static final Class getIndexType() {
        return null;
    }

    public static final boolean isQuoted() {
        return false;
    }

    public Object getPrevious() {
        return null;
    }

    public final void addElement(Object value) throws UnsupportedOperationException {
        this.asList().add(value);
    }

    public final void addElement(boolean value) throws UnsupportedOperationException {
        this.asList().add(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addElement(long value) throws UnsupportedOperationException {
        this.asList().add(value);
    }

    public final void addElement(double value) throws UnsupportedOperationException {
        this.asList().add(value);
    }

    @Override
    public final DynamicObject asDynamicObject() {
        return this;
    }

    public Map<String, Object> asFieldsMap() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("asFieldsMap() is not supported for : " + this.getClassName());
    }

    public List<Object> asList() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("asList() is not supported for : " + this.getClassName());
    }

    @Override
    public final Map<String, Object> asMap() throws UnsupportedOperationException {
        return this.asFieldsMap();
    }

    public boolean booleanValue() {
        return Boolean.valueOf(this.toString());
    }

    @Override
    public final boolean contains(String argumentName) {
        return this.getField(argumentName) != NULL;
    }

    public <T> T convertTo(Class<T> target) {
        return this.convertTo(target, DynamicObject.initReferences());
    }

    public final Object convertTo(Field field) {
        return this.convertTo(field, DynamicObject.initReferences());
    }

    public <T> T convertTo(Class<T> target, Map<Object, Object> references) {
        return this.convertTo(target, null, references);
    }

    public <T> T convertTo(Class<T> target, Class<?> elementType, Map<Object, Object> references) {
        Object result;
        if (target == String.class) {
            result = this.toString();
        } else if (target == Long.class || target == Long.TYPE) {
            result = this.longValue();
        } else if (target == BigDecimal.class) {
            result = this.decimalValue();
        } else if (target == Double.class || target == Double.TYPE) {
            result = this.doubleValue();
        } else if (target == Time.class) {
            result = this.timeValue();
        } else if (target == Interval.class) {
            result = this.intervalValue();
        } else if (target.isEnum()) {
            result = this.enumValue(target);
        } else if (DynamicObject.class.isAssignableFrom(target)) {
            result = this;
        } else if (target == Class.class) {
            try {
                result = Class.forName(this.toString(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                result = null;
                Log.logWarning(e);
            }
        } else if (Dynamizable.class.isAssignableFrom(target)) {
            result = DynamicObject.callCustomRead(this, target, null, references);
        } else {
            Object value = this.objectValue();
            if (target.isArray() && value != null && !value.getClass().isArray() && !(value instanceof List)) {
                Class<?> arrayElemType = target.getComponentType();
                result = java.lang.reflect.Array.newInstance(arrayElemType, 1);
                java.lang.reflect.Array.set(result, 0, Conversion.convertTo(value, arrayElemType));
            } else {
                result = Conversion.convertTo(value, target);
            }
        }
        return Cast.autoBoxingCast(target, result);
    }

    public void setPrevious(Object previous) {
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.toString());
    }

    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public Enum enumValue(Class<?> targetClass) {
        try {
            Method method = targetClass.getMethod(VALUEOF_METHOD, String.class);
            return (Enum)method.invoke(null, this.getField("name").toString());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DynamicObject)) {
            return false;
        }
        DynamicObject dynamic = (DynamicObject)obj;
        Object left = this.objectValue();
        Object right = dynamic.objectValue();
        return dynamic.isPredefined() && (left == null ? left == right : left.equals(right));
    }

    @Override
    public final <T> T getArgument(String argumentName, Class<T> argumentClass) {
        return this.getField(argumentName).convertTo(argumentClass);
    }

    public DynamicObject getElement(Object key) {
        return NULL;
    }

    public DynamicObject getElementAt(int index) {
        return NULL;
    }

    public Class<?> getElementType() {
        return null;
    }

    public DynamicObject getField(String fieldName) {
        return NULL;
    }

    public String getJavaClassName() {
        return "java.lang.Object";
    }

    public int hashCode() {
        Object val = this.objectValue();
        return val == null ? 0 : val.hashCode();
    }

    public Interval intervalValue() {
        return Interval.valueOf(this.toString());
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isBool() {
        return false;
    }

    public boolean isComposite() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isInterval() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isAssociativeArray() {
        return false;
    }

    public boolean isPredefined() {
        return true;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isTime() {
        return false;
    }

    public long longValue() {
        return Long.parseLong(this.toString());
    }

    public Object objectValue() {
        return this.toString();
    }

    public final Quote quote() {
        Quote result = new Quote();
        result.value = this;
        return result;
    }

    public final void removeElementAt(int index) throws UnsupportedOperationException {
        this.asList().remove(index);
    }

    @Override
    public final void setArgument(String argumentName, boolean value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, byte value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, char value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, short value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, int value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, long value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, float value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, double value) {
        this.setField(argumentName, value);
    }

    @Override
    public final void setArgument(String argumentName, Object value) {
        this.setField(argumentName, value);
    }

    public void setElement(Object key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setElement(key,value) is not supported for : " + this.getClassName());
    }

    public final void setElementAt(int index, Object value) throws UnsupportedOperationException {
        this.asList().set(index, value);
    }

    public final Object setField(String fieldName, Object value) throws UnsupportedOperationException {
        this.asFieldsMap().put(fieldName, value);
        return value;
    }

    public final boolean setField(String fieldName, boolean value) throws UnsupportedOperationException {
        this.asFieldsMap().put(fieldName, value ? Boolean.TRUE : Boolean.FALSE);
        return value;
    }

    public final long setField(String fieldName, long value) throws UnsupportedOperationException {
        this.asFieldsMap().put(fieldName, value);
        return value;
    }

    public final int setField(String fieldName, int value) throws UnsupportedOperationException {
        return (int)this.setField(fieldName, (long)value);
    }

    public final double setField(String fieldName, double value) throws UnsupportedOperationException {
        this.asFieldsMap().put(fieldName, value);
        return value;
    }

    public final float setField(String fieldName, float value) throws UnsupportedOperationException {
        return (float)this.setField(fieldName, (double)value);
    }

    public final Object setFieldQ(String fieldName, Object value) throws UnsupportedOperationException {
        this.asFieldsMap().put(fieldName, DynamicObject.valueOf(value, true));
        return value;
    }

    public void setJavaClassName(String classname) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setJavaClassName() is not supported for : " + this.getClassName());
    }

    public Time timeValue() {
        return Time.valueOf(this.toString());
    }

    public Map<DynamicObject, DynamicObject> asAssociativeArray() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("asAssociativeArray() is not supported for : " + this.getClassName());
    }

    protected static Class<?> elementType(Field field) {
        try {
            Class<?> targetClass = field.getDeclaringClass();
            Field declaredField = targetClass.getDeclaredField(field.getName() + "_ELEMENT_");
            if (declaredField == null) {
                declaredField = targetClass.getDeclaredField(field.getName() + "$element");
            }
            return declaredField.getType();
        }
        catch (NoSuchFieldException e) {
            return Object.class;
        }
    }

    protected static Class<?> elementType(Class<?> targetClass, String name) {
        try {
            Field declaredField = targetClass.getDeclaredField(name + "_ELEMENT_");
            if (declaredField == null) {
                declaredField = targetClass.getDeclaredField(name + "$element");
            }
            return declaredField.getType();
        }
        catch (NoSuchFieldException e) {
            return Object.class;
        }
    }

    protected static Class<?> indexType(Field field) {
        try {
            Class<?> targetClass = field.getDeclaringClass();
            Field declaredField = targetClass.getDeclaredField(field.getName() + "_INDEX_");
            if (declaredField == null) {
                declaredField = targetClass.getDeclaredField(field.getName() + "$index");
            }
            return declaredField.getType();
        }
        catch (NoSuchFieldException e) {
            return Object.class;
        }
    }

    protected static boolean mustSerialize(Field field) {
        int modifier = field.getModifiers();
        return !Modifier.isTransient(modifier) && !Modifier.isStatic(modifier);
    }

    protected Object convertTo(Field field, Map<Object, Object> references) {
        return this.convertTo(field.getType(), references);
    }

    static <T> T instantiate(Class<T> target) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return DynamicObject.instantiate(target, null);
    }

    static <T> T instantiate(Class<T> target, Object parent) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T result = DefaultValue.forClass(target, false);
        if (result == null) {
            result = JavaClass.fromClass(target).newInstance();
        }
        if (result == null) {
            try {
                Object[] objectArray;
                Constructor<T> constructor = DynamicObject.findConstructor(target, parent);
                if (constructor == null) {
                    throw new InstantiationException("Class '" + target.getName() + "' doesn't have a constructor without arguments");
                }
                constructor.setAccessible(true);
                if (parent == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = parent;
                }
                result = constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException e) {
                InstantiationException e2 = new InstantiationException("An exception was thrown trying to instantiate " + target.getName() + ": " + e.toString());
                e2.initCause(e);
                throw e2;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    static Object callCustomRead(DynamicObject dobj, Class target, Class elementType, Map references) {
        try {
            try {
                block8: {
                    if (elementType != null) break block8;
                    Method read = JavaClass.getDeclaredMethod(target, READ_DYNAMIC_OBJECT_METHOD, DYNAMIC_OBJECT_AND_MAP_ARGS);
                    read.setAccessible(true);
                    return read.invoke(null, dobj, references);
                }
                Method read = JavaClass.getDeclaredMethod(target, READ_DYNAMIC_OBJECT_METHOD, DYNAMIC_OBJECT_AND_TYPE_AND_MAP_ARGS);
                read.setAccessible(true);
                return read.invoke(null, dobj, elementType, references);
            }
            catch (NoSuchMethodException e) {
                Method read = JavaClass.getDeclaredMethod(target, READ_DYNAMIC_OBJECT_METHOD, DYNAMIC_OBJECT_ARGS);
                read.setAccessible(true);
                return read.invoke(null, dobj);
                {
                    catch (NoSuchMethodException e2) {
                        throw new RuntimeExceptionShell(e2);
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    private static IdentityHashMap<Object, Object> initReferences() {
        return new IdentityHashMap<Object, Object>();
    }

    private static <T> Constructor<T> findConstructor(Class<T> target, Object parent) {
        Constructor constructor = null;
        if (parent == null) {
            try {
                constructor = target.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
        } else {
            for (Constructor<?> constr : target.getDeclaredConstructors()) {
                Class<?>[] paramTypes = constr.getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(parent.getClass())) continue;
                constructor = (Constructor)Cast.force(constr);
            }
        }
        return constructor;
    }

    private String getClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(36);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        return className;
    }

    private static final class Null
    extends DynamicObject {
        static final long serialCheck = -6982323251964969914L;
        static final long serialVersionUID = 4744320085662727893L;

        Null() {
        }

        @Override
        public boolean booleanValue() {
            return false;
        }

        @Override
        public <T> T convertTo(Class<T> cl, Map<Object, Object> references) {
            Null result = null;
            if (DynamicObject.class.isAssignableFrom(cl)) {
                result = this;
            } else if (cl.isPrimitive()) {
                result = DefaultValue.forClass(cl);
            }
            Class clazz = (Class)Cast.force(PrimitiveTypeUtils.box(cl));
            return clazz.cast(result);
        }

        @Override
        public BigDecimal decimalValue() {
            return BigDecimal.ZERO;
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public Interval intervalValue() {
            return Interval.ZERO;
        }

        @Override
        public long longValue() {
            return 0L;
        }

        @Override
        public Object objectValue() {
            return null;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeNull();
        }

        @Override
        public Time timeValue() {
            return Time.valueOf(0L);
        }

        public String toString() {
            return "";
        }
    }

    static final class TimeObj
    extends DynamicObject {
        private final Time value;
        static final long serialCheck = 9073654072788385194L;
        static final long serialVersionUID = 2185685228333058483L;

        TimeObj(Time value) {
            this.value = value;
        }

        TimeObj(Date value) {
            this.value = Time.valueOf(value);
        }

        @Override
        public BigDecimal decimalValue() {
            return Conversion.tojava_math_BigDecimal(this.value);
        }

        @Override
        public double doubleValue() {
            return Conversion.todouble(this.value);
        }

        @Override
        public Interval intervalValue() {
            return Conversion.tooracle_bpm_lang_Interval(this.value);
        }

        @Override
        public boolean isTime() {
            return true;
        }

        @Override
        public long longValue() {
            return Conversion.tolong(this.value);
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeTime(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            return this.value.format();
        }
    }

    static final class Str
    extends DynamicObject {
        private final String value;
        static final long serialCheck = -4278252082693073653L;
        static final long serialVersionUID = 1732991782929115617L;

        Str(String value) {
            this.value = value;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeString(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    static final class Real
    extends DynamicObject {
        private final double value;
        static final long serialCheck = 6064056695923708604L;
        static final long serialVersionUID = 1244909419840074474L;

        Real(double value) {
            this.value = value;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal(String.valueOf(this.value));
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Interval intervalValue() {
            return Conversion.tooracle_bpm_lang_Interval(this.value);
        }

        @Override
        public boolean isReal() {
            return true;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeReal(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            return NumberFormatter.format(this.value);
        }
    }

    static final class IntervalObj
    extends DynamicObject {
        private final Interval value;
        static final long serialCheck = 6216188192381631481L;
        static final long serialVersionUID = -5887020177367123624L;

        IntervalObj(Interval value) {
            this.value = value;
        }

        @Override
        public BigDecimal decimalValue() {
            return Conversion.tojava_math_BigDecimal(this.value);
        }

        @Override
        public double doubleValue() {
            return Conversion.todouble(this.value);
        }

        @Override
        public Interval intervalValue() {
            return this.value;
        }

        @Override
        public boolean isInterval() {
            return true;
        }

        @Override
        public long longValue() {
            return Conversion.tolong(this.value);
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeInterval(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Int
    extends DynamicObject {
        private final long value;
        static final long serialCheck = -6833830331884539727L;
        static final long serialVersionUID = 6550583924715176193L;

        Int(long value) {
            this.value = value;
        }

        @Override
        public Interval intervalValue() {
            return Interval.valueOf(this.value);
        }

        @Override
        public boolean isInt() {
            return true;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeInt(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            return NumberFormatter.format(this.value);
        }
    }

    static final class Decimal
    extends DynamicObject {
        private final BigDecimal value;
        static final long serialCheck = -7544708025623369098L;
        static final long serialVersionUID = 7173724119957757044L;

        Decimal(BigDecimal value) {
            this.value = value;
        }

        @Override
        public BigDecimal decimalValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value.doubleValue();
        }

        @Override
        public Interval intervalValue() {
            return Conversion.tooracle_bpm_lang_Interval(this.value);
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        public long longValue() {
            return this.value.longValue();
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeDecimal(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            return NumberFormatter.format(this.value);
        }
    }

    static final class Bool
    extends DynamicObject {
        private final boolean value;
        static final long serialCheck = 3348853462761419961L;
        static final long serialVersionUID = -3848287275484390035L;

        Bool(boolean value) {
            this.value = value;
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }

        @Override
        public boolean isBool() {
            return true;
        }

        @Override
        public Object objectValue() {
            return this.value ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeBoolean(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Binary
    extends DynamicObject {
        private final byte[] value;
        static final long serialCheck = 3048812545028174536L;
        static final long serialVersionUID = 2365052575725799757L;

        Binary(byte[] value) {
            this.value = value;
        }

        @Override
        public boolean booleanValue() {
            return Conversion.toboolean(this.value);
        }

        @Override
        public <T> T convertTo(Class<T> cl, Map<Object, Object> references) {
            Object result = DynamicObject.class.isAssignableFrom(cl) ? this : (cl.equals(byte[].class) ? (this.value != null ? (byte[])this.value.clone() : null) : super.convertTo(cl, references));
            return cl.cast(result);
        }

        @Override
        public BigDecimal decimalValue() {
            return Conversion.tojava_math_BigDecimal(this.value);
        }

        @Override
        public double doubleValue() {
            return Conversion.todouble(this.value);
        }

        @Override
        public Interval intervalValue() {
            return Conversion.tooracle_bpm_lang_Interval(this.value);
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public long longValue() {
            return Conversion.tolong(this.value);
        }

        @Override
        public Object objectValue() {
            return this.value;
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeBinary(this.value);
        }

        @Override
        public Time timeValue() {
            return Conversion.tooracle_bpm_lang_Time(this.value);
        }

        public String toString() {
            try {
                return oracle.bpm.lang.Binary.valueOf(this.value).toString();
            }
            catch (IllegalConversionException e) {
                return Base64.encode(this.value);
            }
        }
    }

    static final class Array
    extends DynamicObject {
        private final RefArrayList values;
        static final long serialCheck = -6402786257012505308L;
        static final long serialVersionUID = 2281162355517158303L;

        Array(boolean quote) {
            this.values = new RefArrayList(quote);
        }

        Array(Collection collection, boolean quote, Map<Object, Object> references) {
            this(quote);
            Object obj = references.get(collection);
            if (obj == null) {
                references.put(collection, this);
            }
            for (Object value : collection.toArray()) {
                this.values.add(value, references);
            }
        }

        Array(Object[] values, boolean quote, Map<Object, Object> references) {
            this(quote);
            if (!references.containsKey(values)) {
                references.put(values, this);
            }
            for (Object value : values) {
                this.values.add(value, references);
            }
        }

        Array(Object array, boolean quote, Map<Object, Object> references) {
            this(quote);
            Object obj = references.get(array);
            if (obj == null) {
                references.put(array, this);
            }
            assert (array.getClass().isArray()) : "Not an array: " + array.getClass();
            int length = java.lang.reflect.Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Object value = java.lang.reflect.Array.get(array, i);
                this.values.add(value, references);
            }
        }

        @Override
        public List<Object> asList() {
            return this.values;
        }

        @Override
        public <T> T convertTo(Class<T> cl, Map<Object, Object> references) {
            return this.convertTo(cl, Object.class, references);
        }

        @Override
        public Object convertTo(Field field, Map<Object, Object> references) {
            return this.convertTo(field.getType(), DynamicObject.elementType(field), references);
        }

        @Override
        public boolean equals(Object obj) {
            boolean result = obj instanceof DynamicObject;
            if (result) {
                DynamicObject dynamic = (DynamicObject)obj;
                result = dynamic.isList() && ((Object)this.asList()).equals(dynamic.asList());
            }
            return result;
        }

        @Override
        public DynamicObject getElementAt(int index) {
            return (DynamicObject)this.values.get(index);
        }

        @Override
        public Class<?> getElementType() {
            return this.values.elementType;
        }

        @Override
        public int hashCode() {
            return ((Object)this.asList()).hashCode();
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public Object objectValue() {
            return this.convertTo(ArrayList.class);
        }

        @Override
        public <T> T convertTo(Class<T> target) {
            return super.convertTo(target);
        }

        @Override
        public void serialize(Serializer serializer) {
            serializer.serializeList(this);
        }

        public String toString() {
            return this.asList().toString();
        }

        @Override
        public <T> T convertTo(Class<T> target, Class<?> elementType, Map<Object, Object> references) {
            return target.cast(this.doConversion(target, elementType, references));
        }

        private static <T> Collection<T> createImplFor(Class<Collection<T>> cl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            if (!cl.isInterface() && !Modifier.isAbstract(cl.getModifiers())) {
                return Array.instantiate(cl);
            }
            if (List.class.isAssignableFrom(cl)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(cl)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(cl)) {
                return new HashSet();
            }
            if (Collection.class.isAssignableFrom(cl)) {
                return new ArrayList();
            }
            throw new RuntimeException("Illegal conversion to " + cl);
        }

        private <T, E> Object doConversion(Class<T> target, Class<E> elementType, Map<Object, Object> references) {
            if (DynamicObject.class.isAssignableFrom(target)) {
                return this;
            }
            Object ref = references.get(this);
            if (ref != null && target.isInstance(ref)) {
                return ref;
            }
            try {
                if (Collection.class.isAssignableFrom(target)) {
                    Class colClass = (Class)Cast.force(target);
                    return this.toCollection(colClass, elementType, this.values.size(), references);
                }
                if (target.isArray()) {
                    return this.toArray(target, this.values.size(), references);
                }
                if (target.equals(Object.class)) {
                    return this.convertTo(ArrayList.class, elementType, references);
                }
                return target.isInterface() ? null : Array.instantiate(target);
            }
            catch (IllegalAccessException e) {
                throw new IllegalConversionException(this.getClass().getName(), target.getName(), e.toString());
            }
            catch (InstantiationException e) {
                throw new IllegalConversionException(this.getClass().getName(), target.getName(), e.toString());
            }
            catch (InvocationTargetException e) {
                throw new IllegalConversionException(this.getClass().getName(), target.getName(), e.toString());
            }
        }

        private Object toArray(Class<?> cl, int length, Map<Object, Object> references) {
            Class<?> elemType = cl.getComponentType();
            Object array = java.lang.reflect.Array.newInstance(elemType, length);
            references.put(this, array);
            for (int i = 0; i < length; ++i) {
                DynamicObject element = (DynamicObject)this.values.get(i);
                java.lang.reflect.Array.set(array, i, element.convertTo(elemType, references));
            }
            return array;
        }

        private <T> Collection<T> toCollection(Class<Collection<T>> cl, Class<T> elemType, int length, Map<Object, Object> references) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            Collection<T> list = Array.createImplFor(cl);
            references.put(this, list);
            for (int i = 0; i < length; ++i) {
                list.add(((DynamicObject)this.values.get(i)).convertTo(elemType, references));
            }
            return list;
        }

        private static final class RefArrayList
        extends ArrayList<Object> {
            private Class<?> elementType;
            private final boolean quote;
            static final long serialCheck = -7196664183949268687L;
            static final long serialVersionUID = 5513841351753804478L;

            RefArrayList(boolean quote) {
                this.quote = quote;
            }

            @Override
            public boolean add(Object element) {
                this.updateElementType(element);
                return super.add(DynamicObject.valueOf(element, this.quote));
            }

            public boolean add(Object element, Map<Object, Object> references) {
                this.updateElementType(element);
                return super.add(DynamicObject.valueOf(element, this.quote, references));
            }

            @Override
            public void add(int index, Object element) {
                this.updateElementType(element);
                super.add(index, DynamicObject.valueOf(element, this.quote));
            }

            @Override
            public boolean addAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int index, Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOf(Object element) {
                return super.indexOf(DynamicObject.valueOf(element, this.quote));
            }

            @Override
            public int lastIndexOf(Object element) {
                return super.lastIndexOf(DynamicObject.valueOf(element, this.quote));
            }

            @Override
            public boolean remove(Object element) {
                return super.remove(DynamicObject.valueOf(element, this.quote));
            }

            @Override
            public Object set(int index, Object element) {
                this.updateElementType(element);
                return super.set(index, DynamicObject.valueOf(element, this.quote));
            }

            private void updateElementType(Object value) {
                if (value != null) {
                    Class<?> cl = value.getClass();
                    if (this.elementType == null) {
                        this.elementType = cl;
                    } else if (this.elementType != cl && !this.elementType.isAssignableFrom(cl)) {
                        this.elementType = cl;
                    }
                }
            }
        }
    }

    public static final class X {
        public String text;
    }

    public static final class Quote {
        public DynamicObject value;
    }

    public static interface Dynamizable {
    }
}

