/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Calendar;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.util.DateFormatSymbolUtils;

@Component(module="Fuego.Lang")
public enum Day implements I18nProvider
{
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY;


    public static Day valueOf(Calendar calendar) {
        return Day.values()[calendar.get(7) - 1];
    }

    public static Day valueOf(Time time) {
        return Day.valueOf(time.getCalendar());
    }

    public Day next() {
        Day[] days = Day.values();
        return days[(this.ordinal() + 1) % days.length];
    }

    public Day prev() {
        Day[] days = Day.values();
        int len = days.length;
        return days[(this.ordinal() + len - 1) % len];
    }

    public int intValue() {
        return this.ordinal();
    }

    @Override
    public String getString() {
        return this.getString(Locale.getDefault());
    }

    @Override
    public String getString(Locale locale) {
        return DateFormatSymbolUtils.getLocalizedWeekDayNames(locale)[this.ordinal() + 1];
    }

    public String getShortString() {
        return this.getShortString(Locale.getDefault());
    }

    public String getShortString(Locale locale) {
        return DateFormatSymbolUtils.getLocalizedShortWeekDays(locale)[this.ordinal() + 1];
    }

    @Exclude
    public static Day compatibleValueOf(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int index = Integer.parseInt(name);
            Day[] days = Day.values();
            return index >= 0 && index < days.length ? days[index] : null;
        }
        return Day.valueOf(name);
    }
}

