/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Serializer;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.xml.BaseSerializer;
import oracle.bpm.xml.XMLSerializerWriter;

final class CompositeDynamicObject
extends DynamicObject {
    private String javaClassName;
    private final CompositeMap map;
    private Object previous;
    static final long serialCheck = -2809765918428897712L;
    static final long serialVersionUID = -3496126105202084974L;

    CompositeDynamicObject(boolean quote) {
        this.map = new CompositeMap(quote);
    }

    CompositeDynamicObject(Object object, boolean quote, Map<Object, Object> references) {
        Class<?> cl;
        block7: {
            this(quote);
            references.put(object, this);
            cl = object.getClass();
            this.javaClassName = cl.getName();
            int isInnerClass = this.javaClassName.indexOf(36);
            if (isInnerClass != -1) {
                try {
                    Field parentField = JavaClass.getParentField(cl);
                    parentField.setAccessible(true);
                    Object parent = parentField.get(object);
                    this.map.put("__parent", parent, references);
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)e);
                }
            }
        }
        try {
            Field[] flds;
            for (Field fld : flds = CompositeDynamicObject.fields(cl)) {
                if (object == fld.get(object) || !DynamicObject.mustSerialize(fld)) continue;
                this.map.put(fld.getName(), fld.get(object), references);
            }
        }
        catch (IllegalAccessException iae) {
            iae.toString();
        }
    }

    @Override
    public Map<String, Object> asFieldsMap() {
        return this.map;
    }

    @Override
    public <T> T convertTo(Class<T> target, Map<Object, Object> references) {
        return this.convertTo(target, Object.class, references);
    }

    @Override
    public Object convertTo(Field field, Map<Object, Object> references) {
        return this.convertTo(field.getType(), DynamicObject.elementType(field), references);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DynamicObject)) {
            return false;
        }
        DynamicObject d = (DynamicObject)obj;
        return d.isComposite() && ((Object)this.asFieldsMap()).equals(d.asFieldsMap());
    }

    @Override
    public DynamicObject getField(String fieldName) {
        DynamicObject value = (DynamicObject)this.map.get(fieldName);
        return value != null ? value : NULL;
    }

    @Override
    public String getJavaClassName() {
        return this.javaClassName;
    }

    @Override
    public int hashCode() {
        return ((Object)this.asFieldsMap()).hashCode();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public Object objectValue() {
        return this.convertTo(Object.class);
    }

    @Override
    public <T> T convertTo(Class<T> target) {
        return super.convertTo(target);
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.serializeComposite(this);
    }

    @Override
    public Object getPrevious() {
        return this.previous;
    }

    @Override
    public void setJavaClassName(String classname) throws UnsupportedOperationException {
        this.javaClassName = classname;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        XMLSerializerWriter xml = new XMLSerializerWriter((Writer)writer, (oracle.bpm.xml.Serializer)new BaseSerializer());
        xml.write(this.getJavaClassName(), this);
        return writer.toString();
    }

    @Override
    public <T> T convertTo(Class<T> target, Class<?> elementType, Map<Object, Object> references) {
        try {
            Object result;
            if (DynamicObject.class.isAssignableFrom(target)) {
                result = this;
            } else if (target == String.class) {
                result = this.toString();
            } else if (target == Long.class || target == Long.TYPE) {
                result = this.longValue();
            } else if (target == BigDecimal.class) {
                result = this.decimalValue();
            } else if (target == Double.class || target == Double.TYPE) {
                result = this.doubleValue();
            } else if (target == Time.class) {
                result = this.timeValue();
            } else if (target == Interval.class) {
                result = this.intervalValue();
            } else if (target.isEnum()) {
                result = this.enumValue(target);
            } else {
                result = references.get(this);
                if (result == null) {
                    if (DynamicObject.Dynamizable.class.isAssignableFrom(target)) {
                        result = CompositeDynamicObject.callCustomRead(this, target, elementType, references);
                    } else {
                        result = CompositeDynamicObject.instantiate(this.classToInstantiate(target, elementType), this.parent(references));
                        references.put(this, result);
                        this.copyFields(result, references);
                        result = CompositeDynamicObject.unquote(result);
                        result = CompositeDynamicObject.manageCollection(result, target);
                    }
                }
            }
            return Cast.autoBoxingCast(target, result);
        }
        catch (Exception e) {
            Log.logTrace(ExceptionFormatter.fullTechLevel(e));
            throw new IllegalConversionException(this.javaClassName != null ? this.javaClassName : "Composite", target.getName(), e.toString());
        }
    }

    @Override
    public void setPrevious(Object previous) {
        this.previous = previous;
    }

    private static Object manageCollection(Object result, Class<?> targetClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (result != null && !targetClass.isInstance(result) && Collection.class.isAssignableFrom(targetClass)) {
            Collection collection = (Collection)Cast.force(CompositeDynamicObject.instantiate(targetClass));
            collection.add(result);
            result = collection;
        }
        return result;
    }

    private static Object unquote(Object result) {
        if (result instanceof DynamicObject.Quote) {
            DynamicObject.Quote quote = (DynamicObject.Quote)result;
            result = quote.value;
        }
        return result;
    }

    private static Field[] fields(Class<?> clazz) {
        AccessibleObject[] targetFields;
        if (Serializable.class.isAssignableFrom(clazz)) {
            targetFields = JavaClass.getAllFields(clazz);
            AccessibleObject.setAccessible(targetFields, true);
        } else {
            targetFields = clazz.getFields();
        }
        return targetFields;
    }

    private static boolean isCollection(Class<?> cl) {
        return List.class.isAssignableFrom(cl) || Set.class.isAssignableFrom(cl);
    }

    private void copyFields(Object result, Map<Object, Object> references) throws IllegalAccessException, InvocationTargetException {
        String name;
        HashSet<String> fieldNames = new HashSet<String>();
        Class<?> resultClass = result.getClass();
        for (Field field : CompositeDynamicObject.fields(resultClass)) {
            DynamicObject fieldValue;
            name = field.getName();
            fieldNames.add(name);
            if (!DynamicObject.mustSerialize(field) || (fieldValue = this.getField(name)) == NULL && !this.map.containsKey(name)) continue;
            Object previousValue = null;
            try {
                previousValue = field.get(result);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            fieldValue.setPrevious(previousValue);
            Object val = fieldValue.convertTo(field, references);
            if (val == null && field.getType().isPrimitive()) {
                val = DefaultValue.forClass(field.getType());
            }
            JavaClass.setFieldValue(field, result, val);
        }
        for (AccessibleObject accessibleObject : resultClass.getMethods()) {
            Object javaValue;
            if (!JavaClass.isSetter((Method)accessibleObject)) continue;
            name = JavaClass.getNameFromAccessor((Method)accessibleObject);
            boolean wasSettedByField = fieldNames.contains(name);
            if (!this.map.containsKey(name) || wasSettedByField) continue;
            DynamicObject value = this.getField(name);
            Class<?>[] parameterTypes = ((Method)accessibleObject).getParameterTypes();
            Class<?> target = parameterTypes[0];
            if (value instanceof DynamicObject.Array) {
                DynamicObject.Array array = (DynamicObject.Array)value;
                javaValue = array.convertTo(target, CompositeDynamicObject.elementType(resultClass, name), references);
            } else {
                javaValue = value.convertTo(target, references);
            }
            ((Method)accessibleObject).setAccessible(true);
            ((Method)accessibleObject).invoke(result, javaValue);
        }
    }

    private Object parent(Map<Object, Object> references) {
        DynamicObject parentRef = this.getField("__parent");
        Object parent = null;
        if (parentRef != NULL) {
            parent = parentRef.convertTo(Object.class, references);
        }
        return parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> classToInstantiate(Class<?> targetClass, Class<?> elementType) {
        Class<?> result = targetClass;
        if (targetClass.getName().equals(this.javaClassName)) return result;
        Class<?> sourceClass = this.loadClass();
        if (sourceClass == null) {
            if (!targetClass.isInterface()) return result;
            if (!CompositeDynamicObject.isCollection(targetClass) || elementType.isInterface()) throw new IllegalConversionException(this.javaClassName == null ? "Composite" : this.javaClassName, targetClass.getName(), "Target class is an interface");
            return elementType;
        }
        if (targetClass.isInterface()) return sourceClass;
        if (!targetClass.isAssignableFrom(sourceClass)) return result;
        return sourceClass;
    }

    private Class<?> loadClass() {
        Class<?> sourceClass = null;
        if (this.javaClassName != null) {
            try {
                sourceClass = Class.forName(this.javaClassName, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    ClassLoader cl = null;
                    ExecutionContext context = ExecutionContextAccessor.getContext();
                    if (context != null) {
                        cl = (ClassLoader)context.getProperty("fuego.process.classloader");
                    }
                    if (cl == null) {
                        cl = Thread.currentThread().getContextClassLoader();
                    }
                    sourceClass = Class.forName(this.javaClassName, true, cl);
                }
                catch (ClassNotFoundException e1) {
                    Log.logWarning(e);
                }
            }
        }
        return sourceClass;
    }

    private static final class CompositeMap
    extends HashMap<String, Object> {
        private final boolean quote;
        static final long serialCheck = -2705384132600071311L;
        static final long serialVersionUID = 2627600563327922938L;

        CompositeMap(boolean quote) {
            this.quote = quote;
        }

        @Override
        public boolean containsValue(Object value) {
            return super.containsValue(DynamicObject.valueOf(value, this.quote));
        }

        public Object get(String key) {
            Object value = super.get(key);
            return value != null ? value : DynamicObject.NULL;
        }

        @Override
        public Object put(String key, Object value) {
            DynamicObject old = super.put(key, DynamicObject.valueOf(value, this.quote));
            return old != null ? old : DynamicObject.NULL;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Object)this.keySet()).equals(((Map)o).keySet());
        }

        public Object put(String key, Object value, Map<Object, Object> references) {
            DynamicObject old = super.put(key, DynamicObject.valueOf(value, this.quote, references));
            return old != null ? old : DynamicObject.NULL;
        }

        @Override
        public int hashCode() {
            return ((Object)this.keySet()).hashCode();
        }
    }
}

