/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.utils.CachedOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryVFileSystem
extends VFileSystem {
    protected final Map<VFile, Tuple<CachedOutputStream, Long>> filesCache;
    protected final Map<VFile, Long> foldersCache = new LinkedHashMap<VFile, Long>();
    private static final Object lock = new Object();

    public MemoryVFileSystem() {
        this.filesCache = new LinkedHashMap<VFile, Tuple<CachedOutputStream, Long>>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public VFile[] list(final @NotNull VFile vFile, @Nullable VFileFilter filter) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.list must not be null");
        }
        return this.list(new VFileFilter(){

            @Override
            public boolean accept(@NotNull VFile pathname) {
                return vFile.equals(pathname.getParentFile());
            }
        }, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VFile[] list(@NotNull VFileFilter filterVFile, @Nullable VFileFilter filter) {
        HashMap<VFile, Tuple<CachedOutputStream, Long>> copyOfFilesCreated;
        HashMap<VFile, Long> copyOfPackagesCreated;
        if (filterVFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.list must not be null");
        }
        ArrayList<VFile> ret = new ArrayList<VFile>();
        Object object = lock;
        synchronized (object) {
            copyOfPackagesCreated = new HashMap<VFile, Long>(this.foldersCache);
            copyOfFilesCreated = new HashMap<VFile, Tuple<CachedOutputStream, Long>>(this.filesCache);
        }
        for (VFile file : copyOfPackagesCreated.keySet()) {
            if (!filterVFile.accept(file) || filter != null && !filter.accept(file)) continue;
            ret.add(file);
        }
        Set vFileSet = copyOfFilesCreated.keySet();
        if (vFileSet != null) {
            for (VFile file : vFileSet) {
                if (!filterVFile.accept(file) || filter != null && !filter.accept(file)) continue;
                ret.add(file);
            }
        }
        return !ret.isEmpty() ? ret.toArray(new VFile[ret.size()]) : new VFile[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = lock;
        synchronized (object) {
            this.filesCache.clear();
            this.foldersCache.clear();
        }
    }

    @Override
    @NotNull
    public String getUniqueID() {
        if ("uniqueID" == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/MemoryVFileSystem.getUniqueID must not return null");
        }
        return "uniqueID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(@NotNull VFileSystem targetVFileSystem) throws IOException {
        if (targetVFileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.copyTo must not be null");
        }
        targetVFileSystem.stopEventDispatch();
        Object object = lock;
        synchronized (object) {
            for (VFile folder : this.foldersCache.keySet()) {
                VFile newFolder = targetVFileSystem.createFile(folder.getCanonicalPath());
                newFolder.mkdirs();
            }
            for (VFile file : this.filesCache.keySet()) {
                VFile newFile;
                if (VFileUtils.fileCopy(file, newFile = targetVFileSystem.createFile(file.getCanonicalPath()))) continue;
                throw new IOException("Cannot copy " + file + "to the destination file " + newFile);
            }
            this.dispose();
        }
        targetVFileSystem.resumeEventDispatch();
    }

    @Override
    protected long lastModified(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.lastModified must not be null");
        }
        long lastModified = 0L;
        if (this.isDirectory(vFile)) {
            lastModified = this.foldersCache.get(vFile);
        }
        if (this.isFile(vFile)) {
            lastModified = this.filesCache.get(vFile).getSecond();
        }
        return lastModified;
    }

    @Override
    protected boolean isZeroLength(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.isZeroLength must not be null");
        }
        return false;
    }

    @Override
    protected boolean delete(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.delete must not be null");
        }
        if (!this.exists(vFile) || this.isRoot(vFile)) {
            return false;
        }
        if (this.filesCache.containsKey(vFile)) {
            this.filesCache.remove(vFile);
        }
        if (this.foldersCache.keySet().contains(vFile)) {
            this.foldersCache.remove(vFile);
        }
        this.fireEvent(new VFileEvent(VEventType.REMOVE, vFile));
        return true;
    }

    @Override
    protected boolean mkdirs(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.mkdirs must not be null");
        }
        if (this.exists(vFile)) {
            return false;
        }
        this.foldersCache.put(vFile, this.timeStamp());
        this.fireEvent(new VFileEvent(VEventType.ADD, vFile));
        return true;
    }

    @Override
    protected boolean exists(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.exists must not be null");
        }
        return this.isRoot(vFile) || this.foldersCache.keySet().contains(vFile) || this.filesCache.containsKey(vFile) || this.hasParentDefined(vFile);
    }

    @Override
    protected boolean isDirectory(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.isDirectory must not be null");
        }
        return this.foldersCache.keySet().contains(vFile) || this.hasParentDefined(vFile);
    }

    @Override
    protected boolean canWrite(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.canWrite must not be null");
        }
        return true;
    }

    @Override
    protected InputStream openInputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.openInputStream must not be null");
        }
        if (this.isFile(vFile) && this.exists(vFile)) {
            return this.filesCache.get(vFile).getFirst().openInputStream();
        }
        throw new FileNotFoundException(vFile.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutputStream openOutputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.openOutputStream must not be null");
        }
        if (vFile.isDirectory() || !vFile.getParentFile().exists()) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        CachedOutputStream cachedOutputStream = null;
        Object object = lock;
        synchronized (object) {
            boolean exists = this.exists(vFile);
            if (exists && this.isFile(vFile)) {
                cachedOutputStream = this.filesCache.get(vFile).getFirst();
            }
            if (cachedOutputStream == null) {
                cachedOutputStream = new CachedOutputStream();
                this.filesCache.put(vFile, Tuple.create(cachedOutputStream, this.timeStamp()));
            } else {
                cachedOutputStream.clear();
            }
            vFile.setCreated(!exists);
        }
        return cachedOutputStream;
    }

    @Override
    protected boolean isHidden(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.isHidden must not be null");
        }
        return false;
    }

    @Override
    protected boolean isFile(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/MemoryVFileSystem.isFile must not be null");
        }
        return this.filesCache.containsKey(vFile);
    }

    protected boolean isRoot(VFile vFile) {
        return this.getRoot().equals(vFile);
    }

    private boolean hasParentDefined(final VFile vFile) {
        Sequence<VFile> select = CollectionUtils.select(this.foldersCache.keySet(), new Predicate<VFile>(){

            @Override
            public boolean check(@Nullable VFile value) {
                String canonicalPath = value.getParentFile().getCanonicalPath();
                return vFile.getCanonicalPath().equals(canonicalPath);
            }
        });
        return !select.isEmpty();
    }

    private void print() {
        System.out.println("MEM FILESYSTEM ==================================");
        for (VFile vFile : this.foldersCache.keySet()) {
            System.out.print("Folders: ");
            System.out.print(vFile.getCanonicalPath());
        }
        for (VFile vFile : this.filesCache.keySet()) {
            System.out.print("Files: ");
            System.out.print(vFile.getCanonicalPath());
        }
        System.out.println("=================================================");
    }

    private long timeStamp() {
        return System.currentTimeMillis();
    }
}

