/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.File;
import java.io.IOException;

public class FileLock {
    private File lockFile;

    public FileLock(File lockFile) {
        if (lockFile == null) {
            throw new IllegalArgumentException("lockFile is not optional");
        }
        this.lockFile = lockFile;
    }

    public void lock() throws InterruptedException {
        while (!this.tryLock(0L)) {
            Thread.sleep(500L);
        }
    }

    public boolean tryLock(long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        boolean useTimeout = timeout > 0L;
        boolean aquired = false;
        while (!(aquired || useTimeout && System.currentTimeMillis() - startTime > timeout)) {
            try {
                aquired = this.lockFile.createNewFile();
            }
            catch (IOException e) {
                aquired = false;
            }
            if (aquired) continue;
            if (!useTimeout) break;
            Thread.sleep(100L);
        }
        return aquired;
    }

    public void unlock() {
        this.lockFile.delete();
    }
}

