/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.File;
import java.io.FilenameFilter;
import oracle.bpm.collections.lists.StringList;

public class ExtensionFileFilter
implements FilenameFilter {
    private StringList extensions = StringList.create();

    private ExtensionFileFilter(String ... extensions) {
        for (String extension : extensions) {
            this.extensions.add(extension.charAt(0) == '.' ? extension : '.' + extension);
        }
    }

    public static ExtensionFileFilter create(String ... extension) {
        return new ExtensionFileFilter(extension);
    }

    @Override
    public boolean accept(File dir, String name) {
        for (String extension : this.extensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

