/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import oracle.bpm.collections.lists.IntList;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

abstract class RectangularShape {
    private final Dimension dimension;
    private final Point origin;

    public RectangularShape(Point origin) {
        this(origin, Dimension.ZERO);
    }

    public RectangularShape(Dimension dimension) {
        this(Point.ORIGIN, dimension);
    }

    public RectangularShape(String str) {
        IntList coords = IntList.createFromString(str);
        this.origin = new Point((Integer)coords.get(0), (Integer)coords.get(1));
        this.dimension = Dimension.valueOf((Integer)coords.get(2), (Integer)coords.get(3));
    }

    public RectangularShape(Point origin, Point top) {
        this(origin, top.delta(origin));
    }

    protected RectangularShape() {
        this(Point.ORIGIN, Dimension.ZERO);
    }

    protected RectangularShape(Rectangle r) {
        this(r.getOrigin(), r.getSize());
    }

    protected RectangularShape(int width, int height) {
        this(Point.ORIGIN, Dimension.valueOf(width, height));
    }

    protected RectangularShape(Point origin, Dimension dimension) {
        this.origin = origin;
        this.dimension = dimension;
    }

    protected RectangularShape(int x, int y, int width, int height) {
        this(new Point(x, y), Dimension.valueOf(width, height));
    }

    public abstract boolean isEmpty();

    public abstract boolean contains(int var1, int var2, int var3, int var4);

    public abstract boolean intersects(int var1, int var2, int var3, int var4);

    public int getHeight() {
        return this.dimension.getHeight();
    }

    public int getMaxX() {
        return this.getX() + this.getWidth();
    }

    public int getMaxY() {
        return this.getY() + this.getHeight();
    }

    public Point getOrigin() {
        return this.origin;
    }

    public Dimension getSize() {
        return this.dimension;
    }

    public Point getTop() {
        return this.origin.translate(this.dimension);
    }

    public int getWidth() {
        return this.dimension.getWidth();
    }

    public int getX() {
        return this.origin.getX();
    }

    public int getY() {
        return this.origin.getY();
    }

    public float ratio() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public double diagonal() {
        return this.getOrigin().distance(this.getTop());
    }

    public int area() {
        return this.getWidth() * this.getHeight();
    }

    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        boolean result;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean bl = result = width >= 0 && height >= 0;
        if (result) {
            int lowX = this.getX();
            int lowY = this.getY();
            boolean bl2 = result = x >= lowX && y >= lowY;
            if (result) {
                int topX = width + lowX;
                int topY = height + lowY;
                result = !(topX >= lowX && topX <= x || topY >= lowY && topY <= y);
            }
        }
        return result;
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new Rectangle();
        }
        double x = this.getX();
        double y = this.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public boolean intersects(Rectangle rectangle, int tolerance) {
        return this.intersects(rectangle.getX() - tolerance / 2, rectangle.getY() - tolerance / 2, rectangle.getWidth() + tolerance, rectangle.getHeight() + tolerance);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public String toString() {
        return "RectangularShape{origin=" + this.origin + ", dimension=" + this.dimension + '}';
    }
}

