/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class Polygon
implements Serializable {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    static final long serialCheck = -636619400958988638L;
    static final long serialVersionUID = -5534311678768138609L;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(List<Point> ps) {
        Polygon.optimizePoints(ps);
        this.npoints = ps.size();
        this.xpoints = new int[this.npoints];
        this.ypoints = new int[this.npoints];
        for (int i = 0; i < ps.size(); ++i) {
            Point p = ps.get(i);
            this.xpoints[i] = p.getX();
            this.ypoints[i] = p.getY();
        }
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = Arrays.copyOf(xpoints, npoints);
        this.ypoints = Arrays.copyOf(ypoints, npoints);
    }

    public Rectangle getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return new Rectangle(this.bounds);
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(int x, int y) {
        hits = 0;
        lastx = this.xpoints[this.npoints - 1];
        lasty = this.ypoints[this.npoints - 1];
        for (i = 0; i < this.npoints; ++i) {
            block7: {
                block10: {
                    block11: {
                        block9: {
                            block8: {
                                curx = this.xpoints[i];
                                cury = this.ypoints[i];
                                if (cury == lasty) break block7;
                                if (curx >= lastx) break block8;
                                if (x >= lastx) break block7;
                                leftx = curx;
                                break block9;
                            }
                            if (x >= curx) break block7;
                            leftx = lastx;
                        }
                        if (cury >= lasty) break block10;
                        if (y < cury || y >= lasty) break block7;
                        if (x >= leftx) break block11;
                        ++hits;
                        break block7;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl32
                }
                if (y < lasty || y >= cury) break block7;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl32:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void translate(int deltaX, int deltaY) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + deltaX;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + deltaY;
        }
        if (this.bounds != null) {
            this.bounds.translate(deltaX, deltaY);
        }
    }

    void calculateBounds(int[] xs, int[] ys, int n) {
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            int x = xs[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            int y = ys[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        this.bounds = new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    void updateBounds(int x, int y) {
        int width = x < this.bounds.getX() ? this.bounds.getWidth() + (this.bounds.getX() - x) : Math.max(this.bounds.getWidth(), x - this.bounds.getX());
        int height = y < this.bounds.getY() ? this.bounds.getHeight() + (this.bounds.getY() - y) : Math.max(this.bounds.getHeight(), y - this.bounds.getY());
        this.bounds = new Rectangle(x, y, width, height);
    }

    private static void optimizePoints(List<Point> ps) {
        for (int i = 1; i < ps.size() - 1; ++i) {
            Point curr = ps.get(i);
            Point prev = ps.get(i - 1);
            Point next = ps.get(i + 1);
            if (curr.angle(prev) != next.angle(curr)) continue;
            ps.remove(i);
            --i;
        }
    }
}

