/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class Line
extends Line2D.Double
implements Path {
    private static final long serialVersionUID = 6475953788415878162L;

    public Line(@NotNull Point p1, @NotNull Point p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Line.<init> must not be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/Line.<init> must not be null");
        }
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    private Line(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
    }

    public static void main(String[] args) {
        boolean b = Line.linesIntersect(0.0, 0.0, 1.0, 1.0, 1.01, 1.01, 2.0, 2.0);
        System.out.println("b = " + b);
    }

    public static boolean segmentsOverlap(int f1, int t1, int f2, int t2) {
        int t;
        if (f1 > t1) {
            t = f1;
            f1 = t1;
            t1 = t;
        }
        if (f2 > t2) {
            t = f2;
            f2 = t2;
            t2 = t;
        }
        return f1 >= f2 && f1 < t2 || f2 >= f1 && f2 < t1;
    }

    @Override
    public Point2D eval(double t) {
        double u = 1.0 - t;
        return new Point2D.Double(this.x1 * u + this.x2 * t, this.y1 * u + this.y2 * t);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public Point2D findPoint(Point2D point, double distance, double base) {
        double angle = Point.angle(this.getX1(), this.getY1(), this.getX2(), this.getY2());
        return new Point2D.Double(point.getX() + distance * Math.cos(angle), point.getY() + distance * Math.sin(angle));
    }

    @Override
    public Point2D findPointBackwards(Point2D point, double distance, double base) {
        double angle = Point.angle(this.getX1(), this.getY1(), this.getX2(), this.getY2());
        return new Point2D.Double(point.getX() - distance * Math.cos(angle), point.getY() - distance * Math.sin(angle));
    }

    @Override
    public Path scaled(float scale) {
        return scale == 1.0f ? this : new Line(this.getX1() * (double)scale, this.getY1() * (double)scale, this.getX2() * (double)scale, this.getY2() * (double)scale);
    }

    @Override
    public Path cropped(double t0, double t1) {
        double u0 = 1.0 - t0;
        double u1 = 1.0 - t1;
        return new Line(this.x1 * u0 + this.x2 * t0, this.y1 * u0 + this.y2 * t0, this.x1 * u1 + this.x2 * t1, this.y1 * u1 + this.y2 * t1);
    }

    public String toString() {
        return "Line [ from " + this.getP1() + ", to " + this.getP2() + " ]";
    }
}

