/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.extension;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.bpm.extension.Extension;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Conversion;

public abstract class AbstractExtension<M>
implements Extension<M> {
    protected Class<M> pointType;
    private String displayName;
    private String id;
    private M metadata;

    protected AbstractExtension(Class<M> pointType, String id, String displayName) {
        this.pointType = pointType;
        this.id = id;
        this.displayName = displayName;
    }

    public static <T> T convertTo(Object value, Class<T> returnType, ClassLoader classLoader) {
        Object result;
        if (value == null || returnType.isInstance(value)) {
            result = value;
        } else if (Class.class.isAssignableFrom(returnType)) {
            try {
                result = Class.forName((String)((Object)value), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalConversionException(value.getClass(), returnType.getName(), e);
            }
        } else if (returnType.isEnum()) {
            Class<T> enumType = returnType;
            result = Enum.valueOf(enumType, ((Object)value).toString());
        } else if (returnType.isArray()) {
            String str = ((Object)value).toString();
            if (str.startsWith("[") && str.endsWith("]")) {
                str = str.substring(1, str.length() - 1);
            }
            String[] values = str.trim().length() == 0 ? ArrayUtils.EMPTY_STRING_ARRAY : str.split(",");
            Object array = Array.newInstance(returnType.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Object val = AbstractExtension.convertTo(values[i].trim(), returnType.getComponentType(), classLoader);
                Array.set(array, i, val);
            }
            result = array;
        } else {
            result = Conversion.convertTo(value, returnType);
        }
        return Cast.autoBoxingCast(returnType, result);
    }

    public String toString() {
        return String.valueOf(this.displayName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final <T> T instantiateAs(Class<T> cl) throws InstantiationException {
        Object instance = this.instantiate();
        try {
            return cl.cast(instance);
        }
        catch (ClassCastException e) {
            throw new InstantiationException("Extension '" + this.getId() + "' provides a class '" + instance.getClass().getName() + "' which is not a '" + cl.getName() + '\'');
        }
    }

    @Override
    public Object instantiate(String propertyName) throws InstantiationException {
        Exception cause;
        try {
            Class<?> extensionClass = this.getMetadata().getClass();
            Method method = extensionClass.getMethod(propertyName, null);
            String className = (String)method.invoke(this.getMetadata(), (Object[])null);
            Class<?> cl = Class.forName(className);
            return cl.newInstance();
        }
        catch (NoSuchMethodException e) {
            cause = e;
        }
        catch (ClassNotFoundException e) {
            cause = e;
        }
        catch (IllegalArgumentException e) {
            cause = e;
        }
        catch (IllegalAccessException e) {
            cause = e;
        }
        catch (InvocationTargetException e) {
            cause = e;
        }
        InstantiationException exception = new InstantiationException(cause.toString());
        exception.initCause(cause);
        throw exception;
    }

    @Override
    public M getMetadata() {
        if (this.metadata == null) {
            Class[] classes = new Class[]{this.pointType};
            InvocationHandler handler = this.createHandler();
            ClassLoader classLoader = this.pointType.getClassLoader();
            this.metadata = this.pointType.cast(Proxy.newProxyInstance(classLoader, classes, handler));
        }
        return this.metadata;
    }

    protected abstract Object instantiate() throws InstantiationException;

    protected abstract InvocationHandler createHandler();

    protected void setMetadata(M metadata) {
        this.metadata = metadata;
    }
}

