/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.maps.AbstractBiMap;
import org.jetbrains.annotations.NotNull;

public class TreeBiMap<K, V>
extends AbstractBiMap<K, V> {
    public TreeBiMap() {
        this.map = new TreeMap();
    }

    public TreeBiMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    public TreeBiMap(Comparator<? super K> keyComparator, Comparator<? super V> valueComparator) {
        this.map = new TreeMap(keyComparator);
        this.inverseMap = new TreeBiMap<V, V>(this, valueComparator);
    }

    private TreeBiMap(@NotNull TreeBiMap<V, K> inverse, Comparator<? super K> valueComparator) {
        if (inverse == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/TreeBiMap.<init> must not be null");
        }
        this.map = new TreeMap(valueComparator);
        this.inverseMap = inverse;
    }
}

