/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.StringTokenizer;
import oracle.bpm.collections.lists.ComparableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringList
extends ComparableList<String>
implements RandomAccess {
    public static final StringList EMPTY = new StringList(Collections.<String>emptyList());

    public StringList(@NotNull List<String> delegated) {
        if (delegated == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/StringList.<init> must not be null");
        }
        super(delegated);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList create() {
        StringList stringList = StringList.create(10);
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.create must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList create(int initialCapacity) {
        StringList stringList = new StringList((List<String>)new ArrayList<String>(initialCapacity));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.create must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList create(String ... values) {
        StringList result;
        if (values == null) {
            result = StringList.create();
        } else {
            result = StringList.create(values.length);
            result.addAll(values);
        }
        StringList stringList = result;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.create must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList valueOf(String ... values) {
        StringList stringList = values == null ? EMPTY : new StringList(Arrays.asList(values));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.valueOf must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList create(@NotNull StringTokenizer tokenizer) {
        if (tokenizer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/StringList.create must not be null");
        }
        StringList result = StringList.create(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        StringList stringList = result;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.create must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList createTokenizing(@Nullable String string, @NotNull String separators) {
        if (separators == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/lists/StringList.createTokenizing must not be null");
        }
        StringList stringList = string == null || string.length() == 0 ? StringList.create() : StringList.create(new StringTokenizer(string, separators));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.createTokenizing must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList create(@Nullable Collection<String> values) {
        StringList result;
        if (values == null) {
            result = StringList.create();
        } else {
            result = StringList.create(values.size());
            result.addAll(values);
        }
        StringList stringList = result;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.create must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList convert(@NotNull Collection<?> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/StringList.convert must not be null");
        }
        StringList result = StringList.create(objects.size());
        for (Object value : objects) {
            result.add(String.valueOf(value));
        }
        StringList stringList = result;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.convert must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static StringList singleton(@NotNull String element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/StringList.singleton must not be null");
        }
        StringList stringList = new StringList(Collections.singletonList(element));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.singleton must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public StringList add(String ... values) {
        this.addAll(values);
        StringList stringList = this;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.add must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String[] toArray() {
        String[] stringArray = this.toArray(new String[this.size()]);
        if (stringArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.toArray must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public StringList subList(int fromIndex, int toIndex) {
        StringList stringList = new StringList(this.list.subList(fromIndex, toIndex));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.subList must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public StringList clone() {
        StringList stringList = StringList.create(this);
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.clone must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public StringList sort() {
        super.sort();
        StringList stringList = this;
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.sort must not return null");
        }
        return stringList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public StringList asUnmodifiable() {
        StringList stringList = new StringList(Collections.unmodifiableList(this.list));
        if (stringList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/StringList.asUnmodifiable must not return null");
        }
        return stringList;
    }
}

