/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

@Deprecated
public class IntArrayList
implements Serializable,
Cloneable {
    protected transient int[] intValues;
    protected transient int position;
    protected static final int DEFAULT_CAPACITY = 10;
    static final long serialCheck = -7336201729243926237L;
    static final long serialVersionUID = -9043817294916836855L;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int capacity) {
        this.intValues = new int[capacity];
        this.position = 0;
    }

    public IntArrayList(int[] values) {
        this(Math.max(values.length, 10));
        this.add(values);
    }

    private IntArrayList(int[] values, boolean dummy) {
        this.intValues = values;
        this.position = values.length;
    }

    public boolean isEmpty() {
        return this.position == 0;
    }

    public int[] getNativeArray() {
        return this.intValues;
    }

    public void setQuick(int offset, int val) {
        this.intValues[offset] = val;
    }

    public int getQuick(int offset) {
        return this.intValues[offset];
    }

    public int getSet(int offset, int val) {
        if (offset >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int old = this.intValues[offset];
        this.intValues[offset] = val;
        return old;
    }

    public void add(int val) {
        this.ensureCapacity(this.position + 1);
        this.intValues[this.position++] = val;
    }

    public void add(int[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(int[] vals, int offset, int length) {
        this.ensureCapacity(this.position + length);
        System.arraycopy(vals, offset, this.intValues, this.position, length);
        this.position += length;
    }

    public int binarySearch(int value) {
        return this.binarySearch(value, 0, this.position);
    }

    public int binarySearch(int value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.position) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = this.intValues[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this.intValues = new int[capacity];
        this.position = 0;
    }

    public Object clone() {
        IntArrayList clone = null;
        try {
            clone = (IntArrayList)super.clone();
            clone.intValues = (int[])this.intValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean contains(int value) {
        return this.lastIndexOf(value) >= 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.intValues.length) {
            int newCap = Math.max(this.intValues.length << 1, capacity);
            this.intValues = Arrays.copyOf(this.intValues, newCap);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntArrayList) {
            IntArrayList that = (IntArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this.position;
            while (i-- > 0) {
                if (this.intValues[i] == that.intValues[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void fill(int val) {
        Arrays.fill(this.intValues, 0, this.position, val);
    }

    public void fill(int fromIndex, int toIndex, int val) {
        if (toIndex > this.position) {
            this.ensureCapacity(toIndex);
            this.position = toIndex;
        }
        Arrays.fill(this.intValues, fromIndex, toIndex, val);
    }

    public IntArrayList fromNative(int[] values) {
        return new IntArrayList(values, false);
    }

    public int get(int offset) {
        if (offset >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this.intValues[offset];
    }

    public int hashCode() {
        int h = 0;
        int i = this.position;
        while (i-- > 0) {
            h += this.intValues[i];
        }
        return h;
    }

    public int indexOf(int value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, int value) {
        for (int i = offset; i < this.position; ++i) {
            if (this.intValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void insert(int offset, int value) {
        if (offset == this.position) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this.position + 1);
        System.arraycopy(this.intValues, offset, this.intValues, offset + 1, this.position - offset);
        this.intValues[offset] = value;
        ++this.position;
    }

    public void insert(int offset, int[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, int[] values, int valOffset, int len) {
        if (offset == this.position) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this.position + len);
        System.arraycopy(this.intValues, offset, this.intValues, offset + len, this.position - offset);
        System.arraycopy(values, valOffset, this.intValues, offset, len);
        this.position += len;
    }

    public int lastIndexOf(int value) {
        return this.lastIndexOf(this.position, value);
    }

    public int lastIndexOf(int offset, int value) {
        int i = offset;
        while (i-- > 0) {
            if (this.intValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int max = this.intValues[this.position - 1];
        int i = this.position - 1;
        while (i-- > 0) {
            max = Math.max(max, this.intValues[this.position]);
        }
        return max;
    }

    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int min = this.intValues[this.position - 1];
        int i = this.position - 1;
        while (i-- > 0) {
            min = Math.min(min, this.intValues[this.position]);
        }
        return min;
    }

    public int remove(int offset) {
        int old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this.intValues, length, this.intValues, 0, this.position - length);
        } else if (this.position - length != offset) {
            System.arraycopy(this.intValues, offset + length, this.intValues, offset, this.position - (offset + length));
        }
        this.position -= length;
    }

    public void reset() {
        this.position = 0;
        this.fill(0);
    }

    public void resetQuick() {
        this.position = 0;
    }

    public void reverse() {
        this.reverse(0, this.position);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void set(int offset, int val) {
        if (offset >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this.intValues[offset] = val;
    }

    public void set(int offset, int[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, int[] values, int valOffset, int length) {
        if (offset < 0 || offset + length >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this.intValues, offset, values, valOffset, length);
    }

    public void shuffle(Random rand) {
        int i = this.position;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    public int size() {
        return this.position;
    }

    public void sort() {
        Arrays.sort(this.intValues, 0, this.position);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this.intValues, fromIndex, toIndex);
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this.position);
    }

    public int[] toNativeArray(int offset, int len) {
        int[] rv = new int[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(int[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this.position) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this.intValues, offset, dest, 0, len);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.position; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.intValues[i]);
        }
        buf.append("}");
        return buf.toString();
    }

    public void trimToSize() {
        if (this.intValues.length > this.size()) {
            int[] tmp = new int[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this.intValues = tmp;
        }
    }

    private void swap(int i, int j) {
        int tmp = this.intValues[i];
        this.intValues[i] = this.intValues[j];
        this.intValues[j] = tmp;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.intValues = new int[size];
        while (size-- > 0) {
            int val = stream.readInt();
            this.add(val);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (int i = 0; i < this.position; ++i) {
            stream.writeInt(this.intValues[i]);
        }
    }
}

