/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.iterator.ReverseIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegatedList<E>
implements List<E>,
Iterable<E> {
    @NotNull
    protected List<E> list;

    protected DelegatedList(@NotNull List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.<init> must not be null");
        }
        this.list = list;
        assert (list == Collections.EMPTY_LIST || list instanceof RandomAccess);
    }

    @Override
    @NotNull
    public abstract DelegatedList<E> subList(int var1, int var2);

    @NotNull
    public abstract DelegatedList<E> clone();

    @NotNull
    public abstract DelegatedList<E> asUnmodifiable();

    @NotNull
    public abstract DelegatedList<E> add(E ... var1);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Sequence<E> asSequence() {
        Sequence sequence = CollectionUtils.asSequence(this);
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.asSequence must not return null");
        }
        return sequence;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.list.toArray();
        if (objectArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.toArray must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.toArray must not be null");
        }
        T[] TArray = this.list.toArray(a);
        if (TArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.toArray must not return null");
        }
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<E> iterator = this.list.iterator();
        if (iterator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.iterator must not return null");
        }
        return iterator;
    }

    @Override
    public boolean add(@Nullable E o) {
        return this.list.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.containsAll must not be null");
        }
        return this.list.containsAll(coll);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.addAll must not be null");
        }
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.addAll must not be null");
        }
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.removeAll must not be null");
        }
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> coll) {
        if (coll == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.retainAll must not be null");
        }
        return this.list.retainAll(coll);
    }

    public int count(@Nullable E element) {
        return Collections.frequency(this.list, element);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toString() {
        String string = this.list.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.toString must not return null");
        }
        return string;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o instanceof List && ((Object)this.list).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, @Nullable E element) {
        this.list.add(index, element);
    }

    @Override
    @Nullable
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.list.lastIndexOf(o);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.list.listIterator();
        if (listIterator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.listIterator must not return null");
        }
        return listIterator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListIterator<E> listIterator = this.list.listIterator(index);
        if (listIterator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.listIterator must not return null");
        }
        return listIterator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toSeparatedString(@NotNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/DelegatedList.toSeparatedString must not be null");
        }
        String string = CollectionUtils.toSeparatedString(this, separator);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.toSeparatedString must not return null");
        }
        return string;
    }

    @Nullable
    public E last() {
        int sz = this.size();
        return sz == 0 ? null : (E)this.get(sz - 1);
    }

    @Nullable
    public E first() {
        return this.isEmpty() ? null : (E)this.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Iterable<E> reverse() {
        ReverseIterable<E> reverseIterable = new ReverseIterable<E>(this.list);
        if (reverseIterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/DelegatedList.reverse must not return null");
        }
        return reverseIterable;
    }

    public boolean replaceAll(@Nullable E oldValue, @Nullable E newValue) {
        return Collections.replaceAll(this.list, oldValue, newValue);
    }

    protected void addAll(E ... values) {
        if (values != null) {
            for (E value : values) {
                this.add(value);
            }
        }
    }
}

