/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.io.Serializable;
import oracle.bpm.collections.Tuple3;
import oracle.bpm.collections.Tuple4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tuple<T, U>
implements Serializable {
    @Nullable
    private final T first;
    @Nullable
    private final U second;
    private static final long serialVersionUID = 200705311430L;
    private static final long serialCheck = -8854163416453619720L;

    protected Tuple(T first, U second) {
        this.first = first;
        this.second = second;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, U> Tuple<T, U> create(@Nullable T first, @Nullable U second) {
        Tuple<T, U> tuple = new Tuple<T, U>(first, second);
        if (tuple == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Tuple.create must not return null");
        }
        return tuple;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, U, V> Tuple3<T, U, V> create(@Nullable T first, @Nullable U second, @Nullable V third) {
        Tuple3<T, U, V> tuple3 = new Tuple3<T, U, V>(first, second, third);
        if (tuple3 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Tuple.create must not return null");
        }
        return tuple3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, U, V, W> Tuple4<T, U, V, W> create(@Nullable T first, @Nullable U second, @Nullable V third, @Nullable W fourth) {
        Tuple4<T, U, V, W> tuple4 = new Tuple4<T, U, V, W>(first, second, third, fourth);
        if (tuple4 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Tuple.create must not return null");
        }
        return tuple4;
    }

    public T getFirst() {
        return this.first;
    }

    public U getSecond() {
        return this.second;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && this.getClass() == obj.getClass()) {
            Tuple other = (Tuple)obj;
            result = Tuple.equals(this.getFirst(), other.getFirst()) && Tuple.equals(this.getSecond(), other.getSecond());
        }
        return result;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        this.appendElements(sb, ", ");
        return sb.append(')').toString();
    }

    protected static boolean equals(@Nullable Object o1, @Nullable Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.equals(o2);
    }

    protected void appendElements(StringBuilder sb, String separator) {
        sb.append(this.getFirst()).append(separator).append(this.getSecond());
    }
}

