/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Stack<E>
implements Serializable {
    @NotNull
    private final List<E> elements = new ArrayList();
    private static final long serialVersionUID = 1L;

    private Stack() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Stack<E> create() {
        Stack<E> stack = new Stack<E>();
        if (stack == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Stack.create must not return null");
        }
        return stack;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Stack<E> create(E value) {
        Stack<E> result = Stack.create();
        result.push(value);
        Stack<E> stack = result;
        if (stack == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Stack.create must not return null");
        }
        return stack;
    }

    public E push(E item) {
        this.elements.add(item);
        return item;
    }

    public E pop() {
        int pos = this.size() - 1;
        try {
            return this.elements.remove(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmptyStackException();
        }
    }

    public int size() {
        return this.elements.size();
    }

    public E peek() {
        int pos = this.size() - 1;
        try {
            return this.elements.get(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmptyStackException();
        }
    }

    public boolean empty() {
        return this.elements.isEmpty();
    }

    public void clear() {
        this.elements.clear();
    }

    public void reverse() {
        Collections.reverse(this.elements);
    }
}

