/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.util.Collection;
import java.util.Iterator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import org.jetbrains.annotations.NotNull;

public interface Sequence<T>
extends Iterable<T> {
    public boolean isEmpty();

    public boolean contains(Object var1);

    @Override
    @NotNull
    public Iterator<T> iterator();

    @NotNull
    public Object[] toArray();

    @NotNull
    public <U> U[] toArray(@NotNull U[] var1);

    @NotNull
    public Sequence<T> select(@NotNull Predicate<T> var1);

    public boolean exists(@NotNull Predicate<T> var1);

    @NotNull
    public <D extends T> Sequence<T> flatten(@NotNull Function<? super T, Iterator<D>> var1);

    @NotNull
    public <V extends T> Sequence<V> selectInstanceOf(@NotNull Class<V> var1);

    @NotNull
    public <U> Sequence<U> map(@NotNull Function<T, U> var1);

    public boolean addAllTo(@NotNull Collection<? super T> var1);

    public static abstract class Default<T>
    implements Sequence<T> {
        @Override
        @NotNull
        public abstract Iterator<T> iterator();

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object element) {
            return CollectionUtils.contains(this, element);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Object[] toArray() {
            Object[] objectArray = CollectionUtils.toArray(this);
            if (objectArray == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.toArray must not return null");
            }
            return objectArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <D extends T> Sequence<T> flatten(@NotNull Function<? super T, Iterator<D>> traversal) {
            if (traversal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.flatten must not be null");
            }
            Sequence<? super T> sequence = CollectionUtils.flatten(this, traversal);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.flatten must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <U> U[] toArray(@NotNull U[] a) {
            if (a == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.toArray must not be null");
            }
            U[] UArray = CollectionUtils.toArray(this, a);
            if (UArray == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.toArray must not return null");
            }
            return UArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Sequence<T> select(@NotNull Predicate<T> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.select must not be null");
            }
            Sequence<T> sequence = CollectionUtils.select(this, predicate);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.select must not return null");
            }
            return sequence;
        }

        @Override
        public boolean exists(@NotNull Predicate<T> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.exists must not be null");
            }
            return CollectionUtils.exists(this, predicate);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <V extends T> Sequence<V> selectInstanceOf(@NotNull Class<V> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.selectInstanceOf must not be null");
            }
            Sequence<V> sequence = CollectionUtils.selectInstanceOf(this, clazz);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.selectInstanceOf must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <U> Sequence<U> map(@NotNull Function<T, U> mapper) {
            if (mapper == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.map must not be null");
            }
            Sequence<U> sequence = CollectionUtils.map(this, mapper);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/Sequence$Default.map must not return null");
            }
            return sequence;
        }

        public int hashCode() {
            return CollectionUtils.hashCode(this);
        }

        public boolean equals(Object obj) {
            return obj instanceof Iterable && CollectionUtils.equals(this, (Iterable)obj);
        }

        @Override
        public boolean addAllTo(@NotNull Collection<? super T> c) {
            if (c == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/Sequence$Default.addAllTo must not be null");
            }
            boolean modified = false;
            for (T t : this) {
                if (!c.add(t)) continue;
                modified = true;
            }
            return modified;
        }

        public String toString() {
            return '[' + CollectionUtils.toSeparatedString(this, ", ") + ']';
        }
    }
}

