/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.modeler.util;

import oracle.apps.fnd.wf.modeler.WorkflowModelerConstants;

public class WorkflowModelerUtils
implements WorkflowModelerConstants {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/modeler/util/RCS/WorkflowModelerUtils.java,v 30.14 2005/04/13 20:40:53 mtai noship $";
    private static String diagramDisplayMode = "ModeLabel";
    private static boolean isLogged = true;

    public static String getItemTypePkgName(String processName) {
        int slashPosition = processName.lastIndexOf("/");
        String pName = processName.substring(0, slashPosition);
        int lastSlashPosition = pName.lastIndexOf("/");
        String itemTypePkgName = processName.substring(0, lastSlashPosition);
        if (!itemTypePkgName.startsWith("/")) {
            itemTypePkgName = "/" + itemTypePkgName;
        }
        return itemTypePkgName;
    }

    public static String getDiagramDisplayMode() {
        return diagramDisplayMode;
    }

    public static void setDiagramDisplayMode(String mode) {
        if (mode.equals("ModeInternalName") || mode.equals("ModeDisplayName") || mode.equals("ModeLabel") || mode.equals("ModeQName") || mode.equals("ModeUserComment") || mode.equals("ModePAId")) {
            diagramDisplayMode = mode;
        }
    }

    public static boolean isLogEnabled() {
        return isLogged;
    }

    public static void setLogEnabled(boolean log) {
        isLogged = log;
    }

    public static final String getProp(String key) {
        try {
            return WF_IT_RES.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static final String getMessage(String key) {
        try {
            return WF_MSG_RES.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static final char getMnemonic(String key) {
        try {
            return WF_IT_RES.getString(key + "_MNEMONIC").charAt(0);
        }
        catch (Exception e) {
            return key.charAt(0);
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public String getIdPrefix(String tagName, String pName) {
        String pref = "";
        if (tagName.equals("functionActivity")) {
            pref = "BS";
        } else if (tagName.equals("activityAttribute")) {
            pref = pName != null ? "AA" + pName : "AA";
        } else if (tagName.equals("itemAttribute")) {
            pref = "IA";
        } else if (tagName.equals("function")) {
            pref = pName != null ? "FN" + pName : "FN";
        } else if (tagName.equals("notificationActivity")) {
            pref = "NT";
        } else if (tagName.equals("message")) {
            pref = "MS";
        } else if (tagName.equals("messageAttribute")) {
            pref = pName != null ? "MA" + pName : "MA";
        } else if (tagName.equals("eventActivity")) {
            pref = "EV";
        } else if (tagName.equals("lookupType")) {
            pref = "";
        } else if (tagName.equals("lookupCode")) {
            pref = pName != null ? pName : "";
        }
        return pref;
    }

    public static String getDisplayName(String fullName, String tagName, String type) {
        if (tagName.equals("ItemType")) {
            int p = fullName.indexOf("/OracleWFItemType");
            if (p > 0) {
                return fullName.substring(0, p);
            }
            return null;
        }
        return fullName;
    }
}

