/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.engine.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.apps.fnd.wf.WFContext;
import oracle.apps.fnd.wf.WFDB;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;

public class Helper {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/engine/util/RCS/Helper.java,v 30.6 2004/12/14 00:13:37 anpwang noship $";

    private static String replace(String stringValue, String oldString, String newString) {
        int index = stringValue.indexOf(oldString);
        while (index > -1) {
            stringValue = stringValue.substring(0, index) + newString + stringValue.substring(index + oldString.length(), stringValue.length());
            index = stringValue.indexOf(oldString, index + newString.length());
        }
        return stringValue;
    }

    public static WFContext getWFContext(WorkflowContext pCtx) {
        WFContext mWFContext = null;
        try {
            WFDB wfDB = new WFDB();
            wfDB.setConnection(null);
            mWFContext = new WFContext(wfDB, "UTF8");
            return mWFContext;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException(e);
        }
    }

    public static String toXMLSafe(String value) {
        if (value == null) {
            return null;
        }
        String old = value;
        old = Helper.replace(old, "&", "&amp;");
        old = Helper.replace(old, "\"", "&quot;");
        old = Helper.replace(old, "<", "&lt;");
        old = Helper.replace(old, ">", "&gt;");
        return old;
    }

    public static String decodeXMLSafe(String value) {
        if (value == null) {
            return null;
        }
        String old = value;
        old = Helper.replace(old, "&amp;", "&");
        old = Helper.replace(old, "&quot;", "\"");
        old = Helper.replace(old, "&lt;", "<");
        old = Helper.replace(old, "&gt;", ">");
        return old;
    }

    public static boolean isEmptyString(String testString) {
        return testString == null || testString.length() == 0;
    }

    public static Class getClass(String pClassName) throws WorkflowException {
        try {
            Class<?> pClass = Helper.getPrimitiveType(pClassName);
            if (pClassName == null) {
                throw new WorkflowException(Helper.class, "CreateClass.failed[" + pClassName + "]");
            }
            if (pClass == null) {
                pClass = Class.forName(pClassName, true, Thread.currentThread().getContextClassLoader());
            }
            return pClass;
        }
        catch (ClassNotFoundException e) {
            throw new WorkflowException(Helper.class, "ClassNotFound[" + pClassName + "]");
        }
    }

    public static Object createInstance(String pClassName) throws WorkflowException {
        try {
            return Helper.getClass(pClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new WorkflowException(Helper.class, "InstantiationException[" + pClassName + "]");
        }
        catch (IllegalAccessException e) {
            throw new WorkflowException(Helper.class, "IllegalAccessException[" + pClassName + "]");
        }
    }

    public static Object createInstance(Object pRunObject, Class[] pParamTypes, Object[] pParams) throws WorkflowException {
        Class javaClass = null;
        if (pRunObject instanceof String) {
            javaClass = Helper.getClass(pRunObject.toString());
        } else if (pRunObject instanceof Class) {
            javaClass = (Class)pRunObject;
        } else {
            throw new IllegalArgumentException("CreateObject.Invalid.Parameter[" + pRunObject + "]");
        }
        Constructor constr = Helper.findConstructor(javaClass, pParamTypes);
        if (constr != null) {
            try {
                return constr.newInstance(pParams);
            }
            catch (InstantiationException e) {
                throw new WorkflowException(Helper.class, "InstantiationException[" + pRunObject + "]");
            }
            catch (IllegalAccessException e) {
                throw new WorkflowException(Helper.class, "IllegalAccessException[" + pRunObject + "]");
            }
            catch (InvocationTargetException e) {
                throw new WorkflowException(Helper.class, "InvocationTargetException[" + pRunObject + "]");
            }
        }
        String paramList = "";
        for (int i = 0; i < pParamTypes.length; ++i) {
            paramList = paramList + pParamTypes[i] + "=" + pParams[i] + "\n";
        }
        throw new WorkflowException(Helper.class, "Constructor.Notfound[" + pRunObject + "(" + paramList + ")]");
    }

    private static Class getPrimitiveType(String pClassName) {
        if ("int".equals(pClassName)) {
            return Integer.TYPE;
        }
        if ("float".equals(pClassName)) {
            return Float.TYPE;
        }
        if ("double".equals(pClassName)) {
            return Double.TYPE;
        }
        if ("long".equals(pClassName)) {
            return Long.TYPE;
        }
        if ("boolean".equals(pClassName)) {
            return Boolean.TYPE;
        }
        if ("char".equals(pClassName)) {
            return Character.TYPE;
        }
        if ("byte".equals(pClassName)) {
            return Byte.TYPE;
        }
        if ("short".equals(pClassName)) {
            return Short.TYPE;
        }
        if ("void".equals(pClassName)) {
            return Void.TYPE;
        }
        return null;
    }

    public static Method findMethod(Class javaClass, String pMethodName, Class[] pParamType) {
        if (javaClass == null || pMethodName == null || pMethodName.length() == 0 || pParamType == null) {
            throw new IllegalArgumentException("findMethod.RequiredParameters.NotSpecified");
        }
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] classes;
            Method method = methods[i];
            if (!method.getName().equals(pMethodName) || (classes = method.getParameterTypes()).length != pParamType.length) continue;
            boolean bTest = true;
            for (int j = 0; j < classes.length; ++j) {
                Class<?> requiredClass = classes[j];
                Class targetClass = pParamType[j];
                bTest = bTest && (requiredClass == targetClass || Helper.isSuper(requiredClass, targetClass));
            }
            if (!bTest) continue;
            return method;
        }
        return null;
    }

    private static boolean isSuper(Class parent, Class child) {
        if (parent == Object.class) {
            return true;
        }
        if (child.getSuperclass() == parent) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        if (child == Object.class) {
            return false;
        }
        return Helper.isSuper(parent, child.getSuperclass());
    }

    public static Constructor findConstructor(Class pJavaClass, Class[] pParamTypeList) {
        if (pJavaClass == null || pParamTypeList == null) {
            throw new IllegalArgumentException("findConstructor.RequiredParameters.NotSpecified");
        }
        Constructor<?>[] constrcutors = pJavaClass.getConstructors();
        for (int i = 0; i < constrcutors.length; ++i) {
            Constructor<?> constrcutor = constrcutors[i];
            Class<?>[] classes = constrcutor.getParameterTypes();
            if (classes.length != pParamTypeList.length) continue;
            boolean bTest = true;
            for (int j = 0; j < classes.length; ++j) {
                Class<?> requiredClass = classes[j];
                Class targetClass = pParamTypeList[j];
                bTest = bTest && (requiredClass == targetClass || Helper.isSuper(requiredClass, targetClass));
            }
            if (!bTest) continue;
            return constrcutor;
        }
        return null;
    }
}

