/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.engine.el;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import oracle.apps.fnd.wf.engine.el.WFELException;
import oracle.apps.fnd.wf.engine.el.WFExpression;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class XPathExpression
extends WFExpression {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/engine/el/RCS/XPathExpression.java,v 30.2 2004/12/13 22:53:49 anpwang noship $";
    private String mExpression;
    private Class mExpectedType;
    private FunctionMapper mFunctionMapper;

    public XPathExpression() {
    }

    XPathExpression(String pExpression, Class pExpectedType, FunctionMapper pFunctionMapper) {
        this.mExpression = pExpression.substring(2, pExpression.length() - 1);
        this.mExpectedType = pExpectedType;
        this.mFunctionMapper = pFunctionMapper;
    }

    public Object evaluate(VariableResolver vResolver) throws ELException {
        String objName = this.mExpression.substring(0, this.mExpression.indexOf("/"));
        objName = objName.toUpperCase();
        Object userObject = vResolver.resolveVariable(objName);
        String expression = this.mExpression.substring(this.mExpression.indexOf("/") + 1);
        return this.evaluate(userObject, expression);
    }

    public Object evaluate(Object pXMLMessage, String pExpression) throws WFELException {
        String pattern = pExpression;
        Node node = null;
        Object bResult = null;
        if (pXMLMessage instanceof String) {
            DOMParser parser = new DOMParser();
            try {
                parser.parse((Reader)new BufferedReader(new StringReader(pXMLMessage.toString())));
                XMLDocument document = parser.getDocument();
                XMLElement xmlElement = (XMLElement)document.getFirstChild();
                final String ns = xmlElement.getNamespaceURI();
                if (ns == null) {
                    node = xmlElement.selectSingleNode(pattern);
                }
                NSResolver resolver = new NSResolver(){

                    public String resolveNamespacePrefix(String prefix) {
                        return ns;
                    }
                };
                node = xmlElement.selectSingleNode(pattern, resolver);
            }
            catch (Exception e) {
                throw new WFELException((Object)this, e.getMessage());
            }
        } else if (pXMLMessage instanceof XMLElement) {
            try {
                XMLElement xmlElement = (XMLElement)pXMLMessage;
                final String ns = xmlElement.getNamespaceURI();
                NSResolver resolver = new NSResolver(){

                    public String resolveNamespacePrefix(String prefix) {
                        return ns;
                    }
                };
                node = xmlElement.selectSingleNode(pattern, resolver);
            }
            catch (Exception e) {
                throw new WFELException((Object)this, e.getMessage());
            }
        }
        return node == null ? null : node.getNodeValue();
    }

    public static Object parse(Object xmlValue, String selectStmt) throws WFELException {
        return new XPathExpression().evaluate(xmlValue, selectStmt);
    }
}

