/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design.loader.wft;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.wf.common.BaseComponent;
import oracle.apps.fnd.wf.common.Element;
import oracle.apps.fnd.wf.common.Loader;
import oracle.apps.fnd.wf.common.Predicate;
import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.AccessController;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.ActivityAttribute;
import oracle.apps.fnd.wf.design.Attribute;
import oracle.apps.fnd.wf.design.AttributeValue;
import oracle.apps.fnd.wf.design.DesignBaseAttributeComponent;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.DesignStore;
import oracle.apps.fnd.wf.design.EventActivity;
import oracle.apps.fnd.wf.design.Function;
import oracle.apps.fnd.wf.design.FunctionActivity;
import oracle.apps.fnd.wf.design.ItemAttribute;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.LookupCode;
import oracle.apps.fnd.wf.design.LookupType;
import oracle.apps.fnd.wf.design.Message;
import oracle.apps.fnd.wf.design.MessageAttribute;
import oracle.apps.fnd.wf.design.Notification;
import oracle.apps.fnd.wf.design.Process;
import oracle.apps.fnd.wf.design.ProcessActivity;
import oracle.apps.fnd.wf.design.Role;
import oracle.apps.fnd.wf.design.Transition;
import oracle.apps.fnd.wf.design.Version;

public class WFLoader
implements Loader {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/loader/wft/RCS/WFLoader.java,v 30.0 2005/01/17 22:28:04 anpwang noship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: /wfdev/wf/3.0/java/design/loader/wft/RCS/WFLoader.java,v 30.0 2005/01/17 22:28:04 anpwang noship $", "oracle.apps.fnd.wf.design.loader");
    private Hashtable objectNames = new Hashtable();
    private DesignStore store;
    private DesignBaseComponent currentObject = null;
    private DesignBaseComponent owner = null;
    private String objectName;
    private static final Logger LOG = Logger.getLogger(WFLoader.class.getName());
    private static String[] mHdr = new String[4];
    private static String[] mDefine = new String[157];
    private static int maxLineSize = 79;
    private static String INTERNAL_LINE_SEPERATOR = "\n";
    private static String OVERFLOWLINE_SEPERATOR = "\\";
    private static String MULTILINE_SEPERATOR = "\\n\\";
    private static int OVERFLOWSEPLEN = OVERFLOWLINE_SEPERATOR.length();
    private static int MULTILINESEPLEN = MULTILINE_SEPERATOR.length();
    private static Hashtable activity2Class = new Hashtable();
    private static Hashtable name2Class = new Hashtable();

    private String getClassName(String pKey) {
        return (String)name2Class.get(pKey);
    }

    private String getActivityClassName(String pKey) {
        return (String)activity2Class.get(pKey);
    }

    private DesignBaseComponent getObject(String pLine) {
        String itName = "";
        String pName = "";
        int i = pLine.indexOf("BEGIN ") + "BEGIN ".length();
        int j = pLine.indexOf(" ", i);
        this.objectName = pLine.substring(i, j);
        i = pLine.indexOf("\"") + 1;
        j = pLine.indexOf("\"", i);
        if (i != 0) {
            int x = pLine.indexOf(this.objectName) + this.objectName.length();
            int y = pLine.indexOf(" ", i + 1);
            if (x <= i && x < i - 3) {
                pName = pLine.substring(x + 1, i - 2);
                itName = pLine.substring(i, j);
                if ("ACTIVITY".equals(this.objectName) || "MESSAGE".equals(this.objectName)) {
                    this.owner = this.store.getItemType(pName);
                }
            } else {
                pName = itName = pLine.substring(i, j);
                if (j == pLine.length() - 1) {
                    pName = itName;
                } else {
                    j = pLine.indexOf("\"", i + itName.length() + 1);
                    itName = pLine.substring(j + 1, pLine.length() - 1);
                    if ("ACTIVITY".equals(this.objectName) || "MESSAGE".equals(this.objectName)) {
                        this.owner = this.store.getItemType(pName);
                    }
                }
            }
        } else {
            i = pLine.indexOf(this.objectName) + this.objectName.length();
            j = pLine.indexOf(" ", i + 1);
            if (j != -1 && j != i) {
                pName = itName = pLine.substring(i + 1, j);
                j = pLine.indexOf(" ", i + itName.length());
                itName = pLine.substring(j + 1, pLine.length());
                if ("ACTIVITY".equals(this.objectName) || "MESSAGE".equals(this.objectName)) {
                    this.owner = this.store.getItemType(pName);
                }
            } else {
                pName = itName = pLine.substring(i + 1, pLine.length());
            }
        }
        String className = this.getClassName(this.objectName);
        try {
            this.currentObject = this.createComponent(className);
        }
        catch (Exception e) {
            LOG.severe("Can't create " + this.objectName + " " + e.toString());
            this.currentObject = new DesignBaseComponent();
        }
        this.currentObject.setName(this.preProcess(itName));
        if (this.owner == null) {
            this.owner = this.store;
        }
        this.owner.addChild(this.currentObject);
        this.objectNames.put(this.currentObject, this.objectName);
        if (this.currentObject instanceof Transition) {
            ((Transition)this.currentObject).setActivityResultCode(pName);
            ((Transition)this.currentObject).setToNodeName(itName);
        } else if (this.currentObject instanceof Function && this.owner instanceof Activity) {
            ((Function)this.currentObject).setFunctionType(((Activity)this.owner).getFunctionType());
        }
        return this.currentObject;
    }

    private void processLine(String pLine) {
        int i;
        if (pLine == null || pLine.equals("")) {
            return;
        }
        if (pLine.indexOf("BEGIN") > -1) {
            this.owner = this.currentObject = this.getObject(pLine);
        } else if (pLine.indexOf("END " + this.objectName) > -1) {
            if (this.currentObject != null) {
                if ("ACTIVITY".equals(this.objectName) || "MESSAGE".equals(this.objectName)) {
                    this.owner = this.store;
                    this.currentObject = null;
                } else {
                    this.owner = this.currentObject = (DesignBaseComponent)this.currentObject.getParent();
                    this.objectName = "";
                    if (this.currentObject != null) {
                        this.objectName = (String)this.objectNames.get(this.currentObject);
                    }
                }
            }
        } else if (this.currentObject != null && (i = pLine.indexOf("=")) > 0) {
            String propName = pLine.substring(0, i).trim();
            String propValue = pLine.substring(i + 1).trim();
            this.setProperty(propName, propValue);
        }
    }

    private DesignBaseComponent createComponent(String className) throws Exception {
        return (DesignBaseComponent)Class.forName(className).newInstance();
    }

    private String preProcess(String value) {
        if (value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '\"') {
            value = value.substring(0, value.length() - 1);
        }
        if (value.indexOf("\\\"") != -1) {
            value = this.replaceToken(value, "\\\"", "\"");
        }
        return value;
    }

    private String replaceToken(String origStr, String oldTkn, String newTkn) {
        String rtnStr = "";
        int delimPos = 0;
        int fromIdx = 0;
        int oldTknSize = oldTkn.length();
        if (origStr == null) {
            return null;
        }
        while ((delimPos = origStr.indexOf(oldTkn, fromIdx)) > -1) {
            String tmpStr = origStr.substring(fromIdx, delimPos);
            fromIdx += tmpStr.length() + oldTknSize;
            rtnStr = rtnStr + tmpStr;
            rtnStr = rtnStr + newTkn;
        }
        rtnStr = rtnStr + origStr.substring(fromIdx, origStr.length());
        return rtnStr;
    }

    private void setCmpProperty(BaseComponent cmp, String propName, String propValue) {
        if (propName.equals("NAME")) {
            ((DesignBaseComponent)cmp).setName(propValue);
        }
    }

    private void setStoreProperty(DesignStore cmp, String propName, String propValue) {
        if (propName.equals("VERSION_MAJOR")) {
            cmp.setMajorVersion(propValue);
        } else if (propName.equals("VERSION_MINOR")) {
            cmp.setMinorVersion(propValue);
        } else if (propName.equals("LANGUAGE")) {
            cmp.setLanguage(propValue);
        } else if (propName.equals("ACCESS_LEVEL")) {
            cmp.setAccessLevel(propValue);
        }
    }

    private void setBaseCmpProperty(DesignBaseComponent cmp, String propName, String propValue) {
        if (propName.equals("DISPLAY_NAME")) {
            cmp.setDisplayName(propValue);
        } else if (propName.equals("DESCRIPTION")) {
            cmp.setDescription(propValue);
        } else if (propName.equals("PROTECT_LEVEL")) {
            cmp.getAccessController().setProtectLevel(propValue);
        } else if (propName.equals("CUSTOM_LEVEL")) {
            cmp.getAccessController().setCustomLevel(propValue);
        } else if (propName.equals("EXECUTE_ROLE")) {
            cmp.getAccessController().setExecuteRole(propValue);
        } else if (propName.equals("READ_ROLE")) {
            cmp.getAccessController().setReadRole(propValue);
        } else if (propName.equals("WRITE_ROLE")) {
            cmp.getAccessController().setWriteRole(propValue);
        }
    }

    private void setTransitionProperty(Transition transition, String propName, String propValue) {
        if (propName.equals("ARROW_GEOMETRY")) {
            transition.setGeometry(propValue);
        }
    }

    private void setProcessActivityProperty(ProcessActivity pac, String propName, String propValue) {
        if (propName.equals("ACTIVITY_ITEM_TYPE")) {
            pac.setItemType(propValue);
        } else if (propName.equals("ACTIVITY_NAME")) {
            pac.setActivityName(propValue);
        } else if (propName.equals("START_END")) {
            pac.setNodeType(propValue);
        } else if (propName.equals("DEFAULT_RESULT")) {
            pac.setDefaultResult(propValue);
        } else if (propName.equals("ICON_GEOMETRY")) {
            pac.setIconGeometry(propValue);
        } else if (propName.equals("VALUE_TYPE")) {
            pac.setPerformerNameType(propValue);
        } else if (propName.equals("PERFORM_ROLE")) {
            pac.setPerformerName(propValue);
        } else if (propName.equals("USER_COMMENT")) {
            pac.setComment(propValue);
        }
    }

    private void setActivityProperty(Activity act, String propName, String propValue) {
        if (propName.equals("ICON_NAME")) {
            act.setIconName(propValue);
        } else if (propName.equals("RERUN")) {
            act.setActionOnRevisit(propValue);
        } else if (propName.equals("COST")) {
            Integer intPropVal = new Integer(propValue);
            act.setCost(intPropVal);
        } else if (propName.equals("VERSION")) {
            Integer intPropVal = new Integer(propValue);
            act.setVersion(new Version(intPropVal));
        } else if (propName.equals("RESULT_TYPE")) {
            act.setResult(propValue);
        } else if (propName.equals("ERROR_ITEM_TYPE")) {
            act.setErrorItemType(propValue);
        } else if (propName.equals("ERROR_PROCESS")) {
            act.setErrorProcess(propValue);
        } else if (propName.equals("FUNCTION_TYPE")) {
            act.setFunctionType(propValue);
            this.resolveActFunctionName(act);
        } else if (propName.equals("FUNCTION")) {
            act.setTempFunction(propValue);
            this.resolveActFunctionName(act);
        } else if (propName.equals("RUNNABLE") && propValue != null) {
            act.setRunnable(propValue.equals("Y"));
        } else if (propName.equals("MESSAGE")) {
            act.setMessageName(propValue);
        }
    }

    private void resolveActFunctionName(Activity act) {
        String functionType = act.getFunctionType();
        String functionName = act.getTempFunction();
        if (functionName != null && functionType != null) {
            if ("EXTERNAL".equals(functionType)) {
                functionType = functionName.toLowerCase().indexOf("<soap>") != -1 ? "SOAP" : (functionName.toLowerCase().indexOf("<plsql>") != -1 ? "PLSQL" : (functionName.toLowerCase().indexOf("<java>") != -1 ? "JAVA" : (functionName.toLowerCase().indexOf("<adfm>") != -1 ? "ADFM" : (functionName.toLowerCase().indexOf("<ejb>") != -1 ? "EJB" : "JAVA"))));
                functionName = functionName.substring(functionName.indexOf(">") + 1);
                act.setTempFunction(functionName);
            }
            act.setFunctionType(functionType);
        }
    }

    private void setItemTypeProperty(ItemType itt, String propName, String propValue) {
        if (propName.equals("PERSISTENCE_DAYS")) {
            itt.setPersistenceDuration(Integer.parseInt(propValue));
        } else if (propName.equals("PERSISTENCE_TYPE")) {
            itt.setPersistenceType(propValue);
        } else if (propName.equals("WF_SELECTOR")) {
            Function func = new Function(propValue);
            propValue = propValue.toLowerCase();
            func.setFunctionName(propValue);
            itt.setSelector(func);
        }
    }

    private void setEventProperty(EventActivity eventActivity, String propName, String propValue) {
        if (propName.equals("EVENT_FILTER")) {
            eventActivity.setFilter(propValue);
        } else if (propName.equals("EVENT_TYPE")) {
            eventActivity.setAction(propValue);
        }
    }

    private void setAttributeProperty(ItemAttribute attribute, String propName, String propValue) {
        this.setGenericAttributeProperty(attribute, propName, propValue);
        if (propName.equals("DESCRIPTION")) {
            attribute.setValueType(propValue);
            if (propValue.indexOf("<type>") != -1) {
                String type = propValue.substring(propValue.indexOf("<type>") + 6, propValue.indexOf("</type>"));
                attribute.setNativeType(type);
            }
        }
    }

    private void setAttributeProperty(ActivityAttribute attribute, String propName, String propValue) {
        this.setGenericAttributeProperty(attribute, propName, propValue);
        if (propName.equals("DESCRIPTION")) {
            attribute.setValueType(propValue);
            attribute.setDirection("LOCAL");
            if (propValue.indexOf("<dir>IN</dir>") != -1) {
                attribute.setDirection("IN");
            }
            if (propValue.indexOf("<dir>OUT</dir>") != -1) {
                attribute.setDirection("OUT");
            }
            if (propValue.indexOf("<dir>INOUT</dir>") != -1) {
                attribute.setDirection("INOUT");
            }
            if (propValue.indexOf("<seq>") != -1) {
                String seqValue = propValue.substring(propValue.indexOf("<seq>") + 5, propValue.indexOf("</seq>"));
                try {
                    int seq = Integer.parseInt(seqValue);
                    attribute.setSequence(seq);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (propValue.indexOf("<type>") != -1) {
                String type = propValue.substring(propValue.indexOf("<type>") + 6, propValue.indexOf("</type>"));
                attribute.setNativeType(type);
            }
        }
    }

    private void setAttributeProperty(MessageAttribute attribute, String propName, String propValue) {
        this.setGenericAttributeProperty(attribute, propName, propValue);
    }

    private void setGenericAttributeProperty(Attribute attribute, String propName, String propValue) {
        if (propName.equals("TYPE")) {
            if (attribute.getNativeType() == null) {
                if ("NUMBER".equals(propValue)) {
                    attribute.setNativeType("java.math.BigDecimal");
                } else if ("VARCHAR2".equals(propValue)) {
                    attribute.setNativeType("java.lang.String");
                } else if ("DATE".equals(propValue)) {
                    attribute.setNativeType("java.util.Date");
                } else if ("FORM".equals(propValue)) {
                    attribute.setNativeType("java.lang.Object");
                } else {
                    attribute.setNativeType("java.lang.String");
                }
            }
            attribute.setType(propValue);
        } else if (propName.equals("SUBTYPE")) {
            attribute.setSubtype(propValue);
        } else if (propName.equals("FORMAT")) {
            attribute.setFormat(propValue);
        } else if (propName.equals("ATTACH") && propValue != null && "Y".equals(propValue)) {
            attribute.setAttach(true);
        } else if (propName.equals("VALUE_TYPE")) {
            attribute.setValueType(propValue);
        } else if (propName.equals("DEFAULT")) {
            if (attribute.getValueType() != null && "ITEMATTR".equals(attribute.getValueType())) {
                attribute.setDefaultValue(propValue);
            } else {
                String mFormat = attribute.getFormat();
                String mType = attribute.getType();
                String value = propValue;
                attribute.setDefaultValue(value);
            }
        }
    }

    private void setAttributeValueProperty(AttributeValue attribute, String propName, String propValue) {
        if (propName.equals("VALUE_TYPE")) {
            attribute.setValueType(propValue);
        } else if (propName.equals("VALUE")) {
            attribute.setValue(propValue);
        }
        if ("#EVENTNAME".equals(attribute.getName())) {
            attribute.setName("EVENT_NAME");
        }
        if ("#EVENTKEY".equals(attribute.getName())) {
            attribute.setName("EVENT_KEY");
        }
        if ("#EVENTMESSAGE".equals(attribute.getName())) {
            attribute.setName("EVENT_MESSAGE");
        }
        if ("#EVENTTOAGENT".equals(attribute.getName())) {
            attribute.setName("TO_AGENT");
        }
        if ("#EVENTOUTAGENT".equals(attribute.getName())) {
            attribute.setName("OUT_AGENT");
        }
        if (attribute.getAttributeName() == null) {
            attribute.setAttributeName(attribute.getName());
        }
    }

    private void setLookupCodeProperty(LookupCode lookup, String propName, String propValue) {
        if (propName.equals("MEANING")) {
            lookup.setDisplayName(propValue);
        }
    }

    private void setRoleProperty(Role role, String propName, String propValue) {
        if (propName.equals("NOTIFICATION_PREFERENCE")) {
            role.setNotifcationPref(propValue);
        } else if (propName.equals("LANGUAGE")) {
            role.setLangPref(propValue);
        } else if (propName.equals("TERRITORY")) {
            role.setTerritoryPref(propValue);
        } else if (propName.equals("EMAIL_ADDRESS")) {
            role.setEMail(propValue);
        } else if (propName.equals("FAX")) {
            role.setFax(propValue);
        } else if (propName.equals("STATUS")) {
            role.setStatus(propValue);
        }
    }

    private void setLookupTypeProperty(LookupType lookupType, String propName, String propValue) {
        if (propName.equals("ITEM_TYPE")) {
            ItemType itemType = this.store.getItemType(propValue);
            itemType.addChild(lookupType);
            lookupType.setItemType(propValue);
        }
    }

    private void setMessageProperty(Message message, String propName, String propValue) {
        if (propName.equals("BODY")) {
            message.setBody(propValue);
        } else if (propName.equals("SUBJECT")) {
            message.setSubject(propValue);
        } else if (propName.equals("HTML_BODY")) {
            message.setHtmlBody(propValue);
        } else if (propName.equals("DEFAULT_PRIORITY")) {
            message.setPriority(Integer.parseInt(propValue));
        } else if (propName.equals("READ_ROLE")) {
            message.setReadRoleName(propValue);
        } else if (propName.equals("WRITE_ROLE")) {
            message.setWriteRoleName(propValue);
        } else if (propName.equals("EXECUTE_ROLE")) {
            message.setExecuteRoleName(propValue);
        }
    }

    private void setFunctionProperty(Function fcn, String propName, String propValue) {
        if (propName.equals("FUNCTION")) {
            fcn.setFunctionName(propValue);
        } else if (propName.equals("DESCRIPTOR")) {
            fcn.setDescriptor(propValue);
        }
    }

    private void setProperty(String propName, String propValue) {
        propValue = this.preProcess(propValue);
        if (this.currentObject instanceof BaseComponent) {
            this.setCmpProperty(this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof DesignBaseComponent) {
            this.setBaseCmpProperty(this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof Transition) {
            this.setTransitionProperty((Transition)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof ItemType) {
            this.setItemTypeProperty((ItemType)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof Role) {
            this.setRoleProperty((Role)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof ProcessActivity) {
            this.setProcessActivityProperty((ProcessActivity)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof LookupCode) {
            this.setLookupCodeProperty((LookupCode)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof LookupType) {
            this.setLookupTypeProperty((LookupType)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof ItemAttribute) {
            this.setAttributeProperty((ItemAttribute)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof ActivityAttribute) {
            this.setAttributeProperty((ActivityAttribute)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof MessageAttribute) {
            this.setAttributeProperty((MessageAttribute)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof AttributeValue) {
            this.setAttributeValueProperty((AttributeValue)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof EventActivity) {
            this.setEventProperty((EventActivity)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof DesignStore) {
            this.setStoreProperty((DesignStore)this.currentObject, propName, propValue);
        }
        if (this.objectName != null && this.objectName.equals("ACTIVITY")) {
            if (propName.equals("TYPE")) {
                String className = this.getActivityClassName(propValue);
                DesignBaseAttributeComponent old = (DesignBaseAttributeComponent)this.currentObject;
                if (propValue.equals("FUNCTION")) {
                    this.currentObject = new FunctionActivity(old.getName());
                    ((FunctionActivity)this.currentObject).assign(old);
                    old.getParent().addChild(this.currentObject);
                    old.getParent().removeChild(old);
                    this.objectNames.remove(old);
                    this.objectNames.put(this.currentObject, this.objectName);
                    this.owner = this.currentObject;
                } else if (propValue.equals("NOTICE")) {
                    this.currentObject = new Notification(old.getName());
                    ((Notification)this.currentObject).assign(old);
                    old.getParent().addChild(this.currentObject);
                    old.getParent().removeChild(old);
                    this.objectNames.remove(old);
                    this.objectNames.put(this.currentObject, this.objectName);
                    this.owner = this.currentObject;
                } else if (propValue.equals("PROCESS")) {
                    this.currentObject = new Process(old.getName());
                    ((Process)this.currentObject).assign(old);
                    old.getParent().addChild(this.currentObject);
                    old.getParent().removeChild(old);
                    this.objectNames.remove(old);
                    this.objectNames.put(this.currentObject, this.objectName);
                    this.owner = this.currentObject;
                } else if (propValue.equals("EVENT")) {
                    this.currentObject = new EventActivity(old.getName());
                    ((EventActivity)this.currentObject).assign(old);
                    old.getParent().addChild(this.currentObject);
                    old.getParent().removeChild(old);
                    this.objectNames.remove(old);
                    this.objectNames.put(this.currentObject, this.objectName);
                    ((EventActivity)this.currentObject).setFunctionType("EXTJAVA");
                    ((EventActivity)this.currentObject).setTempFunction("oracle.apps.fnd.wf.engine.standard.StandardEvent.event");
                    this.owner = this.currentObject;
                } else {
                    LOG.warning("Cannot define activity " + propValue);
                }
            }
            if (this.currentObject instanceof Activity) {
                this.setActivityProperty((Activity)this.currentObject, propName, propValue);
            }
        }
        if (this.currentObject instanceof Message) {
            this.setMessageProperty((Message)this.currentObject, propName, propValue);
        }
        if (this.currentObject instanceof Function) {
            this.setFunctionProperty((Function)this.currentObject, propName, propValue);
        }
    }

    private String readLine(BufferedReader br) {
        try {
            int lineLen;
            String lineRead = br.readLine();
            if (lineRead != null && lineRead.lastIndexOf(34) != -1 && lineRead.lastIndexOf(34) != lineRead.length() - 1) {
                while (!lineRead.endsWith("\"")) {
                    if (lineRead.indexOf(92) != -1) {
                        lineRead = lineRead.substring(0, lineRead.indexOf(92));
                    }
                    String lineRead1 = br.readLine();
                    lineRead = lineRead + lineRead1;
                }
            }
            while (lineRead != null && (lineLen = lineRead.length()) > 0) {
                if (lineRead.contains("SERVER_SIDE_VALIDATION")) {
                    boolean l = false;
                }
                if (lineLen >= MULTILINESEPLEN && lineRead.substring(lineRead.length() - MULTILINESEPLEN).equals(MULTILINE_SEPERATOR)) {
                    lineRead = lineRead.substring(0, lineRead.length() - MULTILINESEPLEN) + INTERNAL_LINE_SEPERATOR + br.readLine();
                    continue;
                }
                if (lineLen < OVERFLOWSEPLEN || !lineRead.substring(lineLen - OVERFLOWSEPLEN).equals(OVERFLOWLINE_SEPERATOR)) break;
                lineRead = lineRead.substring(0, lineRead.length() - OVERFLOWSEPLEN) + br.readLine();
            }
            return lineRead;
        }
        catch (IOException ex) {
            throw new WorkflowRuntimeException(this, "readLine", ex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void load(String storageLocation) {
        URL storageURL;
        if (storageLocation == null) {
            throw new IllegalStateException("Could not load store, as persistent media does not exsit");
        }
        if (storageLocation.indexOf(":") == -1) {
            storageURL = this.getClass().getResource(storageLocation);
        } else {
            try {
                storageURL = new URL(storageLocation);
            }
            catch (MalformedURLException e) {
                throw new WorkflowRuntimeException(this, "load", e);
            }
        }
        if (storageURL == null) {
            throw new WorkflowRuntimeException(this, "Could not load store, as persistent media does not exsit " + storageLocation);
        }
        try {
            this.loadStore(storageURL.openStream());
        }
        catch (IOException e) {
            throw new WorkflowRuntimeException(this, "load", e);
        }
    }

    private void save(String storageURL, String charSet) throws Exception {
        int i;
        BufferedWriter fp;
        String storageLocation = null;
        if (storageURL == null) {
            throw new IllegalStateException("Could not save store, as persistent media does not exsit");
        }
        storageLocation = new URL(storageURL).getFile();
        if (storageLocation == null) {
            throw new IllegalStateException("Could not save store, as persistent media does not exsit");
        }
        try {
            fp = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(storageLocation), charSet));
        }
        catch (UnsupportedEncodingException e) {
            fp = new BufferedWriter(new FileWriter(storageLocation));
            LOG.severe(e.toString());
        }
        for (i = 0; i < mHdr.length; ++i) {
            fp.write(mHdr[i]);
            fp.newLine();
        }
        fp.newLine();
        this.writeLine("VERSION_MAJOR = ", this.store.getMajorVersion(), true, fp);
        this.writeLine("VERSION_MINOR = ", this.store.getMinorVersion(), true, fp);
        this.writeLine("LANGUAGE = ", this.store.getLanguage(), true, fp);
        fp.newLine();
        this.writeLine("ACCESS_LEVEL = ", this.store.getAccessLevel(), true, fp);
        fp.newLine();
        for (i = 0; i < mDefine.length; ++i) {
            fp.write(mDefine[i]);
            fp.newLine();
        }
        fp.newLine();
        for (ItemType itt : this.store.getItemTypes()) {
            this.saveItemType(itt, fp);
        }
        for (ItemType child : this.store.getItemTypes()) {
            for (Object obj : child.getChildren()) {
                if (!(obj instanceof LookupType)) continue;
                this.saveLookupType((LookupType)obj, fp);
            }
        }
        for (ItemType child : this.store.getItemTypes()) {
            for (Object obj : child.getChildren()) {
                if (!(obj instanceof Message)) continue;
                this.saveMessage((Message)obj, fp);
            }
        }
        for (ItemType child : this.store.getItemTypes()) {
            for (Object obj : child.getChildren()) {
                if (!(obj instanceof Activity)) continue;
                this.saveActivity((Activity)obj, fp);
            }
        }
        for (Object obj : this.store.getRoles()) {
            if (!(obj instanceof Role)) continue;
            this.saveRole((Role)obj, fp);
        }
        fp.close();
    }

    public synchronized void saveStore(WorkflowContext pCtx, Store pStore) {
        try {
            this.store = (DesignStore)pStore;
            this.save(this.store.getStoreLocation(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void loadStore(WorkflowContext pCtx, Store pStore) {
        this.store = (DesignStore)pStore;
        this.owner = (DesignStore)pStore;
        this.currentObject = (DesignStore)pStore;
        this.load(this.store.getStoreLocation());
        this.store.resolveReference(null);
        for (ItemType itt : this.store.getItemTypes()) {
            for (Process process : itt.getChildrenByType(Process.class)) {
                Iterator iter2 = process.getProcessActivities();
                while (iter2.hasNext()) {
                    ProcessActivity pac = (ProcessActivity)iter2.next();
                    Iterator iter3 = pac.getAttributeValues();
                    while (iter3.hasNext()) {
                        AttributeValue av = (AttributeValue)iter3.next();
                        if (!av.getName().equals("#TIMEOUT")) continue;
                        pac.setTimeOutType(av.getValueType());
                        if ("ITEMATTR".equals(av.getValueType())) {
                            pac.setTimeOutValue(av.getItemName());
                            continue;
                        }
                        pac.setTimeOutValue((String)av.getValue());
                    }
                }
            }
        }
        this.store = null;
        this.currentObject = null;
        this.owner = null;
        this.objectNames.clear();
    }

    public synchronized void loadStore(InputStream pInputStream) {
        BufferedReader br = new BufferedReader(new InputStreamReader(pInputStream, Charset.forName(this.store.getCharSet())));
        String lineRead = this.readLine(br);
        int lineCtr = 1;
        while (lineRead != null) {
            this.processLine(lineRead);
            lineRead = this.readLine(br);
            ++lineCtr;
        }
    }

    @Override
    public synchronized List find(WorkflowContext pCtx, Class pComponentClass, Predicate pQuery) throws WorkflowException {
        return null;
    }

    @Override
    public synchronized void create(WorkflowContext pCtx, Element pComponent) throws WorkflowException {
    }

    @Override
    public synchronized void load(WorkflowContext pCtx, Element pComponent) {
        if (pComponent instanceof Store) {
            this.loadStore(pCtx, (Store)((Object)pComponent));
        }
    }

    @Override
    public synchronized void save(WorkflowContext pCtx, Element pComponent) throws WorkflowException {
        if (pComponent instanceof Store) {
            this.saveStore(pCtx, (Store)((Object)pComponent));
        }
    }

    private void writeLine(String prompt, String data, String data2, boolean useQuote, BufferedWriter fp) {
        String lineData;
        if (data == null || data.equals("")) {
            return;
        }
        if (data2 == null) {
            if (data.indexOf("\"") != -1) {
                data = this.replaceToken(data, "\"", "\\\"");
            }
            if (useQuote) {
                data = "\"" + data + "\"";
            }
            lineData = prompt + data;
        } else {
            if (data.indexOf("\"") != -1) {
                data = this.replaceToken(data, "\"", "\\\"");
            }
            if (data2.indexOf("\"") != -1) {
                data2 = this.replaceToken(data2, "\"", "\\\"");
            }
            if (useQuote) {
                data = "\"" + data + "\" ";
                data2 = "\"" + data2 + "\"";
            } else {
                data = data + " ";
            }
            lineData = prompt + data + data2;
        }
        try {
            if (lineData.indexOf(INTERNAL_LINE_SEPERATOR) > -1) {
                List delimVtr = this.handleDelim(lineData, INTERNAL_LINE_SEPERATOR);
                int delimVtrSize = delimVtr.size();
                for (int i = 0; i < delimVtrSize; ++i) {
                    String delimStr = (String)delimVtr.get(i);
                    if ((delimStr = delimStr + (i < delimVtrSize - 1 ? MULTILINE_SEPERATOR : "")) == null) continue;
                    if (delimStr.length() > maxLineSize) {
                        this.printOverflowLineString(delimStr, fp);
                        continue;
                    }
                    fp.write(delimStr);
                    fp.newLine();
                }
            } else if (lineData.length() > maxLineSize) {
                this.printOverflowLineString(lineData, fp);
            } else {
                fp.write(lineData);
                fp.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(String prompt, String data, boolean useQuote, BufferedWriter fp) {
        this.writeLine(prompt, data, null, useQuote, fp);
    }

    private void writeLine(String str, BufferedWriter fp) {
        if (str == null) {
            return;
        }
        try {
            fp.write(str);
            fp.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List handleDelim(String origStr, String delim) {
        Vector<String> strList = new Vector<String>();
        int delimPos = 0;
        int fromIdx = 0;
        int delimLen = 0;
        if (origStr == null) {
            return null;
        }
        int n = delimLen = delim == null ? 0 : delim.length();
        while ((delimPos = origStr.indexOf(delim, fromIdx)) > -1) {
            String tmpStr = origStr.substring(fromIdx, delimPos);
            fromIdx += tmpStr.length() + delimLen;
            strList.addElement(tmpStr);
        }
        strList.addElement(origStr.substring(fromIdx, origStr.length()));
        return strList;
    }

    private void printOverflowLineString(String origStr, BufferedWriter fp) {
        int lineIdx = 0;
        int minusLength = maxLineSize - 1;
        try {
            for (int lineLen = origStr.length(); lineLen > maxLineSize; lineLen -= minusLength) {
                fp.write(origStr.substring(lineIdx, minusLength + lineIdx) + OVERFLOWLINE_SEPERATOR);
                fp.newLine();
                lineIdx += minusLength;
            }
            fp.write(origStr.substring(lineIdx, origStr.length()));
            fp.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDef(AccessController pAccCtrl, BufferedWriter fp) {
        this.writeLine("  PROTECT_LEVEL = ", pAccCtrl.getProtectLevel(), true, fp);
        this.writeLine("  CUSTOM_LEVEL = ", pAccCtrl.getCustomLevel(), true, fp);
    }

    private void saveAttribute(Attribute attr, String label, boolean subType, BufferedWriter fp) {
        String labelEnd;
        String labelBeg;
        if (label != null && !label.equals("")) {
            labelBeg = "  BEGIN " + label + "_ATTRIBUTE ";
            labelEnd = "  END " + label + "_ATTRIBUTE";
        } else {
            labelBeg = "  BEGIN ATTRIBUTE ";
            labelEnd = "  END ATTRIBUTE";
        }
        this.writeLine("", fp);
        this.writeLine(labelBeg, attr.getName(), true, fp);
        if (label != null && label.equals("ITEM")) {
            this.saveDef(attr.getAccessController(), fp);
        }
        this.writeLine("    DISPLAY_NAME = ", attr.getDisplayName(), true, fp);
        this.writeLine("    DESCRIPTION = ", attr.getDescription(), true, fp);
        this.writeLine("    TYPE = ", attr.getType(), true, fp);
        if (subType) {
            this.writeLine("    SUBTYPE = ", attr.getSubtype(), true, fp);
        }
        this.writeLine("    FORMAT = ", attr.getFormat(), true, fp);
        this.writeLine("    VALUE_TYPE = ", attr.getValueType(), true, fp);
        String defValStr = attr.getDefaultValue() == null ? "" : (attr.getValueType() != null && "ITEMATTR".equals(attr.getValueType()) ? (attr.getDefaultValue() instanceof Attribute ? ((Attribute)attr.getDefaultValue()).getName() : attr.getDefaultValue().toString()) : attr.getDefaultValue().toString());
        this.writeLine("    DEFAULT = ", defValStr, true, fp);
        if (label != null && label.equals("MESSAGE") && attr.isAttach()) {
            this.writeLine("    ATTACH = ", "Y", true, fp);
        }
        this.writeLine(labelEnd, fp);
    }

    private void saveItemType(ItemType itt, BufferedWriter fp) {
        this.writeLine("BEGIN ITEM_TYPE ", itt.getName(), true, fp);
        this.saveDef(itt.getAccessController(), fp);
        this.writeLine("  DISPLAY_NAME = ", itt.getDisplayName(), true, fp);
        this.writeLine("  DESCRIPTION = ", itt.getDescription(), true, fp);
        String selectorFuncName = itt.getSelector() == null ? null : itt.getSelector().getName();
        this.writeLine("  WF_SELECTOR = ", selectorFuncName, true, fp);
        this.writeLine("  READ_ROLE = ", itt.getReadRole(), true, fp);
        this.writeLine("  WRITE_ROLE = ", itt.getWriteRole(), true, fp);
        this.writeLine("  EXECUTE_ROLE = ", itt.getExecuteRole(), true, fp);
        this.writeLine("  PERSISTENCE_TYPE = ", itt.getPersistenceType(), true, fp);
        if (!"PERM".equals(itt.getPersistenceType())) {
            this.writeLine("  PERSISTENCE_DAYS = ", "" + itt.getPersistenceDuration(), true, fp);
        }
        List itattl = itt.getChildren();
        for (int i = 0; i < itattl.size(); ++i) {
            if (!(itattl.get(i) instanceof Attribute)) continue;
            this.saveAttribute((Attribute)itattl.get(i), "ITEM", false, fp);
        }
        this.writeLine("END ITEM_TYPE", fp);
        this.writeLine("", fp);
    }

    private void saveLookupType(LookupType lut, BufferedWriter fp) {
        this.writeLine("BEGIN LOOKUP_TYPE ", lut.getName(), true, fp);
        this.saveDef(lut.getAccessController(), fp);
        this.writeLine("  DISPLAY_NAME = ", lut.getDisplayName(), true, fp);
        this.writeLine("  DESCRIPTION = ", lut.getDescription(), true, fp);
        this.writeLine("  ITEM_TYPE = ", lut.getItemType(), true, fp);
        List ltattl = lut.getChildren();
        for (int i = 0; i < ltattl.size(); ++i) {
            if (!(ltattl.get(i) instanceof LookupCode)) continue;
            this.saveLookupCode((LookupCode)ltattl.get(i), fp);
        }
        this.writeLine("END LOOKUP_TYPE", fp);
        this.writeLine("", fp);
    }

    private void saveLookupCode(LookupCode luc, BufferedWriter fp) {
        this.writeLine("", fp);
        this.writeLine("  BEGIN LOOKUP_CODE ", luc.getName(), true, fp);
        this.writeLine("    MEANING = ", luc.getDisplayName(), true, fp);
        this.writeLine("    DESCRIPTION = ", luc.getExpression(), true, fp);
        this.writeLine("  END LOOKUP_CODE", fp);
    }

    private void saveActivity(Activity act, BufferedWriter fp) {
        int i;
        this.writeLine("BEGIN ACTIVITY ", act.getItemType().getName(), act.getName(), true, fp);
        this.saveDef(act.getAccessController(), fp);
        this.writeLine("  DISPLAY_NAME = ", act.getDisplayName(), true, fp);
        this.writeLine("  DESCRIPTION = ", act.getDescription(), true, fp);
        this.writeLine("  TYPE = ", act.getType(), true, fp);
        String funcName = act.getTempFunction();
        this.writeLine("  FUNCTION = ", funcName, true, fp);
        this.writeLine("  FUNCTION_TYPE = ", act.getFunctionType(), true, fp);
        this.writeLine("  RESULT_TYPE = ", act.getResult(), true, fp);
        this.writeLine("  RERUN = ", act.getActionOnRevisit(), true, fp);
        String costStr = new Integer(act.getCost()).toString();
        this.writeLine("  COST = ", costStr, true, fp);
        if (act.getReadRole() != null) {
            this.writeLine("  READ_ROLE = ", act.getReadRole().toString(), true, fp);
        }
        if (act.getWriteRole() != null) {
            this.writeLine("  WRITE_ROLE = ", act.getWriteRole().toString(), true, fp);
        }
        if (act.getExecuteRole() != null) {
            this.writeLine("  EXECUTE_ROLE = ", act.getExecuteRole().toString(), true, fp);
        }
        this.writeLine("  ICON_NAME = ", act.getIconName(), true, fp);
        this.writeLine("  MESSAGE = ", act.getMessageName(), true, fp);
        this.writeLine("  ERROR_PROCESS = ", act.getErrorProcess(), true, fp);
        this.writeLine("  ERROR_ITEM_TYPE = ", act.getErrorItemType(), true, fp);
        if (act instanceof Notification && ((Notification)act).isRoleExpandable()) {
            this.writeLine("  EXPAND_ROLE = ", "Y", true, fp);
        }
        if (act.isRunnable()) {
            this.writeLine("  RUNNABLE = ", "Y", true, fp);
        } else {
            this.writeLine("  RUNNABLE = ", "N", true, fp);
        }
        List actattl = act.getChildren();
        for (i = 0; i < actattl.size(); ++i) {
            if (!(actattl.get(i) instanceof Attribute)) continue;
            this.saveAttribute((Attribute)actattl.get(i), "ACTIVITY", false, fp);
        }
        actattl = act.getChildren();
        for (i = 0; i < actattl.size(); ++i) {
            if (!(actattl.get(i) instanceof ProcessActivity)) continue;
            this.saveProcessActivity((ProcessActivity)actattl.get(i), fp);
            List tranl = ((ProcessActivity)actattl.get(i)).getChildren();
            for (int j = 0; j < tranl.size(); ++j) {
                if (!(tranl.get(j) instanceof Transition)) continue;
                this.saveTransition((Transition)tranl.get(j), fp);
            }
            this.writeLine("  END PROCESS_ACTIVITY", fp);
        }
        actattl = act.getChildrenByType(Function.class);
        if (actattl.size() == 1) {
            if (act.getFunctionType() != null && (act.getFunctionType().equals("SOAP") || act.getFunctionType().equals("JAVA") || act.getFunctionType().equals("EJB"))) {
                this.saveFunction((Function)actattl.get(0), fp);
            }
        } else if (actattl.size() > 1) {
            for (i = 0; i < actattl.size(); ++i) {
                this.saveFunction((Function)actattl.get(i), fp);
            }
        }
        this.writeLine("END ACTIVITY", fp);
        this.writeLine("", fp);
    }

    private void saveMessage(Message msg, BufferedWriter fp) {
        this.writeLine("BEGIN MESSAGE ", msg.getItemType().getName(), msg.getName(), true, fp);
        this.saveDef(msg.getAccessController(), fp);
        this.writeLine("  DISPLAY_NAME = ", msg.getDisplayName(), true, fp);
        this.writeLine("  DESCRIPTION = ", msg.getDescription(), true, fp);
        this.writeLine("  SUBJECT = ", msg.getSubject(), true, fp);
        this.writeLine("  BODY = ", msg.getBody(), true, fp);
        this.writeLine("  HTML_BODY = ", msg.getHtmlBody(), true, fp);
        this.writeLine("  DEFAULT_PRIORITY = ", "" + msg.getPriority(), true, fp);
        this.writeLine("  READ_ROLE = ", msg.getReadRole(), true, fp);
        this.writeLine("  WRITE_ROLE = ", msg.getWriteRole(), true, fp);
        this.writeLine("  EXECUTE_ROLE = ", msg.getExecuteRole(), true, fp);
        List msgattl = msg.getChildren();
        for (int i = 0; i < msgattl.size(); ++i) {
            if (!(msgattl.get(i) instanceof Attribute)) continue;
            this.saveAttribute((Attribute)msgattl.get(i), "MESSAGE", true, fp);
        }
        this.writeLine("END MESSAGE", fp);
        this.writeLine("", fp);
    }

    private void saveProcessActivity(ProcessActivity pac, BufferedWriter fp) {
        this.writeLine("", fp);
        this.writeLine("  BEGIN PROCESS_ACTIVITY ", pac.getName(), true, fp);
        this.writeLine("    ACTIVITY_ITEM_TYPE = ", pac.getItemType(), true, fp);
        String actName = pac.getActivity() == null ? null : pac.getActivity().getName();
        this.writeLine("    ACTIVITY_NAME = ", actName, true, fp);
        this.writeLine("    START_END = ", pac.getNodeType(), true, fp);
        this.writeLine("    DEFAULT_RESULT = ", pac.getDefaultResult(), true, fp);
        this.writeLine("    ICON_GEOMETRY = ", pac.getIconGeometry(), true, fp);
        this.writeLine("    VALUE_TYPE = ", pac.getPerformerNameType(), true, fp);
        this.writeLine("    PERFORM_ROLE = ", pac.getPerformerName(), true, fp);
        this.writeLine("    USER_COMMENT = ", pac.getComment(), true, fp);
        if (pac.getTimeOutType() != null && !pac.getTimeOutType().equals("")) {
            this.writeLine("", fp);
            this.writeLine("  BEGIN ACTIVITY_ATTRIBUTE_VALUE ", "#TIMEOUT", true, fp);
            this.writeLine("      VALUE_TYPE = ", pac.getTimeOutType(), true, fp);
            if (pac.getTimeOutType().equals("CONSTANT")) {
                this.writeLine("      VALUE = ", pac.getTimeOutValue(), true, fp);
            } else if (pac.getTimeOutType().equals("ITEMATTR")) {
                this.writeLine("      VALUE = ", pac.getTimeOutValue(), true, fp);
            } else {
                LOG.warning("WFLDR_UNKNOWN_TYPE for #TIMEOUT attribute");
            }
            this.writeLine("    END ACTIVITY_ATTRIBUTE_VALUE", fp);
        }
        if (pac.getPriorityType() != null && !pac.getPriorityType().equals("")) {
            this.writeLine("", fp);
            this.writeLine("  BEGIN ACTIVITY_ATTRIBUTE_VALUE ", "##PRIORITY", true, fp);
            this.writeLine("      VALUE_TYPE = ", pac.getPriorityType(), true, fp);
            if (pac.getPriorityType().equals("CONSTANT")) {
                this.writeLine("      VALUE = ", pac.getPriorityValue(), true, fp);
            } else if (pac.getPriorityType().equals("ITEMATTR")) {
                this.writeLine("      VALUE = ", pac.getPriorityValue(), true, fp);
            } else {
                LOG.warning("WFLDR_UNKNOWN_TYPE for ##PRIORITY attribute");
            }
            this.writeLine("    END ACTIVITY_ATTRIBUTE_VALUE", fp);
        }
        List pacattl = pac.getChildren();
        for (int i = 0; i < pacattl.size(); ++i) {
            if (!(pacattl.get(i) instanceof AttributeValue)) continue;
            this.saveProcessActivityValue((AttributeValue)pacattl.get(i), fp);
        }
    }

    private void saveProcessActivityValue(AttributeValue atv, BufferedWriter fp) {
        String atvValType = atv.getValueType();
        this.writeLine("", fp);
        this.writeLine("    BEGIN ACTIVITY_ATTRIBUTE_VALUE ", atv.getName(), true, fp);
        this.writeLine("      VALUE_TYPE = ", atvValType, true, fp);
        if (atvValType != null && atvValType.equals("ITEMATTR")) {
            String paVal = atv.getItemName();
            this.writeLine("      VALUE = ", paVal, true, fp);
        } else {
            Object paVal = atv.getValue();
            if (paVal != null && !(paVal instanceof String)) {
                this.writeLine("      VALUE = ", paVal.toString(), true, fp);
            } else {
                this.writeLine("      VALUE = ", (String)paVal, true, fp);
            }
        }
        this.writeLine("    END ACTIVITY_ATTRIBUTE_VALUE", fp);
    }

    private void saveTransition(Transition pat, BufferedWriter fp) {
        this.writeLine("", fp);
        this.writeLine("    BEGIN ACTIVITY_TRANSITION ", pat.getActivityResultCode(), pat.getToNodeName(), true, fp);
        this.writeLine("      ARROW_GEOMETRY = ", pat.getGeometry(), true, fp);
        this.writeLine("    END ACTIVITY_TRANSITION", fp);
    }

    private void saveFunction(Function fcn, BufferedWriter fp) {
        this.writeLine("", fp);
        this.writeLine("  BEGIN FUNCTION ", fcn.getFunctionMode(), true, fp);
        this.writeLine("    FUNCTION = ", fcn.getFunctionName(), true, fp);
        this.writeLine("    DESCRIPTOR = ", fcn.getDescriptor(), true, fp);
        this.writeLine("  END FUNCTION", fp);
    }

    @Override
    public BaseComponent loadChild(WorkflowContext pCtx, BaseComponent pParent, Class pChildClass, String pName) throws WorkflowException {
        return null;
    }

    @Override
    public List loadChildren(WorkflowContext pCtx, BaseComponent pParent, Class pChildClass) throws WorkflowException {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void synch(WorkflowContext pCtx, Element element) throws WorkflowException {
    }

    @Override
    public void lock(WorkflowContext pCtx, Element element) throws WorkflowException {
    }

    @Override
    public void unlock(WorkflowContext pCtx, Element element) throws WorkflowException {
    }

    private void saveRole(Role role, BufferedWriter fp) {
        this.writeLine("", fp);
        this.writeLine("BEGIN ROLE ", role.getName(), true, fp);
        this.writeLine("  DISPLAY_NAME = ", role.getDisplayName(), true, fp);
        this.writeLine("  DESCRIPTION = ", role.getDescription(), true, fp);
        if (role.getNotifcationPref() != null) {
            this.writeLine("  NOTIFICATION_PREFERENCE = ", role.getNotifcationPref(), true, fp);
        }
        if (role.getLangPref() != null) {
            this.writeLine("  LANGUAGE", role.getLangPref(), true, fp);
        }
        if (role.getTerritoryPref() != null) {
            this.writeLine("  TERRITORY = ", role.getTerritoryPref(), true, fp);
        }
        if (role.getEMail() != null) {
            this.writeLine("  EMAIL_ADDRESS = ", role.getEMail(), true, fp);
        }
        if (role.getFax() != null) {
            this.writeLine("  FAX", role.getFax(), true, fp);
        }
        if (role.getStatus() != null) {
            this.writeLine("  STATUS = ", role.getStatus(), true, fp);
        }
        this.writeLine("END ROLE ", fp);
    }

    static {
        String pkgName = "oracle.apps.fnd.wf.design.";
        activity2Class.put("FUNCTION", pkgName + "FunctionActivity");
        activity2Class.put("NOTICE", pkgName + "Notification");
        activity2Class.put("EVENT", pkgName + "EventActivity");
        activity2Class.put("PROCESS", pkgName + "Process");
        name2Class.put("ITEM_TYPE", pkgName + "ItemType");
        name2Class.put("ROLE", pkgName + "Role");
        name2Class.put("MESSAGE_ATTRIBUTE", pkgName + "MessageAttribute");
        name2Class.put("ITEM_ATTRIBUTE", pkgName + "ItemAttribute");
        name2Class.put("ACTIVITY_ATTRIBUTE", pkgName + "ActivityAttribute");
        name2Class.put("MESSAGE", pkgName + "Message");
        name2Class.put("EVENT", pkgName + "Event");
        name2Class.put("PROCESS_ACTIVITY", pkgName + "ProcessActivity");
        name2Class.put("ACTIVITY", pkgName + "DesignBaseAttributeComponent");
        name2Class.put("ACTIVITY_TRANSITION", pkgName + "Transition");
        name2Class.put("LOOKUP_TYPE", pkgName + "LookupType");
        name2Class.put("LOOKUP_CODE", pkgName + "LookupCode");
        name2Class.put("ACTIVITY_ATTRIBUTE_VALUE", pkgName + "AttributeValue");
        name2Class.put("FUNCTION", pkgName + "Function");
        int mDefCtr = 0;
        WFLoader.mHdr[mDefCtr++] = "# Oracle Workflow Process Definition";
        WFLoader.mHdr[mDefCtr++] = "# dbdrv: exec fnd bin WFLOAD bin &phase=daa+52 checkfile:~PROD:~PATH:~FILE \\";
        WFLoader.mHdr[mDefCtr++] = "# dbdrv: &ui_apps 0 Y UPGRADE @~PROD:~PATH/~FILE";
        WFLoader.mHdr[mDefCtr++] = "";
        mDefCtr = 0;
        WFLoader.mDefine[mDefCtr++] = "DEFINE ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "  KEY NAME VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE PROTECT_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE CUSTOM_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE WF_SELECTOR VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE READ_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE WRITE_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE EXECUTE_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE PERSISTENCE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE PERSISTENCE_DAYS NUMBER";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE ITEM_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "    KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE PROTECT_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "    BASE CUSTOM_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "    BASE TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE FORMAT VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE VALUE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE DEFAULT VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "  END ITEM_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "END ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "DEFINE LOOKUP_TYPE";
        WFLoader.mDefine[mDefCtr++] = "  KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE PROTECT_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE CUSTOM_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE ITEM_TYPE REFERENCES ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE LOOKUP_CODE";
        WFLoader.mDefine[mDefCtr++] = "    KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS MEANING VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  END LOOKUP_CODE";
        WFLoader.mDefine[mDefCtr++] = "END LOOKUP_TYPE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "DEFINE MESSAGE";
        WFLoader.mDefine[mDefCtr++] = "  KEY ITEM_TYPE REFERENCES ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "  KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE PROTECT_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE CUSTOM_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  TRANS SUBJECT VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS BODY VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS HTML_BODY VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "  BASE DEFAULT_PRIORITY NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE READ_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE WRITE_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE MESSAGE_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "    KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE SUBTYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE FORMAT VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE VALUE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE DEFAULT VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "    BASE ATTACH VARCHAR2(1)";
        WFLoader.mDefine[mDefCtr++] = "  END MESSAGE_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "END MESSAGE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "DEFINE ACTIVITY";
        WFLoader.mDefine[mDefCtr++] = "  KEY ITEM_TYPE REFERENCES ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "  KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "  TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE PROTECT_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE CUSTOM_LEVEL NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE FUNCTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE FUNCTION_TYPE VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE RESULT_TYPE VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE RERUN VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE COST NUMBER";
        WFLoader.mDefine[mDefCtr++] = "  BASE READ_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE WRITE_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE EXECUTE_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "  BASE ICON_NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE MESSAGE VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE ERROR_PROCESS VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE ERROR_ITEM_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE EXPAND_ROLE VARCHAR2(1)";
        WFLoader.mDefine[mDefCtr++] = "  BASE RUNNABLE VARCHAR2(1)";
        WFLoader.mDefine[mDefCtr++] = "  BASE EVENT_FILTER VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE EVENT_TYPE VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE ACTIVITY_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "    KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DISPLAY_NAME VARCHAR2(80)";
        WFLoader.mDefine[mDefCtr++] = "    TRANS DESCRIPTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE FORMAT VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE VALUE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE DEFAULT VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "  END ACTIVITY_ATTRIBUTE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE PROCESS_ACTIVITY";
        WFLoader.mDefine[mDefCtr++] = "    KEY LABEL VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    BASE ACTIVITY_ITEM_TYPE REFERENCES ITEM_TYPE";
        WFLoader.mDefine[mDefCtr++] = "    BASE ACTIVITY_NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    BASE START_END VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE DEFAULT_RESULT VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "    BASE ICON_GEOMETRY VARCHAR2(2000)";
        WFLoader.mDefine[mDefCtr++] = "    BASE VALUE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE PERFORM_ROLE REFERENCES ROLE";
        WFLoader.mDefine[mDefCtr++] = "    BASE USER_COMMENT VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "    DEFINE ACTIVITY_ATTRIBUTE_VALUE";
        WFLoader.mDefine[mDefCtr++] = "      KEY NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "      BASE VALUE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "      BASE VALUE VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "    END ACTIVITY_ATTRIBUTE_VALUE";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "    DEFINE ACTIVITY_TRANSITION";
        WFLoader.mDefine[mDefCtr++] = "      KEY RESULT VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "      KEY TO REFERENCES PROCESS_ACTIVITY";
        WFLoader.mDefine[mDefCtr++] = "      BASE ARROW_GEOMETRY VARCHAR2(2000)";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "      DEFINE TRANSITION_MAPPING";
        WFLoader.mDefine[mDefCtr++] = "        BASE SOURCE_NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "        BASE SOURCE_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "        BASE TARGET_NAME VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "        BASE TARGET_TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "        BASE TYPE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "        BASE VALUE VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "      END TRANSITION_MAPPING";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "    END ACTIVITY_TRANSITION";
        WFLoader.mDefine[mDefCtr++] = "  END PROCESS_ACTIVITY";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "  DEFINE FUNCTION";
        WFLoader.mDefine[mDefCtr++] = "    KEY FUNCTION_MODE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "    BASE FUNCTION VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "    BASE DESCRIPTOR VARCHAR2(4000)";
        WFLoader.mDefine[mDefCtr++] = "  END FUNCTION";
        WFLoader.mDefine[mDefCtr++] = "END ACTIVITY";
        WFLoader.mDefine[mDefCtr++] = "";
        WFLoader.mDefine[mDefCtr++] = "DEFINE ROLE";
        WFLoader.mDefine[mDefCtr++] = "  KEY NAME VARCHAR2(320)";
        WFLoader.mDefine[mDefCtr++] = "  BASE DISPLAY_NAME VARCHAR2(360)";
        WFLoader.mDefine[mDefCtr++] = "  BASE DESCRIPTION VARCHAR2(1000)";
        WFLoader.mDefine[mDefCtr++] = "  BASE NOTIFICATION_PREFERENCE VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE LANGUAGE VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE TERRITORY VARCHAR2(30)";
        WFLoader.mDefine[mDefCtr++] = "  BASE EMAIL_ADDRESS VARCHAR2(320)";
        WFLoader.mDefine[mDefCtr++] = "  BASE FAX VARCHAR2(240)";
        WFLoader.mDefine[mDefCtr++] = "  BASE STATUS VARCHAR2(8)";
        WFLoader.mDefine[mDefCtr++] = "  BASE EXPIRATION_DATE DATE";
        WFLoader.mDefine[mDefCtr++] = "END ROLE";
        WFLoader.mDefine[mDefCtr++] = "";
    }
}

