/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.Process;
import oracle.apps.fnd.wf.design.ProcessActivity;
import oracle.apps.fnd.wf.design.VerificationError;

public class Transition
extends DesignBaseComponent {
    public static final String ANY_RESULT = "#ANY";
    public static final String DEFAULT_RESULT = "*";
    private ProcessActivity mToNode;
    private String mToNodeName;
    private String mToNodeId;
    private String mActivityResultCode;
    private String mGeometry;

    public String getToNodeName() {
        return this.mToNodeName;
    }

    public void setToNodeName(String pToNodeName) {
        this.mToNodeName = pToNodeName;
    }

    public String getGeometry() {
        return this.mGeometry;
    }

    public void setGeometry(String pGeometry) {
        this.mGeometry = pGeometry;
    }

    public String getActivityResultCode() {
        return this.mActivityResultCode;
    }

    public void setActivityResultCode(String pActivityResultCode) {
        this.mActivityResultCode = pActivityResultCode;
    }

    public boolean isDefaultTransition() {
        return DEFAULT_RESULT.equals(this.mActivityResultCode);
    }

    public boolean isAnyTransition() {
        return ANY_RESULT.equalsIgnoreCase(this.mActivityResultCode);
    }

    public ProcessActivity getToNode() {
        Process process = ((ProcessActivity)this.getParent()).getProcess();
        if (this.mToNodeId != null) {
            return process.getProcessActivityById(this.mToNodeId);
        }
        if (this.mToNodeName != null) {
            return process.getProcessActivityByLabel(this.mToNodeName);
        }
        return null;
    }

    public void setToNodeId(String pToNodeId) {
        this.mToNodeId = pToNodeId;
    }

    public String getToNodeId() {
        return this.mToNodeId;
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (this.mToNodeId == null || this.mToNodeId.length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_NEXT_NODE_NOTFOUND", this.getFullName(), pStopOnFailure);
        }
        if (this.mGeometry == null || this.mGeometry.length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_ATTRIBUTE_REQUIRED", "geometry", pStopOnFailure);
        }
    }
}

