/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.apps.fnd.wf.common.Correlation;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.AttributeValue;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.DesignStore;
import oracle.apps.fnd.wf.design.ItemType;
import oracle.apps.fnd.wf.design.Notification;
import oracle.apps.fnd.wf.design.Process;
import oracle.apps.fnd.wf.design.Transition;
import oracle.apps.fnd.wf.design.VerificationError;
import oracle.apps.fnd.wf.design.Version;

public class ProcessActivity
extends DesignBaseComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/ProcessActivity.java,v 30.9 2005/01/15 00:49:21 anpwang noship $";
    private long mInstanceID = 0L;
    private String mInstanceLabel;
    private String mDefaultResult;
    private String mIconName;
    private String mIconGeometry;
    private Activity mActivity;
    private String mNodeType;
    private String mTimeOutType;
    private String mTimeOutValue;
    private String mPriorityType;
    private String mPriorityValue;
    private ArrayList mActivities = new ArrayList();
    private String mActivityItemType;
    private String mActivityName;
    private String mPerformerNameType = "CONSTANT";
    private String mPerformerName;
    private transient String mActivityType;

    public ProcessActivity() {
    }

    public ProcessActivity(String id) {
        super(id);
    }

    public ProcessActivity(Activity activity) {
        this.mActivity = activity;
        this.mActivities.add(this.mActivity);
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public void setName(String pActivityName) {
        this.setId(pActivityName);
    }

    public Activity getActivity() {
        if (this.mActivity == null) {
            this.mActivity = this.getActivity(Version.currentVersion());
            if (this.mActivity == null) {
                throw new IllegalStateException("Activity.NotDefined[" + this.getName() + ":" + this.mActivityType + "]");
            }
        }
        return this.mActivity;
    }

    private void setActivity(Activity pActivity) {
        this.mActivity = pActivity;
    }

    public String getNodeType() {
        return this.mNodeType;
    }

    public void setNodeType(String pNodeType) {
        this.mNodeType = pNodeType;
    }

    public String getDefaultResult() {
        return this.mDefaultResult;
    }

    public void setDefaultResult(String pDefaultResult) {
        this.mDefaultResult = pDefaultResult;
    }

    public String getComment() {
        return this.getDescription();
    }

    public void setComment(String pComment) {
        this.setDescription(pComment);
    }

    public String getTimeOutType() {
        return this.mTimeOutType;
    }

    public void setTimeOutType(String pTimeOutType) {
        this.mTimeOutType = pTimeOutType;
    }

    public String getTimeOutValue() {
        return this.mTimeOutValue;
    }

    public void setTimeOutValue(String pTimeOutValue) {
        this.mTimeOutValue = pTimeOutValue;
    }

    public String getPriorityType() {
        return this.mPriorityType;
    }

    public void setPriorityType(String pPriorityType) {
        this.mPriorityType = pPriorityType;
    }

    public String getPriorityValue() {
        return this.mPriorityValue;
    }

    public void setPriorityValue(String pPriorityValue) {
        this.mPriorityValue = pPriorityValue;
    }

    public String getItemType() {
        return this.mActivityItemType;
    }

    public void setItemType(String pItemType) {
        this.mActivityItemType = pItemType;
    }

    public String getIconName() {
        if ((this.mIconName == null || "".equals(this.mIconName)) && this.mActivity != null) {
            this.mIconName = this.mActivity.getIconName();
        }
        return this.mIconName;
    }

    public void setIconName(String pIconName) {
        this.mIconName = pIconName;
    }

    public String getPerformerName() {
        return this.mPerformerName;
    }

    public void setPerformerName(String pPerformerName) {
        this.mPerformerName = pPerformerName;
    }

    public String getIconGeometry() {
        return this.mIconGeometry;
    }

    public void setIconGeometry(String pIconGeometry) {
        this.mIconGeometry = pIconGeometry;
    }

    public Object clone() {
        ProcessActivity newNode = new ProcessActivity(this.mActivity);
        newNode.setName(this.mActivity.getName() + " ");
        this.getParent().addChild(newNode);
        return newNode;
    }

    @Override
    public void resolveReference(Version pVersion) {
        this.getActivity(pVersion);
        super.resolveReference(pVersion);
    }

    private Activity getActivityFromList(Version pVersion) {
        for (Activity act : this.mActivities) {
            if (act.getVersion() == pVersion) {
                return act;
            }
            if (pVersion != null && pVersion.equals(act.getVersion())) {
                return act;
            }
            if (!act.getVersion().equals(pVersion)) continue;
            return act;
        }
        return null;
    }

    private Activity getActivity(Calendar pDate) {
        if (this.mActivity == null) {
            this.getActivity(Version.currentVersion());
        }
        for (Activity act : this.mActivities) {
            if (act.getBeginDate() != null && !act.getBeginDate().before(pDate) || act.getEndDate() != null && !act.getEndDate().after(pDate)) continue;
            return act;
        }
        return null;
    }

    public Activity getActivityByDate(Calendar pDate) {
        Activity activity = this.getActivity(pDate);
        if (activity == null) {
            Process myProcess = (Process)this.getParent();
            ItemType myItemType = (ItemType)myProcess.getParent();
            if (!myItemType.getName().equals(this.mActivityItemType)) {
                DesignStore myStore = (DesignStore)myItemType.getParent();
                myItemType = myStore.getItemType(this.mActivityItemType);
            }
            if (myItemType == null) {
                Map map = this.getErrorTokens();
                map.put("ITEM_TYPE", this.mActivityItemType);
                throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", map);
            }
            try {
                activity = myItemType.getActivity(this.getActivityName(), pDate);
                if (activity != null) {
                    this.mActivities.add(activity);
                }
            }
            catch (WorkflowException e) {
                throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
            }
        }
        return activity;
    }

    public Activity getActivity(Version pVersion) {
        Activity activity = this.getActivityFromList(pVersion);
        if (activity != null) {
            return activity;
        }
        if (this.mActivityItemType == null) {
            throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", this.getErrorTokens());
        }
        Process myProcess = (Process)this.getParent();
        if (myProcess == null) {
            throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", this.getErrorTokens());
        }
        ItemType myItemType = (ItemType)myProcess.getParent();
        if (!myItemType.getName().equals(this.mActivityItemType)) {
            DesignStore myStore = (DesignStore)myItemType.getParent();
            myItemType = myStore.getItemType(this.mActivityItemType);
        }
        if (myItemType == null) {
            throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", this.getErrorTokens());
        }
        activity = "FUNCTION" == this.mActivityType || "FUNCTION".equals(this.mActivityType) ? myItemType.getFunctionActivity(this.mActivityName, pVersion) : ("PROCESS" == this.mActivityType || "PROCESS".equals(this.mActivityType) ? myItemType.getProcess(this.mActivityName) : ("EVENT" == this.mActivityType || "EVENT".equals(this.mActivityType) ? myItemType.getEventActivity(this.mActivityName, pVersion) : ("NOTICE" == this.mActivityType || "NOTICE".equals(this.mActivityType) ? myItemType.getNotification(this.mActivityName, pVersion) : myItemType.getActivity(this.mActivityName, pVersion))));
        if (activity != null) {
            if (pVersion == null || pVersion.isLatestVersion()) {
                this.mActivity = activity;
            }
            this.mActivities.add(activity);
        }
        return activity;
    }

    public Iterator getInboundTransitions() {
        Iterator iter = this.getParent().getChildrenByType(this.getClass()).iterator();
        Vector<Transition> v = new Vector<Transition>();
        while (iter.hasNext()) {
            ProcessActivity child = (ProcessActivity)iter.next();
            Iterator iter1 = child.getTransitions();
            while (iter1.hasNext()) {
                Transition transition = (Transition)iter1.next();
                if (transition.getToNode() != this) continue;
                v.add(transition);
            }
        }
        return v.iterator();
    }

    public Iterator getTransitions() {
        return this.getChildrenByType(Transition.class).iterator();
    }

    public boolean isAStartNode(Correlation correlation) {
        if (this.mNodeType == null || !this.mNodeType.equalsIgnoreCase("START")) {
            return false;
        }
        return correlation == null ? true : correlation.isRelatedTo(this);
    }

    public boolean isEndNode() {
        return this.mNodeType == null ? false : this.mNodeType.equalsIgnoreCase("END");
    }

    public Process getProcess() {
        return (Process)this.getParent();
    }

    public void setActivityName(String pActivityName) {
        this.mActivityName = pActivityName;
    }

    public String getActivityName() {
        return this.mActivityName;
    }

    public AttributeValue getAttributeValue(String pAttribute) {
        Iterator iter = this.getAttributeValues();
        while (iter.hasNext()) {
            AttributeValue av = (AttributeValue)iter.next();
            if (!av.getName().equals(pAttribute)) continue;
            return av;
        }
        return null;
    }

    public Iterator getAttributeValues() {
        return this.getChildrenByType(AttributeValue.class).iterator();
    }

    public long getInstanceId() {
        return this.mInstanceID;
    }

    public void setInstanceId(long pInstanceID) {
        this.mInstanceID = pInstanceID;
    }

    public void setActivityType(String activityType) {
        this.mActivityType = activityType;
    }

    public void setPerformerNameType(String pPerformerNameType) {
        this.mPerformerNameType = pPerformerNameType;
    }

    public String getPerformerNameType() {
        return this.mPerformerNameType;
    }

    public void setInstanceLabel(String pInstanceLabel) {
        this.mInstanceLabel = pInstanceLabel;
    }

    public String getInstanceLabel() {
        return this.mInstanceLabel == null ? this.getId() : this.mInstanceLabel;
    }

    @Override
    public String getDisplayName() {
        return this.getDescription();
    }

    @Override
    public void setDisplayName(String pDispName) {
        this.setDescription(pDispName);
    }

    @Override
    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        this.getChildrenByType(Transition.class);
        this.getChildrenByType(AttributeValue.class);
        super.loadChildren(pCtx);
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (this.getInstanceLabel().length() > 30) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_LENGTH_ERROR", this.getFullName(), pStopOnFailure);
        }
        if (this.isEndNode() && this.getTransitions().hasNext()) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_LENGTH_ERROR", this.getFullName(), pStopOnFailure);
        }
        if (this.getTransitions().hasNext()) {
            // empty if block
        }
        if (!this.getInboundTransitions().hasNext() && !this.isAStartNode(null)) {
            VerificationError.createVerificationError(pCtx, this, "WF_ILLEGAL_STATUS_ACCESS", "Not a start, yet no inbound transitions", pStopOnFailure);
        }
        if (this.getActivity() instanceof Notification && (this.getPerformerName() == null || this.getPerformerName().length() == 0)) {
            VerificationError.createVerificationError(pCtx, this, "WF_PERFORMER_REQUIRED", this.getFullName(), pStopOnFailure);
        }
    }

    @Override
    public String toString() {
        if (this.mInstanceLabel == null || this.mInstanceLabel.length() == 0) {
            return this.getName();
        }
        return this.mInstanceLabel;
    }
}

