/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.apps.fnd.wf.common.BaseComponent;
import oracle.apps.fnd.wf.common.Predicate;
import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.Activity;
import oracle.apps.fnd.wf.design.Attribute;
import oracle.apps.fnd.wf.design.DesignBaseAttributeComponent;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.DesignStore;
import oracle.apps.fnd.wf.design.EventActivity;
import oracle.apps.fnd.wf.design.Function;
import oracle.apps.fnd.wf.design.FunctionActivity;
import oracle.apps.fnd.wf.design.ItemAttribute;
import oracle.apps.fnd.wf.design.Message;
import oracle.apps.fnd.wf.design.Notification;
import oracle.apps.fnd.wf.design.Process;
import oracle.apps.fnd.wf.design.VerificationError;
import oracle.apps.fnd.wf.design.Version;

public class ItemType
extends DesignBaseAttributeComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/ItemType.java,v 30.7 2005/01/15 00:36:00 anpwang noship $";
    private Function mSelector;
    private String mPersistenceType;
    private int mPersistenceDuration;
    private boolean mLoaded = false;
    private String mReadRoleName;
    private String mWriteRoleName;
    private String mExecuteRoleName;
    private String mGeneratedName;
    public static final String PTYPE_PERM = "PERM";
    public static final String PTYPE_TEMP = "TEMP";

    public ItemType() {
    }

    public ItemType(String id) {
        super(id);
    }

    public List getFunctions() {
        return this.getChildrenByType(Function.class);
    }

    public Attribute getAttribute(String attrName) {
        return (ItemAttribute)this.getChildByTypeAndName(ItemAttribute.class, attrName);
    }

    public Function getSelector() {
        return this.mSelector;
    }

    public void setSelector(Function pSelector) {
        this.mSelector = pSelector;
        this.addChild(this.mSelector);
    }

    @Override
    public void addChild(BaseComponent pChild) {
        if (pChild instanceof Activity) {
            for (BaseComponent base : this.getChildren()) {
                if (!(base instanceof Activity) || !base.getId().equals(pChild.getId())) continue;
                throw new WorkflowRuntimeException(this.getWorkflowContext(), this, "WF_DESIGN_ENTITY_ERROR");
            }
        }
        super.addChild(pChild);
    }

    public String getPersistenceType() {
        return this.mPersistenceType;
    }

    public void setPersistenceType(String pPersistenceType) {
        if (pPersistenceType != null && (PTYPE_PERM.equals(pPersistenceType) || PTYPE_TEMP.equals(pPersistenceType))) {
            this.mPersistenceType = pPersistenceType;
        }
    }

    public int getPersistenceDuration() {
        return this.mPersistenceDuration;
    }

    public void setPersistenceDuration(int pPersistenceDays) {
        this.mPersistenceDuration = pPersistenceDays;
    }

    private boolean isLoaded() {
        return this.mLoaded;
    }

    private void setLoaded(boolean pLoaded) {
        this.mLoaded = pLoaded;
    }

    public String getReadRole() {
        return this.mReadRoleName;
    }

    public void setReadRoleName(String pReadRoleName) {
        this.mReadRoleName = pReadRoleName;
    }

    public String getWriteRole() {
        return this.mWriteRoleName;
    }

    public void setWriteRoleName(String pWriteRoleName) {
        this.mWriteRoleName = pWriteRoleName;
    }

    public String getExecuteRole() {
        return this.mExecuteRoleName;
    }

    public void setExecuteRoleName(String pExecuteRoleName) {
        this.mExecuteRoleName = pExecuteRoleName;
    }

    private Activity getActivity(Class pType, String pName, Version pVersion) {
        if (pType == null) {
            pType = Activity.class;
        }
        return (Activity)this.getChildOnDemand(pType, pName);
    }

    public Activity getActivity(String pName, Calendar pDate) throws WorkflowException {
        WorkflowContext ctx = ((DesignStore)this.getStore()).getContext();
        if (pDate == null) {
            throw new WorkflowException(ctx, this, "WF_FIELD_REQUIRED", this.getErrorTokens());
        }
        Activity activity = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String dateStr = format.format(pDate.getTime());
        String filter = " ITEM_TYPE='" + this.getName() + "'" + " AND NAME ='" + pName + "'" + " AND BEGIN_DATE < :1" + " AND ((END_DATE is NULL) OR (END_DATE > :2))";
        DatePredicate predicate = new DatePredicate(filter);
        predicate.setDate(pDate);
        List list = this.getStore().getLoader().find(ctx, Activity.class, predicate);
        if (list.isEmpty() || list.size() > 1) {
            Map map = this.getErrorTokens();
            map.put("PREDICATE", predicate.toString());
            map.put("DATE", pDate.getTime());
            map.put("CARDINALITY", "" + list.size());
            throw new WorkflowException(ctx, this, "WF_ACTIVITY_DESIGN_ERROR", map);
        }
        activity = (Activity)list.get(0);
        return activity;
    }

    public Notification getNotification(String pNotificationName, Version pVersion) {
        Activity activity = this.getActivity(Notification.class, pNotificationName, pVersion);
        if (activity instanceof Notification) {
            return (Notification)activity;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VERSION", pVersion);
        map.put("NAME", pNotificationName);
        throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", map);
    }

    public EventActivity getEventActivity(String pEventName, Version pVersion) {
        Activity activity = this.getActivity(EventActivity.class, pEventName, pVersion);
        if (activity instanceof EventActivity) {
            return (EventActivity)activity;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VERSION", pVersion);
        map.put("NAME", pEventName);
        throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", map);
    }

    public FunctionActivity getFunctionActivity(String pActivityName, Version pVersion) {
        Activity activity = this.getActivity(FunctionActivity.class, pActivityName, pVersion);
        if (activity instanceof FunctionActivity) {
            return (FunctionActivity)activity;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VERSION", pVersion);
        map.put("NAME", pActivityName);
        throw new WorkflowRuntimeException(this.getWorkflowContext(), (Object)this, "WF_DESIGN_ENTITY_ERROR", map);
    }

    public Activity getActivity(String pActivityName, Version pVersion) {
        return this.getActivity(Activity.class, pActivityName, pVersion);
    }

    public List getProcesses() {
        try {
            return this.getChildrenByType(Process.class);
        }
        catch (WorkflowRuntimeException e) {
            throw new WorkflowRuntimeException(this, "Loading.Processes.Failed[" + this.getName() + "]", e.getRootException());
        }
    }

    public Process getProcess(String pProcessName) {
        try {
            return (Process)this.getChildOnDemand(Process.class, pProcessName);
        }
        catch (WorkflowRuntimeException e) {
            throw new WorkflowRuntimeException(this, "Process.NotFound[" + pProcessName + "]", e.getRootException());
        }
    }

    public Message getMessage(String pMessageName) {
        return (Message)this.getChildOnDemand(Message.class, pMessageName);
    }

    public List getAttributes() {
        try {
            return this.getChildrenByType(ItemAttribute.class);
        }
        catch (WorkflowRuntimeException e) {
            throw new WorkflowRuntimeException(this, "WF_LOAD_ATTRIBUTES_FAILED", e.getRootException());
        }
    }

    public void setGeneratedName(String pGeneratedName) {
        this.mGeneratedName = pGeneratedName;
    }

    public String getGeneratedName() {
        if (this.mGeneratedName != null) {
            return this.mGeneratedName;
        }
        return this.getName();
    }

    @Override
    public Store getStore() {
        return super.getStore();
    }

    @Override
    public void changeStore(Store store) {
        super.changeStore(store);
    }

    @Override
    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        this.getChildrenByType(ItemAttribute.class);
        this.getChildrenByType(EventActivity.class);
        this.getChildrenByType(Message.class);
        this.getChildrenByType(Notification.class);
        this.getChildrenByType(FunctionActivity.class);
        this.getChildrenByType(Process.class);
        super.loadChildren(pCtx);
    }

    @Override
    public void saveChildren(WorkflowContext pCtx) throws WorkflowException {
        List list = this.getChildrenByType(ItemAttribute.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
        }
        list = this.getChildrenByType(Message.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
            element.saveChildren(pCtx);
        }
        list = this.getChildrenByType(FunctionActivity.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
            element.saveChildren(pCtx);
        }
        list = this.getChildrenByType(EventActivity.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
            element.saveChildren(pCtx);
        }
        list = this.getChildrenByType(Notification.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
            element.saveChildren(pCtx);
        }
        list = this.getChildrenByType(Process.class);
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
            element.saveChildren(pCtx);
        }
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        String name = this.getName();
        if (this.getDisplayName() == null || this.getDisplayName().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "displayName", pStopOnFailure);
        }
        if (name.length() > 80) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_LENGTH_ERROR", "itemName < 80", pStopOnFailure);
        }
        if (!name.equals(name.toUpperCase())) {
            System.err.println(name + '=' + name.toUpperCase());
            VerificationError.createVerificationError(pCtx, this, "WF_ILLEGAL_NAMING_ERROR", "internalName : " + name, pStopOnFailure);
        }
    }

    public static class DatePredicate
    implements Predicate {
        String mFilter;
        Calendar mDate;

        public DatePredicate(String filter) {
            this.mFilter = filter;
        }

        public void setDate(Calendar pDate) {
            if (pDate != null) {
                this.mDate = (Calendar)pDate.clone();
            }
        }

        public String toString() {
            return this.mFilter;
        }

        @Override
        public void bind(Object pStatement) throws WorkflowException {
            if (pStatement instanceof PreparedStatement) {
                try {
                    ((PreparedStatement)pStatement).setTimestamp(1, new Timestamp(this.mDate.getTime().getTime()));
                    ((PreparedStatement)pStatement).setTimestamp(2, new Timestamp(this.mDate.getTime().getTime()));
                }
                catch (SQLException e) {
                    throw new WorkflowException(this, e.getLocalizedMessage());
                }
            }
        }
    }
}

