/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.DesignBaseAttributeComponent;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.VerificationError;
import oracle.apps.fnd.wf.design.Version;

public class Function
extends DesignBaseComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/Function.java,v 30.6 2005/01/15 00:34:50 anpwang noship $";
    private String mFunctionName;
    private String mFunctionMode = "RUN";
    private String mDescriptor;
    private String mFunctionType = "PL/SQL";
    private String mClassName;
    public static final String RUN_MODE = "RUN";
    public static final String CANCEL_MODE = "CANCEL";
    public static final String POST_NOTIFY_MODE = "POST_NOTIFY_MODE";
    public static final String TIMEOUT_MODE = "TIMEOUT";
    public static final String PLSQL_TYPE = "PL/SQL";
    public static final String EXTJAVA_TYPE = "EXTJAVA";
    public static final String EXTERNAL_TYPE = "EXTERNAL";
    public static final String ANY_PLSQL_TYPE = "PLSQL";
    public static final String SOAP_TYPE = "SOAP";
    public static final String JAVA_TYPE = "JAVA";
    public static final String ADFM_TYPE = "ADFM";
    public static final String EJB_TYPE = "EJB";

    public Function() {
    }

    public Function(String id) {
        super(id);
    }

    public String getFunctionMode() {
        return this.mFunctionMode;
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public void setDescriptor(String pDescriptor) {
        this.mDescriptor = pDescriptor;
    }

    public String getFunctionName() {
        return this.mFunctionName;
    }

    public void setFunctionName(String pFunction) {
        this.mFunctionName = pFunction;
    }

    public String getFunctionType() {
        return this.mFunctionType;
    }

    public void setFunctionType(String pFunctionType) {
        if (!(pFunctionType != null && (pFunctionType.equals(PLSQL_TYPE) || pFunctionType.equals(EXTERNAL_TYPE) || pFunctionType.equals(EXTJAVA_TYPE) || pFunctionType.equals(SOAP_TYPE) || pFunctionType.equals(JAVA_TYPE) || pFunctionType.equals(ANY_PLSQL_TYPE) || pFunctionType.equals(ADFM_TYPE) || pFunctionType.equals(EJB_TYPE)))) {
            throw new IllegalArgumentException("Function.Type.NotSupported[" + pFunctionType + "]");
        }
        this.mFunctionType = pFunctionType;
    }

    public DesignBaseAttributeComponent getActivity() {
        return (DesignBaseAttributeComponent)this.getParent();
    }

    @Override
    public void setName(String pFunctionMode) {
        this.mFunctionMode = pFunctionMode;
        super.setName(pFunctionMode);
    }

    @Override
    public void resolveReference(Version pVersion) {
        String fMode = this.getName();
        this.mFunctionMode = fMode != null && (fMode.equals(RUN_MODE) || fMode.equals(CANCEL_MODE) || fMode.equals(TIMEOUT_MODE)) ? fMode : RUN_MODE;
        super.resolveReference(pVersion);
    }

    public void setClassName(String pClassName) {
        this.mClassName = pClassName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (this.getFunctionName() == null || this.getFunctionName().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "functionName", pStopOnFailure);
        }
        if (!JAVA_TYPE.equals(this.getFunctionType()) || this.getClassName() == null) {
            // empty if block
        }
    }
}

