/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import java.util.List;
import java.util.Vector;
import oracle.apps.fnd.wf.common.BaseComponent;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.common.WorkflowRuntimeException;
import oracle.apps.fnd.wf.design.AccessController;
import oracle.apps.fnd.wf.design.DesignStore;
import oracle.apps.fnd.wf.design.VerificationError;
import oracle.apps.fnd.wf.design.Version;

public class DesignBaseComponent
extends BaseComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/DesignBaseComponent.java,v 30.11 2005/01/15 00:26:34 anpwang noship $";
    protected boolean mResolved = false;
    private Version mVersion = Version.currentVersion();
    private String mDispName;
    private String mDesc;
    private AccessController mAccessController;
    Vector childrenTypeLoaded = new Vector(2);

    public DesignBaseComponent(String id) {
        super(id);
        this.mAccessController = new AccessController();
    }

    public DesignBaseComponent() {
        this.mAccessController = new AccessController();
    }

    public String getDisplayName() {
        return this.mDispName;
    }

    public void setDisplayName(String pDispName) {
        this.mDispName = pDispName;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public void setDescription(String pDescription) {
        this.mDesc = pDescription;
    }

    public void setResolved(boolean pResolved) {
        this.mResolved = pResolved;
    }

    public void resolveReference(Version pVersion) {
        for (BaseComponent bc : this.getChildren()) {
            if (!(bc instanceof DesignBaseComponent)) continue;
            ((DesignBaseComponent)bc).resolveReference(pVersion);
        }
    }

    @Override
    public String toString() {
        return this.mDispName == null ? this.getName() : this.mDispName;
    }

    public void assign(BaseComponent pComponent) {
        if (pComponent instanceof DesignBaseComponent) {
            DesignBaseComponent cmp = (DesignBaseComponent)pComponent;
            this.mAccessController.assign(cmp.mAccessController);
            this.mDispName = cmp.mDispName;
            this.mDesc = cmp.mDesc;
        }
    }

    public AccessController getAccessController() {
        return this.mAccessController;
    }

    public void setName(String pName) {
        this.setId(pName);
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public void setVersion(Version pVersion) {
        this.mVersion = pVersion;
    }

    synchronized BaseComponent getChildOnDemand(Class pType, String pName) {
        BaseComponent currentObject = super.getChildByTypeAndName(pType, pName);
        WorkflowContext ctx = ((DesignStore)this.getStore()).getContext();
        try {
            if (currentObject == null && this.getStore() != null) {
                currentObject = this.getStore().getLoader().loadChild(ctx, this, pType, pName);
            } else {
                this.getStore().getLoader().synch(ctx, currentObject);
            }
        }
        catch (WorkflowException e) {
            throw new WorkflowRuntimeException(ctx, (Object)this, "WF_DESIGN_ENTITY_ERROR", e);
        }
        return currentObject;
    }

    @Override
    public synchronized List getChildrenByType(Class pType) {
        List list = super.getChildrenByType(pType);
        if (this.getStore() == null) {
            return list;
        }
        try {
            if (this.childrenTypeLoaded.indexOf(pType) > -1) {
                return list;
            }
            List loadedList = this.getStore().getLoader().loadChildren(this.getWorkflowContext(), this, pType);
            if (loadedList.size() != 0) {
                list = loadedList;
            }
            this.childrenTypeLoaded.add(pType);
        }
        catch (WorkflowException e) {
            throw new WorkflowRuntimeException(this, "Loading.Failed[" + pType.getName() + "]", e.getRootException());
        }
        return list;
    }

    public void saveChildren(WorkflowContext pCtx) throws WorkflowException {
        List list = this.getChildren();
        for (DesignBaseComponent element : list) {
            element.save(pCtx);
        }
        for (DesignBaseComponent element : list) {
            element.saveChildren(pCtx);
        }
    }

    public void loadChildren(WorkflowContext pCtx) throws WorkflowException {
        List list = this.getChildren();
        for (DesignBaseComponent element : list) {
            element.loadChildren(pCtx);
        }
    }

    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        String name = this.getName();
        if (name == null) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "internalName", pStopOnFailure);
        }
        this.verifyChildren(pCtx, pStopOnFailure);
    }

    protected void verifyChildren(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        List list = this.getChildren();
        for (DesignBaseComponent element : list) {
            element.verify(pCtx, pStopOnFailure);
        }
    }

    public WorkflowContext getWorkflowContext() {
        return ((DesignStore)this.getStore()).getContext();
    }
}

