/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.design;

import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;
import oracle.apps.fnd.wf.design.AttributeValue;
import oracle.apps.fnd.wf.design.DesignBaseComponent;
import oracle.apps.fnd.wf.design.VerificationError;

public class Attribute
extends DesignBaseComponent {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/design/RCS/Attribute.java,v 30.7 2005/01/15 00:26:32 anpwang noship $";
    private String mType;
    private Object mDefaultValue;
    private String mFormat;
    private String mSubType = "SEND";
    private String mValueType;
    private String mNativeType = "java.lang.String";
    private boolean mAttach = false;
    private int mSequence = 0;
    public static final String ATTRTYPE_TEXT = "VARCHAR2";
    public static final String ATTRTYPE_NUMBER = "NUMBER";
    public static final String ATTRTYPE_DATE = "DATE";
    public static final String ATTRTYPE_OBJECT = "OBJECT";
    public static final String ATTRTYPE_LOOKUP = "LOOKUP";
    public static final String ATTRTYPE_FORM = "FORM";
    public static final String ATTRTYPE_URL = "URL";
    public static final String ATTRTYPE_DOCUMENT = "DOCUMENT";
    public static final String ATTRTYPE_ROLE = "ROLE";
    public static final String ATTRTYPE_ATTRIBUTE = "ITEMATTR";
    public static final String ATTRTYPE_EVENT = "EVENT";
    public static final String ATTRVTYPE_NOTSET = "NOTSET";
    public static final String ATTRVTYPE_CONSTANT = "CONSTANT";
    public static final String ATTRVTYPE_ITEMATTR = "ITEMATTR";
    public static final String ATTRVTYPE_DEFER = "DEFER";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    public Attribute(String id) {
        super(id);
    }

    public Attribute() {
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String pAttributeType) {
        this.mType = pAttributeType.equals(ATTRTYPE_OBJECT) ? ATTRTYPE_TEXT : pAttributeType;
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(Object pDefaultValue) {
        this.mDefaultValue = pDefaultValue;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String pFormat) {
        this.mFormat = pFormat;
    }

    public String getNativeType() {
        return this.mNativeType;
    }

    public void setNativeType(String pNativeType) {
        this.mNativeType = pNativeType;
    }

    public String getSubtype() {
        return this.mSubType;
    }

    public void setSubtype(String pSubtype) {
        this.mSubType = pSubtype;
    }

    public boolean isAttach() {
        return this.mAttach;
    }

    public void setAttach(boolean pAttach) {
        this.mAttach = pAttach;
    }

    public String getValueType() {
        return this.mValueType;
    }

    public void setValueType(String pValueType) {
        if (pValueType != null && (ATTRVTYPE_CONSTANT.equals(pValueType) || "ITEMATTR".equals(pValueType) || ATTRVTYPE_DEFER.equals(pValueType) || ATTRVTYPE_NOTSET.equals(pValueType))) {
            this.mValueType = pValueType;
        }
    }

    public AttributeValue getDefaultAttributeValue() {
        AttributeValue av = new AttributeValue(this.getName());
        av.setMetaType(this);
        av.setValueType(this.getValueType());
        if ("ITEMATTR".equals(av.getValueType())) {
            av.setItemName((String)this.getDefaultValue());
        } else {
            av.setValue(this.getDefaultValue());
        }
        return av;
    }

    public void setSequence(int mSequence) {
        this.mSequence = mSequence;
    }

    public int getSequence() {
        return this.mSequence;
    }

    @Override
    public void verify(WorkflowContext pCtx, boolean pStopOnFailure) throws WorkflowException {
        super.verify(pCtx, pStopOnFailure);
        if (this.getDisplayName() == null || this.getDisplayName().length() == 0) {
            VerificationError.createVerificationError(pCtx, this, "WF_FIELD_REQUIRED", "displayName", pStopOnFailure);
        }
    }
}

