/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.apps.fnd.wf.common.BaseComponent;
import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;

public class StoreManager {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/common/RCS/StoreManager.java,v 30.13 2004/12/14 00:40:12 anpwang noship $";
    private static StoreManager mStoreManager = new StoreManager();
    private Hashtable mStores = new Hashtable();

    private StoreManager() {
    }

    public static StoreManager getInstance() {
        return mStoreManager;
    }

    public String toString() {
        return this.getClass().getName() + " " + RCS_ID;
    }

    private Store createStore(WorkflowContext ctx, Class storeType, Object storeId) throws WorkflowException {
        try {
            Store newStore = (Store)storeType.newInstance();
            ((BaseComponent)((Object)newStore)).setId(storeId.toString());
            return newStore;
        }
        catch (InstantiationException e) {
            throw new WorkflowException(this, "InstantiationException[" + storeType + "]");
        }
        catch (IllegalAccessException e) {
            throw new WorkflowException(this, "IllegalAccessException[" + storeType + "]");
        }
    }

    public List getStores(Class pStoreType) throws WorkflowException {
        ArrayList list = new ArrayList();
        for (Object store : this.mStores.values()) {
            if (store.getClass() != pStoreType) continue;
            list.add(store);
        }
        return list;
    }

    public synchronized Store getStore(WorkflowContext pCtx, Class pStoreType, Object pStoreId) throws WorkflowException {
        if (pStoreId == null || pStoreType == null) {
            throw new WorkflowException(pCtx, this, "WF_ENGINE_INTERNAL_ERROR");
        }
        Store newStore = (Store)this.mStores.get(pStoreType.getName() + pStoreId);
        if (newStore == null) {
            newStore = this.createStore(pCtx, pStoreType, pStoreId);
            this.mStores.put(pStoreType.getName() + pStoreId, newStore);
        }
        return newStore;
    }
}

