/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.common;

import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.WorkflowContext;
import oracle.apps.fnd.wf.common.WorkflowException;

public class Element {
    public static final int ELEMENT_DB_LOADED = 0;
    public static final int ELEMENT_DB_SAVED = 1;
    public static final int ELEMENT_DB_SAVING = 7;
    public static final int ELEMENT_DB_LOADING = 6;
    public static final int ELEMENT_DB_NOT_INITIALIZED = 3;
    public static final int ELEMENT_DB_CREATING = 4;
    public static final int ELEMENT_DB_CREATED = 5;
    public static final int ELEMENT_DB_DIRTY = 8;
    public static final int ELEMENT_DB_ASSIGNED = 9;
    private Store mStore;
    private String mIdentification;
    protected int mDBState = 3;
    private int mInternalStatus = 3;
    transient boolean mSynchNeeded = false;

    protected Element() {
    }

    protected Element(String pId) {
        this.mIdentification = pId;
    }

    public String getId() {
        if (this.mIdentification == null) {
            return "";
        }
        return this.mIdentification;
    }

    protected void setId(String pId) {
        this.mIdentification = pId;
    }

    public void setStore(Store store) {
        this.mStore = store;
    }

    protected Store getStore() {
        return this.mStore;
    }

    public void load(WorkflowContext pCtx) throws WorkflowException {
        if (this.mInternalStatus == 7) {
            return;
        }
        int oldState = this.mDBState;
        try {
            this.mInternalStatus = 6;
            this.getStore().load(pCtx, this);
            this.mInternalStatus = 0;
            this.mDBState = 0;
        }
        catch (WorkflowException e) {
            this.mDBState = oldState;
            throw e;
        }
    }

    public void save(WorkflowContext pCtx) throws WorkflowException {
        if (this.mDBState == 0 || this.mDBState == 9 || this.mDBState == 1 || this.mDBState == 5) {
            int oldState = this.mDBState;
            try {
                this.mInternalStatus = 7;
                this.getStore().save(pCtx, this);
                this.mInternalStatus = 1;
                this.mDBState = 1;
            }
            catch (WorkflowException e) {
                this.mDBState = oldState;
                throw e;
            }
        } else {
            this.create(pCtx);
        }
    }

    protected void create(WorkflowContext pCtx) throws WorkflowException {
        if (this.mInternalStatus == 6) {
            return;
        }
        int oldState = this.mDBState;
        try {
            this.mInternalStatus = 4;
            this.getStore().create(pCtx, this);
            this.mInternalStatus = 5;
            this.mDBState = 5;
        }
        catch (WorkflowException e) {
            this.mDBState = oldState;
            throw e;
        }
    }

    public int getDBStatus() {
        return this.mDBState;
    }

    public void setDBStatus(int pDBState) {
        this.mDBState = pDBState;
    }

    public boolean isSynchNeeded() {
        return this.mSynchNeeded;
    }

    public void setSynchNeeded() {
        this.mSynchNeeded = true;
    }

    public String toString() {
        return this.getId();
    }
}

