/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.apps.fnd.wf.common.Element;
import oracle.apps.fnd.wf.common.Store;
import oracle.apps.fnd.wf.common.WorkflowContext;

public class BaseComponent
extends Element {
    private ArrayList mChildren;
    private BaseComponent mParent;

    protected BaseComponent() {
        super("" + System.currentTimeMillis());
    }

    protected BaseComponent(String pNewId) {
        super(pNewId);
    }

    protected String getComponentType() {
        return this.getClass().getName();
    }

    public BaseComponent getParent() {
        return this.mParent;
    }

    private synchronized void setParent(BaseComponent pParent) {
        this.mParent = pParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChild(BaseComponent pChild) {
        if (this.mChildren == null) {
            return;
        }
        ArrayList arrayList = this.mChildren;
        synchronized (arrayList) {
            this.mChildren.remove(pChild);
        }
        pChild.setParent(null);
    }

    protected synchronized void changeStore(Store store) {
        if (store != this.getStore()) {
            super.setStore(store);
        }
        for (BaseComponent bc : this.getChildren()) {
            bc.changeStore(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addChild(BaseComponent pChild) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        if (pChild.mParent != null) {
            pChild.mParent.removeChild(pChild);
        }
        if (this.mChildren.contains(pChild)) {
            return;
        }
        ArrayList arrayList = this.mChildren;
        synchronized (arrayList) {
            this.mChildren.add(pChild);
        }
        pChild.setParent(this);
        if (this instanceof Store) {
            pChild.setStore((Store)((Object)this));
        } else {
            pChild.setStore(this.getStore());
        }
    }

    public synchronized List getChildren() {
        if (this.mChildren == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mChildren;
    }

    public synchronized List getChildrenByType(Class pType) {
        Vector<BaseComponent> list = new Vector<BaseComponent>();
        for (BaseComponent bc : this.getChildren()) {
            if (!pType.isInstance(bc)) continue;
            list.addElement(bc);
        }
        return list;
    }

    public synchronized BaseComponent getChildByTypeAndName(Class pType, String pName) {
        if (pName == null || pName.length() == 0) {
            throw new IllegalArgumentException("BaseComponent.getChildByTypeAndName.Name.Required");
        }
        for (BaseComponent bc : this.getChildren()) {
            if (!pType.isInstance(bc) || !pName.equals(bc.getName())) continue;
            return bc;
        }
        return null;
    }

    public synchronized List getChildrenByName(String pName) {
        if (pName == null || pName.length() == 0) {
            throw new IllegalArgumentException("BaseComponent.getChildByTypeAndName.Name.Required");
        }
        Iterator c = this.getChildren().iterator();
        Vector<BaseComponent> v = new Vector<BaseComponent>();
        while (c.hasNext()) {
            BaseComponent child = (BaseComponent)c.next();
            if (child == null || !child.getId().equals(pName.toString())) continue;
            v.add(child);
        }
        return v;
    }

    public synchronized void removeChildren() {
        if (this.mChildren == null) {
            return;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            ((BaseComponent)this.getChildren().get(i)).setParent(null);
        }
        this.mChildren.clear();
    }

    public String getName() {
        return this.getId();
    }

    public Map getErrorTokens() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NAME", this.getFullName());
        return map;
    }

    public String getFullName() {
        if (this.getParent() == null) {
            return this.getName();
        }
        return this.getParent().getFullName() + "." + this.toString();
    }

    protected void traceStart(WorkflowContext pCtx, String procedureName) {
    }

    protected void traceEnd(WorkflowContext pCtx, String procedureName) {
    }
}

