/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf.cache;

import java.util.Hashtable;
import java.util.LinkedList;
import oracle.apps.fnd.wf.cache.WorkflowCache;
import oracle.apps.fnd.wf.common.WorkflowContext;

public class HashtableCache
implements WorkflowCache {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/cache/RCS/HashtableCache.java,v 30.1 2004/12/15 01:55:52 anpwang noship $";
    private int mMaxObjectsAllowed = 1000;
    private int mCurrentNumberItems = 0;
    private Hashtable mCachedObjects = new Hashtable();
    private LinkedList keyQueue = new LinkedList();

    @Override
    public synchronized void cache(WorkflowContext pCtx, Object pKey, Object pObject) {
        Object value = this.mCachedObjects.get(pKey);
        if (value != null) {
            if (value.equals(pObject)) {
                return;
            }
            this.mCachedObjects.put(pKey, pObject);
            this.keyQueue.remove(pKey);
            this.keyQueue.addLast(pKey);
            return;
        }
        if (this.keyQueue.size() >= this.mMaxObjectsAllowed) {
            Object oldKey = this.keyQueue.getFirst();
            this.keyQueue.removeFirst();
            this.mCachedObjects.remove(oldKey);
        }
        this.mCachedObjects.put(pKey, pObject);
        this.keyQueue.addLast(pKey);
    }

    @Override
    public Object retreive(WorkflowContext pCtx, Object pKey) {
        if (pKey == null) {
            return null;
        }
        Object object = this.mCachedObjects.get(pKey);
        return object;
    }

    @Override
    public Object makeCacheKey(WorkflowContext pCtx, Object pObject, Object pLocalKey) {
        return pLocalKey;
    }

    @Override
    public int getCapacity() {
        return this.mMaxObjectsAllowed;
    }

    @Override
    public void setCapacity(int pCapacity) {
        if (pCapacity < this.mMaxObjectsAllowed && this.keyQueue.size() > pCapacity) {
            return;
        }
        this.mMaxObjectsAllowed = pCapacity;
    }
}

