/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.wf;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import oracle.apps.fnd.wf.WFTestCaseSetup;
import oracle.apps.fnd.wf.common.WorkflowContext;

public class WFRunner {
    public static final String RCS_ID = "$Header: /wfdev/wf/3.0/java/ut/RCS/WFRunner.java,v 30.5 2004/08/19 22:41:29 dlam noship $";
    protected static String mTestClassName;
    protected static String mMode;
    protected static Class testClass;
    protected WFTestCaseSetup workflowSetup;

    private static void usage() {
        System.err.println("ProcessOrder [options] javaClass \n");
        System.err.println("options: \n");
        System.err.println("\t-usage display this information\n");
        System.err.println("\t-mode text/gui\n");
        System.err.println("\t-version version info \n");
    }

    private static void version() {
        System.out.println("Oracle Workflow Unit Test Version 1.0 ");
    }

    private static void parseCmdline(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.length() == 0) {
                args[i] = null;
                continue;
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-usage")) {
                    WFRunner.version();
                    System.out.println();
                    WFRunner.usage();
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-version")) {
                    WFRunner.version();
                    System.exit(1);
                    continue;
                }
                if (arg.startsWith("-mode")) {
                    mMode = args[++i];
                    continue;
                }
                if (!arg.startsWith("-help")) continue;
                WFRunner.usage();
                System.exit(1);
                continue;
            }
            if (arg.length() == 0) continue;
            mTestClassName = arg;
        }
    }

    public static void run(String[] args, Class class2Test) {
        testClass = class2Test;
        Properties props = System.getProperties();
        if (props.getProperty("AFLOG_LEVEL") == null) {
            System.getProperties().put("AFLOG_LEVEL", "PROCEDURE");
        }
        if (props.getProperty("CONTEXT_FACTORY_CLASSNAME") == null) {
            System.getProperties().put("CONTEXT_FACTORY_CLASSNAME", "oracle.apps.fnd.wf.common.ContextFactoryDev");
        }
        if (props.getProperty("DB_USER") == null) {
            System.getProperties().put("DB_USER", "wf30");
        }
        if (props.getProperty("DB_PASSWORD") == null) {
            System.getProperties().put("DB_PASSWORD", "wf30");
        }
        if (props.getProperty("DB_URL") == null) {
            System.getProperties().put("DB_URL", "jdbc:oracle:thin:@rraheja-pc.us.oracle.com:1521:wf3092");
        }
        System.getProperties().put("WFTestCaseSetup.CmdlineArgs", args);
        WFRunner.printEvnInfo();
        WFRunner.parseCmdline(args);
        try {
            if ("text".equalsIgnoreCase(mMode)) {
                try {
                    Method method = testClass.getDeclaredMethod("suite", new Class[0]);
                    Test test = (Test)method.invoke((Object)testClass, new Object[0]);
                    TestRunner.run((Test)test);
                }
                catch (Exception e) {
                    TestRunner.run((Test)new TestSuite(testClass));
                }
            } else {
                junit.swingui.TestRunner.run((Class)testClass);
            }
            System.err.println("\n***** Test case " + testClass.getName() + " Done - " + new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        WFRunner.parseCmdline(args);
        if (testClass == null && mTestClassName != null) {
            try {
                testClass = Class.forName(mTestClassName);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.println("Can not load " + mTestClassName);
            }
        }
        if (testClass != null) {
            System.out.println("Runing " + testClass);
            WFRunner.run(args, testClass);
        } else {
            System.err.println("No test to test");
        }
    }

    private static void printEvnInfo() {
        String testCaseName = null;
        if (testClass != null) {
            testCaseName = testClass.getName();
        }
        WorkflowContext ctx = new WorkflowContext(null);
        try {
            Properties props = System.getProperties();
            for (Object key : props.keySet()) {
                System.out.println(testCaseName + " " + key + "=" + props.get(key));
            }
            System.out.println(testCaseName + " End of sys info");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create WorkflowContext -> " + e);
        }
    }

    static {
        mMode = "text";
        testClass = null;
    }
}

