/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class VersionInfo {
    public static final String RCS_ID = "$Header: VersionInfo.java 115.12 2006/05/17 17:06:31 rnix ship $";
    public static final String AOLJ_VERSION = new String("Applications Object Library, Core Java Roll Up Patch J");
    private static Vector mRCS_IDs = new Vector(500, 100);

    public static Vector getRCS_IDs() {
        return mRCS_IDs;
    }

    public static final boolean recordClassVersion(String pRCS_ID, String pPackageName) {
        if (pRCS_ID != null) {
            mRCS_IDs.addElement(pPackageName + "#" + pRCS_ID);
            return true;
        }
        return false;
    }

    public static final String recordVersion(String pRCS_ID, String pPackageName) {
        if (pRCS_ID != null) {
            mRCS_IDs.addElement(pPackageName + "#" + pRCS_ID);
            return pRCS_ID;
        }
        return null;
    }

    public static final boolean recordClassVersion(Class pClass) {
        try {
            return null != VersionInfo.recordVersion((String)pClass.getField("RCS_ID").get(null), pClass);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String recordVersion(String pRCS_ID, Class pClass) {
        try {
            String s = pClass.getName();
            int n = s.lastIndexOf(".");
            String p = n < 0 ? "" : s.substring(0, n);
            if (VersionInfo.recordClassVersion(pRCS_ID, p)) {
                return pRCS_ID;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void printVersionInfo() {
        VersionInfo.printVersionInfo(System.out);
    }

    public static void printVersionInfo(PrintStream s) {
        VersionInfo.printVersionInfo(new PrintWriter(s));
    }

    public static void printVersionInfo(PrintWriter s) {
        Enumeration e = VersionInfo.getPrettyVersionInfo();
        while (e.hasMoreElements()) {
            s.println(e.nextElement());
        }
        s.flush();
    }

    public static Enumeration getVersionInfo() {
        Enumeration ids = VersionInfo.getRCS_IDs().elements();
        Vector<String> sortedList = new Vector<String>(VersionInfo.getRCS_IDs().size());
        while (ids.hasMoreElements()) {
            String item = (String)ids.nextElement();
            int position = 0;
            Enumeration e = sortedList.elements();
            while (e.hasMoreElements() && item.compareTo((String)e.nextElement()) > 0) {
                ++position;
            }
            sortedList.insertElementAt(item, position);
        }
        return sortedList.elements();
    }

    public static Enumeration getPrettyVersionInfo() {
        Enumeration sl = VersionInfo.getVersionInfo();
        Vector<String> vec = new Vector<String>(VersionInfo.getRCS_IDs().size(), 10);
        String pkgname = "";
        while (sl.hasMoreElements()) {
            String entry = (String)sl.nextElement();
            String pkg = entry.substring(0, entry.indexOf("#"));
            String rcs = entry.substring(entry.indexOf("#") + 1);
            if (pkg.compareTo(pkgname) != 0) {
                pkgname = pkg;
                vec.insertElementAt(pkg, vec.size());
            }
            vec.insertElementAt(rcs, vec.size());
        }
        return vec.elements();
    }

    public static void displayClassVersion(String className) {
        VersionInfo.displayClassVersion(className, System.out);
    }

    public static void displayClassVersion(String className, PrintStream s) {
        VersionInfo.displayClassVersion(className, new PrintWriter(s));
    }

    public static void displayClassVersion(String className, PrintWriter s) {
        try {
            s.println(">>> Class: " + className);
            s.println(Class.forName(className).getDeclaredField("RCS_ID").get(null));
        }
        catch (ClassNotFoundException cnfex) {
            s.println("Unable to find class " + className);
        }
        catch (NoSuchFieldException nsfex) {
            s.println("Class " + className + " does not have an RCS_ID field");
        }
        catch (SecurityException secex) {
            s.println("Security exception, unable to access field");
        }
        catch (IllegalAccessException accex) {
            s.println("IllegalAccessException, unable to access field");
        }
        catch (Exception ex) {
            ex.printStackTrace(s);
        }
        s.flush();
    }

    public static void AOLJ_RUP(String dummy) {
        System.out.println(AOLJ_VERSION);
        System.out.println(RCS_ID);
    }

    public static void main(String[] args) {
        VersionInfo.AOLJ_RUP(null);
        for (int i = 0; i < args.length; ++i) {
            VersionInfo.displayClassVersion(args[i]);
        }
    }
}

