/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import java.util.Arrays;

final class PatternMap {
    private final Node root = new Node();

    PatternMap() {
    }

    public boolean isEmpty() {
        return this.root.children.length == 0 && !this.root.accepts;
    }

    public void add(String pattern, Object action) {
        this.root.add(0, pattern, action);
    }

    public Object find(String s) {
        return this.root.find(0, s);
    }

    private static final class Node {
        private boolean accepts = false;
        private char[] chars = new char[0];
        private Node[] children = new Node[0];
        private Object value;
        private boolean wildcard = false;

        Node() {
        }

        void add(int index, String pattern, Object action) {
            if (this.wildcard) {
                throw new IllegalArgumentException("Pattern '" + pattern + "' has already been specified");
            }
            if (index == pattern.length()) {
                this.accepts = true;
                this.value = action;
                return;
            }
            char c = pattern.charAt(index);
            if (c == '*') {
                if (this.children.length > 0) {
                    throw new IllegalArgumentException("Pattern '" + pattern + "' is redefining more specific patterns");
                }
                this.accepts = true;
                this.wildcard = true;
                this.value = action;
                return;
            }
            int where = Arrays.binarySearch(this.chars, c);
            if (where < 0) {
                where = -where - 1;
                char[] nchars = new char[this.chars.length + 1];
                Node[] nchildren = new Node[this.children.length + 1];
                System.arraycopy(this.chars, 0, nchars, 0, where);
                System.arraycopy(this.chars, where, nchars, where + 1, this.chars.length - where);
                System.arraycopy(this.children, 0, nchildren, 0, where);
                System.arraycopy(this.children, where, nchildren, where + 1, this.children.length - where);
                this.chars = nchars;
                this.children = nchildren;
                this.chars[where] = pattern.charAt(index);
                this.children[where] = new Node();
            }
            this.children[where].add(index + 1, pattern, action);
        }

        Object find(int index, String s) {
            if (this.accepts) {
                if (this.wildcard || s.length() == index) {
                    return this.value;
                }
                return null;
            }
            if (s.length() == index) {
                return null;
            }
            int where = Arrays.binarySearch(this.chars, s.charAt(index));
            if (where < 0) {
                return null;
            }
            return this.children[where].find(index + 1, s);
        }
    }
}

