/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BootHashMap;
import fuego.boot.BootHashSet;
import fuego.boot.ByteArray;
import fuego.boot.CachedResource;
import fuego.boot.ClassCache;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;

final class ClassSet
extends BootHashSet {
    static final long serialVersionUID = 9218525620678792331L;
    private static final int NULL_ENTRY = 0;
    private static final int REMOVED_ENTRY = 1;
    private static final int VALID_ENTRY = 2;
    static final long serialCheck = 1988369220276024987L;

    ClassSet() {
    }

    public synchronized CachedResource getFromClassName(String className) {
        return (CachedResource)this.get(className);
    }

    public synchronized CachedResource getFromPath(String resourceName, ClassCache classCache) {
        CachedResource resource = CachedResource.fromPath(resourceName, classCache);
        return resource == null ? null : this.get(resource);
    }

    public void write(RandomAccessFile out) throws IOException {
        ByteArrayToIdMap map = new ByteArrayToIdMap();
        ByteArray byteArray = new ByteArray(128);
        int i = this.objectSet.length;
        while (i-- > 0) {
            Object value = this.objectSet[i];
            if (value == null || value == DELETED) continue;
            CachedResource cachedClass = (CachedResource)value;
            cachedClass.addPackageToMap(map, byteArray);
            cachedClass.addNameToMap(map, byteArray);
        }
        out.writeInt(byteArray.length());
        out.write(byteArray.getBytes(), 0, byteArray.length());
        this.ensureCapacity(this.size() * 4);
        Object[] set = this.objectSet;
        out.writeInt(set.length);
        for (int i2 = 0; i2 < set.length; ++i2) {
            if (set[i2] == null) {
                out.writeByte(0);
                continue;
            }
            if (set[i2] == DELETED) {
                out.writeByte(1);
                continue;
            }
            out.writeByte(2);
            CachedResource resource = (CachedResource)set[i2];
            resource.write(out, map);
        }
    }

    static ClassSet read(ClassCache classCache, MappedByteBuffer input) {
        int baLength = input.getInt();
        byte[] bytes = new byte[baLength];
        input.get(bytes);
        int size = input.getInt();
        ClassSet cachedClassesLoaded = new ClassSet();
        Object[] objects = new Object[size];
        cachedClassesLoaded.objectSet = objects;
        block5: for (int i = 0; i < size; ++i) {
            byte index = input.get();
            switch (index) {
                case 0: {
                    objects[i] = null;
                    continue block5;
                }
                case 1: {
                    objects[i] = DELETED;
                    continue block5;
                }
                case 2: {
                    objects[i] = CachedResource.read(classCache, input, bytes);
                    continue block5;
                }
                default: {
                    assert (false) : "Unreacheable";
                    continue block5;
                }
            }
        }
        return cachedClassesLoaded;
    }

    CachedResource get(CachedResource resource) {
        return (CachedResource)super.get(resource);
    }

    private static final class ByteArrayToIdMap
    extends BootHashMap<byte[], int[]> {
        static final long serialCheck = -6116485656953981256L;
        static final long serialVersionUID = 4470223774354769190L;

        private ByteArrayToIdMap() {
        }

        @Override
        int hash(Object object) {
            return ByteArray.computeHashCode(object);
        }

        @Override
        boolean equals(Object o1, Object o2) {
            return ByteArray.equals(o1, o2);
        }
    }
}

