/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BootHashMap;
import fuego.boot.BootHashSet;
import fuego.boot.ByteArray;
import fuego.boot.ByteArrayPool;
import fuego.boot.ClassCache;
import fuego.boot.ClassCacheWriteException;
import fuego.boot.LoadedResource;
import fuego.boot.SharedBufferCachedResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;

class CachedResource
extends LoadedResource {
    boolean canDup;
    int hashcode;
    boolean isClass;
    private MappedByteBuffer buffer;
    private int bytecodeLength;
    private int bytecodeOffset;
    private int codeSourceIndex;
    private CachedResource next;
    private byte[] packageName;
    private byte[] resourceName;
    private static BootHashSet packages;
    private static final String LICENSE_FILE_NAME = "META-INF/LICENSE";
    private static final String META_INF = "META-INF";
    private static final String MANIFEST_EXT = ".MF";
    private static final String INDEX_LIST_EXT = ".LIST";
    private static final String HTML_EXT = ".html";
    private static final String TEXT_EXT = ".txt";
    private static final String XML_EXT = ".xml";
    private static final String INDEX_EXT = ".index";
    private static final String PROPERTIES_EXT = ".properties";
    private static final List<String> ALLOWED_DUPLICATES;

    CachedResource(ClassCache classCache, int codeSourceIndex, int offset, int length) {
        super(classCache);
        this.codeSourceIndex = codeSourceIndex;
        this.bytecodeOffset = offset;
        this.bytecodeLength = length;
    }

    private CachedResource(String packageName, String resourceName, boolean isClass, ClassCache classCache) {
        super(classCache);
        char chr;
        int i;
        byte[] pkg = new byte[packageName.length()];
        for (i = 0; i < pkg.length; ++i) {
            chr = packageName.charAt(i);
            pkg[i] = (byte)(chr == '/' ? 46 : (byte)(chr & 0xFF));
        }
        if (packages == null) {
            packages = new ByteArrayHashSet();
        }
        this.packageName = (byte[])packages.unify(pkg);
        this.resourceName = new byte[resourceName.length()];
        this.isClass = isClass;
        for (i = 0; i < this.resourceName.length; ++i) {
            chr = resourceName.charAt(i);
            this.resourceName[i] = (byte)(chr & 0xFF);
        }
        this.calculateHash();
    }

    public static URL urlForResource(URL url, String name) throws MalformedURLException {
        String tmp = url.toString();
        URL result = tmp.endsWith(".jar") || tmp.endsWith(".zip") ? new URL("jar:" + tmp + "!/" + name) : new URL(url, name);
        return result;
    }

    public final boolean isClass() {
        return this.isClass;
    }

    @Override
    public final String getClassName() {
        assert (this.isClass()) : "Not a class " + this.getName();
        return this.getName();
    }

    @Override
    public final String getName() {
        int i;
        int dot = this.getPackageLength() == 0 ? 0 : 1;
        StringBuilder buffer = new StringBuilder(this.getPackageLength() + this.getNameLength() + dot);
        for (i = 0; i < this.getPackageLength(); ++i) {
            buffer.append(this.getPackageCharAt(i));
        }
        if (dot == 1) {
            buffer.append('.');
        }
        for (i = 0; i < this.getNameLength(); ++i) {
            buffer.append(this.getNameCharAt(i));
        }
        return buffer.toString();
    }

    public final CachedResource getNext() {
        return this.next;
    }

    @Override
    public final String getPackageName() {
        int len = this.getPackageLength();
        StringBuilder buffer = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            buffer.append(this.getPackageCharAt(i));
        }
        return buffer.toString();
    }

    public final void add(CachedResource resource) {
        CachedResource prev = this;
        while (prev.next != null) {
            prev = prev.next;
        }
        prev.next = resource;
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof CachedResource) {
                CachedResource that = (CachedResource)o;
                if (this.packageName == that.packageName) {
                    boolean bl2 = result = this.resourceName == that.resourceName;
                    if (!result) {
                        result = ByteArray.equals(this.resourceName, that.resourceName);
                    }
                }
            } else if (o instanceof String) {
                return this.toString().equals(o);
            }
        }
        return result;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public final void addNameToMap(BootHashMap<byte[], int[]> map, ByteArray byteArray) {
        CachedResource.addToMap(map, byteArray, this.resourceName);
    }

    public final void addPackageToMap(BootHashMap<byte[], int[]> map, ByteArray byteArray) {
        CachedResource.addToMap(map, byteArray, this.packageName);
    }

    static CachedResource fromPath(String resourcePath, ClassCache classCache) {
        boolean isClass = false;
        String packageName = null;
        String name = null;
        boolean dup = false;
        if (!resourcePath.endsWith("/") && !resourcePath.startsWith(LICENSE_FILE_NAME)) {
            int dot = resourcePath.lastIndexOf(46);
            packageName = "";
            String ext = dot == -1 ? "" : resourcePath.substring(dot);
            int lastSlash = resourcePath.lastIndexOf(47);
            if (lastSlash == -1) {
                name = resourcePath;
            } else {
                packageName = resourcePath.substring(0, lastSlash);
                name = resourcePath.substring(lastSlash + 1);
            }
            if (ext.equals(".class")) {
                name = name.substring(0, name.length() - ".class".length());
                isClass = true;
            } else if (packageName.equals(META_INF) || ALLOWED_DUPLICATES.contains(ext)) {
                dup = true;
            }
        }
        CachedResource result = null;
        if (packageName != null) {
            result = new CachedResource(packageName, name, isClass, classCache);
            result.canDup = dup;
        }
        return result;
    }

    static CachedResource read(ClassCache classCache, MappedByteBuffer input, byte[] bytes) {
        SharedBufferCachedResource result = null;
        SharedBufferCachedResource prev = null;
        boolean hasNext = true;
        while (hasNext) {
            int codeSourceIndex = input.getShort();
            hasNext = codeSourceIndex < 0;
            codeSourceIndex = Math.abs(codeSourceIndex) - 1;
            int packageOffset = input.getInt();
            short packageLength = input.getShort();
            int nameOffset = input.getInt();
            short nameLength = input.getShort();
            int byteCodeOffset = input.getInt();
            int byteCodeLength = input.getInt();
            int hashCode = input.getInt();
            SharedBufferCachedResource resource = new SharedBufferCachedResource(classCache, bytes, packageOffset, packageLength, nameOffset, nameLength, codeSourceIndex, byteCodeOffset, byteCodeLength, hashCode);
            if (prev == null) {
                result = prev = resource;
                continue;
            }
            prev.next = resource;
            prev = resource;
        }
        return result;
    }

    final int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    @Override
    final CodeSource getCodeSource() {
        return this.getClassCache().getCodeSource(this.codeSourceIndex);
    }

    final void setInputFile(MappedByteBuffer buffer) {
        this.buffer = buffer;
    }

    final InputStream getInputStream() {
        assert (this.buffer != null) : "Must set cache file";
        byte[] result = new byte[this.bytecodeLength];
        this.buffer.position(this.bytecodeOffset);
        this.buffer.get(result);
        return new ByteArrayInputStream(result);
    }

    byte[] getNameBytes() {
        return this.resourceName;
    }

    char getNameCharAt(int i) {
        return (char)(this.resourceName[i] & 0xFF);
    }

    int getNameLength() {
        return this.resourceName.length;
    }

    int getNameOffset() {
        return 0;
    }

    char getPackageCharAt(int i) {
        return (char)(this.packageName[i] & 0xFF);
    }

    int getPackageLength() {
        return this.packageName.length;
    }

    int getPackageOffset() {
        return 0;
    }

    byte[] getPkgBytes() {
        return this.packageName;
    }

    void calculateHash() {
        this.hashcode = 0;
        if (this.packageName.length != 0) {
            this.hashcode = ByteArray.computeHashCode(this.packageName, this.hashcode);
            this.hashcode = ByteArray.computeHashCode((byte)46, this.hashcode);
        }
        this.hashcode = ByteArray.computeHashCode(this.resourceName, this.hashcode);
    }

    @Override
    final ByteArrayPool.Entry getBytecode() {
        assert (this.buffer != null) : "Must set cache file";
        ByteArrayPool.Entry result = this.getByteArrayPool().findAvailableEntry(this.bytecodeLength);
        this.buffer.position(this.bytecodeOffset);
        this.buffer.get(result.getBytes(), 0, this.bytecodeLength);
        return result;
    }

    final void init(int codeSourceIndex, ByteArrayPool.Entry byteBuffer, FileChannel channel) throws ClassCacheWriteException {
        this.codeSourceIndex = codeSourceIndex;
        try {
            this.bytecodeOffset = (int)channel.position();
            this.bytecodeLength = byteBuffer.getLength();
            channel.write(ByteBuffer.wrap(byteBuffer.getBytes(), 0, this.bytecodeLength));
        }
        catch (IOException e) {
            throw new ClassCacheWriteException(e);
        }
    }

    final void write(RandomAccessFile out, BootHashMap byteArrayMap) throws IOException {
        CachedResource resource = this;
        while (resource != null) {
            int codeSourceIndex = resource.getCodeSourceIndex() + 1;
            out.writeShort(resource.next == null ? codeSourceIndex : -codeSourceIndex);
            CachedResource.writeId(byteArrayMap, out, resource.packageName);
            CachedResource.writeId(byteArrayMap, out, resource.resourceName);
            out.writeInt(resource.getBytecodeOffset());
            out.writeInt(resource.getBytecodeLength());
            out.writeInt(resource.hashcode);
            resource = resource.next;
        }
    }

    private static void addToMap(BootHashMap<byte[], int[]> map, ByteArray byteArray, byte[] bytes) {
        int[] id = map.get(bytes);
        if (id == null) {
            id = new int[]{byteArray.length(), bytes.length};
            byteArray.append(bytes);
            map.put(bytes, id);
        }
    }

    private static void writeId(BootHashMap byteArrayMap, RandomAccessFile out, byte[] bytes) throws IOException {
        int[] id = (int[])byteArrayMap.get(bytes);
        assert (id != null);
        out.writeInt(id[0]);
        out.writeShort(id[1]);
    }

    private int getBytecodeLength() {
        return this.bytecodeLength;
    }

    private int getCodeSourceIndex() {
        return this.codeSourceIndex;
    }

    static {
        ALLOWED_DUPLICATES = Arrays.asList(MANIFEST_EXT, INDEX_LIST_EXT, HTML_EXT, TEXT_EXT, XML_EXT, PROPERTIES_EXT, INDEX_EXT);
    }

    private static final class ByteArrayHashSet
    extends BootHashSet {
        static final long serialCheck = -1377153320999673466L;
        static final long serialVersionUID = -2934674315724219165L;

        private ByteArrayHashSet() {
        }

        @Override
        int hash(Object object) {
            return ByteArray.computeHashCode(object);
        }

        @Override
        boolean equals(Object o1, Object o2) {
            return ByteArray.equals(o1, o2);
        }
    }
}

