/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import java.util.Arrays;

final class ByteArray {
    private int length;
    private byte[] value;

    ByteArray(int size) {
        this.value = new byte[size];
    }

    public static int computeHashCode(Object o) {
        int result = 0;
        if (o != null && o instanceof byte[]) {
            result = ByteArray.computeHashCode((byte[])o, result);
        }
        return result;
    }

    public static int computeHashCode(byte[] b, int result) {
        return ByteArray.computeHashCode(b, 0, b.length, result);
    }

    public static int computeHashCode(byte b, int result) {
        return 31 * result + (b & 0xFF);
    }

    public static int computeHashCode(byte[] b, int offset, int length, int result) {
        for (int i = 0; i < length; ++i) {
            result = ByteArray.computeHashCode(b[i + offset], result);
        }
        return result;
    }

    public static boolean equals(Object o1, Object o2) {
        boolean result;
        boolean bl = result = o1 == o2;
        if (!result && o1 != null && o2 != null && o1 instanceof byte[] && o2 instanceof byte[]) {
            result = ByteArray.equals((byte[])o1, (byte[])o2);
        }
        return result;
    }

    public static boolean equals(byte[] b1, byte[] b2) {
        boolean result;
        boolean bl = result = b1.length == b2.length;
        if (result) {
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean equals(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        boolean result;
        boolean bl = result = length1 == length2;
        if (result && (b1 != b2 || offset1 != offset2)) {
            for (int i = 0; i < length1; ++i) {
                if (b1[i + offset1] == b2[i + offset2]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public String toString() {
        return ByteArray.toString(this.value, this.length);
    }

    static String toString(byte[] bytes, int n) {
        StringBuilder result = new StringBuilder();
        result.append("0x");
        for (int i = 0; i < n; ++i) {
            result.append(Integer.toHexString(bytes[i] & 0xFF));
        }
        return result.toString();
    }

    void append(byte[] bytes) {
        int len = bytes.length;
        int newlength = this.length + len;
        if (newlength > this.value.length) {
            this.expandCapacity(newlength);
        }
        System.arraycopy(bytes, 0, this.value, this.length, len);
        this.length = newlength;
    }

    byte[] getBytes() {
        return this.value;
    }

    int length() {
        return this.length;
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }
}

