/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultFactory;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProcessWsdlElementFactory;
import oracle.bpm.project.interfaces.WsdlUtils;
import oracle.bpm.project.model.ProjectObject;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public abstract class WsdlBuilder<T extends ProjectObject> {
    protected final NamespaceContext wsdlContext = new Context(null);
    private WsdlElementFactory factory;
    private T model;
    private ProcessWsdlElementFactory processWsdlElementFactory;
    protected static final QName NAME_ATTR = new QName("name");
    protected static final String SCHEMAS_PARTNER_LINK_2003_05 = "http://schemas.xmlsoap.org/ws/2003/05/partner-link/";
    protected static final QName TYPE_ATTR = new QName("type");
    protected static final QName ELEMENT_ATTR = new QName("element");
    private static final String TARGET_NAMESPACE = "targetNamespace";
    protected static final String TNS_PREFIX = "tns";
    protected static final String NAMESPACE_SEPARATOR = ":";

    protected WsdlBuilder(@NotNull T model) {
        this.model = model;
        this.wsdlContext.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.wsdlContext.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.wsdlContext.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        this.wsdlContext.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.processWsdlElementFactory = new ProcessWsdlElementFactory(this.wsdlContext, this.factory);
    }

    public T getModel() {
        return this.model;
    }

    public String build() throws BuilderException {
        return this.buildServiceDefinition().getWsdl();
    }

    public ServiceDefinition buildServiceDefinition() throws BuilderException {
        ServiceDefinition definition = this.createServiceDefinition();
        this.doBuild(definition);
        return definition;
    }

    protected abstract void doBuild(@NotNull ServiceDefinition var1) throws BuilderException;

    protected abstract String getTargetNamespace();

    protected ProcessWsdlElementFactory getProcessWsdlElementFactory() {
        return this.processWsdlElementFactory;
    }

    protected WsdlElementFactory getWsdlElementFactory() {
        if (this.factory == null) {
            this.factory = new WsdlElementFactory((ElementFactory)new DefaultFactory());
            this.factory.setLocator((Locator)new LocatorImpl());
        }
        return this.factory;
    }

    protected ServiceDefinition createServiceDefinition() {
        String targetUrl = this.getTargetNamespace();
        Map<QName, String> attributes = WsdlUtils.createAttrMap(new QName(TARGET_NAMESPACE), targetUrl);
        return (ServiceDefinition)this.processWsdlElementFactory.createElement(1, attributes, this.getTargetNamespace());
    }
}

