/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.catalog.composite.util.FlowNodeFilter;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.interfaces.BaseProcessWsdlInterfaceBuilder;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.Direction;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessWsdlInterfaceBuilder
extends BaseProcessWsdlInterfaceBuilder {
    private final Predicate<OperationReferenceImpl> REPLY_TO_FILTER = new Predicate<OperationReferenceImpl>(){

        public boolean check(@Nullable OperationReferenceImpl wrapper) {
            return wrapper != null && wrapper.hasReplyTo();
        }
    };
    private final Predicate<OperationReferenceImpl> REQUEST_FILTER = new Predicate<OperationReferenceImpl>(){

        public boolean check(@Nullable OperationReferenceImpl wrapper) {
            return wrapper != null && !wrapper.hasReplyTo();
        }
    };

    public ProcessWsdlInterfaceBuilder(@NotNull Process model) {
        super(model);
    }

    @Override
    public Sequence<? extends OperationReference> getRequestOperations() throws BuilderException {
        return this.getAllRequestConversationDefinitions();
    }

    @Override
    public Sequence<? extends OperationReference> getResponseOperations() throws BuilderException {
        return this.getAllReplyToConversationDefinitions();
    }

    @Override
    <T extends OperationReference> void generateWsdlElements(@NotNull T operationRef, @NotNull Direction direction) throws BuilderException {
        int elementType;
        OperationReferenceImpl operationReference = (OperationReferenceImpl)operationRef;
        operationReference.setProcess((Process)this.getModel());
        this.getBuilderContext().markConversation(operationReference.getConversation().getId());
        ConversationalDefinition conversationalDef = operationReference.getConversationalDefinition();
        DefineInterfaceConversationalDefinition definedCD = (DefineInterfaceConversationalDefinition)conversationalDef.as(DefineInterfaceConversationalDefinition.class);
        String operationName = operationReference.getName();
        if (operationName == null) {
            return;
        }
        String portTypeName = operationReference.getPortType().getLocalPart();
        DefaultElement portTypeElement = this.getProcessWsdlElementFactory().buildPortType(portTypeName, this.getBuilderContext(), this.getTargetNamespace());
        boolean isSender = conversationalDef.getParentObject().getConversationalType().isSender();
        String directionSuffix = isSender ? Direction.RESPONSE.getSuffix() : Direction.REQUEST.getSuffix();
        String messageName = operationName + directionSuffix;
        boolean isCallOperation = definedCD.getReplyTo() == null;
        ErrorObject error = null;
        if (isCallOperation) {
            elementType = 5;
        } else {
            error = definedCD.getError();
            elementType = 8;
            messageName = operationName + directionSuffix;
        }
        Operation operation = this.getProcessWsdlElementFactory().buildOperation((Element)portTypeElement, operationName, this.getBuilderContext(), this.getTargetNamespace());
        String prefixedMessageName = this.getProcessWsdlElementFactory().createTypeName("tns", messageName);
        DataDeclarationContainer argumentsContainer = definedCD.getArgumentsContainer();
        Sequence declarations = argumentsContainer.getDeclarations();
        this.getProcessWsdlElementFactory().addMessage(operationName, messageName, (Sequence<DataDeclaration>)declarations, this.getBuilderContext(), this.getTargetNamespace());
        this.getProcessWsdlElementFactory().addOperationArgument(operation, prefixedMessageName, elementType, this.getTargetNamespace());
        if (error != null) {
            String faultMessage = this.getProcessWsdlElementFactory().createTypeName("tns", error.getName());
            this.getProcessWsdlElementFactory().buildFaultMessage(error, this.getBuilderContext(), this.getTargetNamespace());
            this.getProcessWsdlElementFactory().addFaultArgument(error, operation, faultMessage, this.getTargetNamespace());
        }
    }

    private Sequence<OperationReferenceImpl> getAllRequestConversationDefinitions() {
        return this.getAllNodes().select(ModelUtils.INBOUND_DEFINE_CONVERSATIONAL_DEFINITIONS).map(FlowNodeFilter.NODE_OPERATION_DEF_MAPPER).select(this.REQUEST_FILTER);
    }

    private Sequence<OperationReferenceImpl> getAllReplyToConversationDefinitions() {
        return this.getAllNodes().select(ModelUtils.INBOUND_DEFINE_CONVERSATIONAL_DEFINITIONS).map(FlowNodeFilter.NODE_OPERATION_DEF_MAPPER).select(this.REPLY_TO_FILTER);
    }
}

