/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.ElementType;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultFactory;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.parser.xsd.Sequence;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.WsdlBuilder;
import oracle.bpm.project.interfaces.WsdlBuilderContext;
import oracle.bpm.project.interfaces.WsdlUtils;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public final class ProcessWsdlElementFactory {
    private WsdlElementFactory factory;
    private final NamespaceContext namespaceCtx;

    ProcessWsdlElementFactory(@NotNull NamespaceContext namespaceCtx, @NotNull WsdlElementFactory factory) {
        this.namespaceCtx = namespaceCtx;
        this.factory = factory;
    }

    public String createTypeName(@Nullable String prefix, @NotNull String typeName) {
        String name = null;
        if (prefix != null) {
            name = prefix + ":";
        }
        return name == null ? typeName : name + typeName;
    }

    @NotNull
    public DefaultElement buildPortType(@NotNull String portTypeName, @NotNull WsdlBuilderContext ctx, @NotNull String namespace) {
        DefaultElement portTypeElement = ctx.getPortType(portTypeName);
        if (portTypeElement == null) {
            portTypeElement = this.createPortTypeElement(portTypeName, namespace);
            ctx.addPortType(portTypeName, portTypeElement);
        }
        return portTypeElement;
    }

    public void addMessage(@NotNull String operationName, @NotNull String messageName, @NotNull oracle.bpm.collections.Sequence<DataDeclaration> dataDeclarationSequence, @NotNull WsdlBuilderContext ctx, @NotNull String namespace) {
        Message message = ctx.getMessage(messageName);
        if (message == null) {
            message = this.createMessageElement(operationName, messageName, dataDeclarationSequence, ctx, namespace);
            ctx.addMessage(messageName, message);
        }
    }

    public void addOperationArgument(@NotNull Operation operation, @NotNull String prefixedMessageName, int argumentType, @NotNull String namespace) {
        Input input = operation.getInput();
        Output output = operation.getOutput();
        if (argumentType == 5 && input == null || argumentType == 8 && output == null) {
            Element argument = this.createOperationArgumentElement(prefixedMessageName, argumentType, null, namespace);
            operation.addChild(argument);
        }
    }

    public Operation buildOperation(@NotNull Element portTypeElement, @NotNull String operationName, @NotNull WsdlBuilderContext ctx, @NotNull String namesapce) throws BuilderException {
        Map<String, Operation> operations = ctx.getOperationFromPortType(portTypeElement);
        Operation operation = operations.get(operationName);
        if (operation == null) {
            operation = this.createOperation(operationName, null, namesapce);
            portTypeElement.addChild((Element)operation);
            operations.put(operationName, operation);
        }
        return operation;
    }

    public void addFaultArgument(@NotNull ErrorObject error, @NotNull Operation operation, @NotNull String prefixedMessageName, @NotNull String namespace) {
        List faultList = operation.getFaults();
        if (faultList.isEmpty()) {
            Element argument = this.createOperationArgumentElement(prefixedMessageName, 3, error.getName(), namespace);
            operation.addChild(argument);
        }
    }

    public DefaultElement createPortTypeElement(@NotNull String portTypeName, @NotNull String namespace) {
        Map<QName, String> attributes = WsdlUtils.createAttrMap(new QName("name"), portTypeName);
        return (DefaultElement)this.createElement(11, attributes, namespace);
    }

    public void buildFaultMessage(@NotNull ErrorObject errorObject, @NotNull WsdlBuilderContext ctx, @NotNull String namespace) throws BuilderException {
        String messageName = errorObject.getName();
        Message message = ctx.getMessage(messageName);
        if (message == null) {
            oracle.bpm.collections.Sequence attributes = errorObject.getAttributes();
            if (attributes.isEmpty() || attributes.toArray().length > 1) {
                throw new BuilderException((Msg)ProjectCatalogMsg.FAULT_INVALID_CONTENT((String)messageName));
            }
            CatalogMember member = (CatalogMember)attributes.iterator().next();
            if (!member.getName().equals("errorInfo")) {
                throw new BuilderException((Msg)ProjectCatalogMsg.FAULT_WITHOUT_ERRORINFO((String)messageName));
            }
            Map<QName, String> attr = WsdlUtils.createAttrMap(WsdlBuilder.NAME_ATTR, messageName);
            message = (Message)this.createElement(6, attr, namespace);
            CatalogType type = member.getType();
            attr = WsdlUtils.createAttrMap(WsdlBuilder.NAME_ATTR, "errorInfo");
            Element part = this.createMessagePart(attr, type.getDelegate().asSchemaObject(), ctx, namespace);
            message.addChild(part);
            ctx.addMessage(messageName, message);
        }
    }

    public String resolveType(@NotNull SchemaObject schemaObject, @NotNull WsdlBuilderContext ctx) {
        String prefix;
        String schemaNamespace = schemaObject.getNamespace();
        Collection byUri = this.namespaceCtx.findPrefixesByUri(schemaNamespace);
        if (byUri == null || byUri.isEmpty()) {
            prefix = "tns" + this.namespaceCtx.getDeclaredPrefixCount();
            this.namespaceCtx.addNamespace(prefix, schemaNamespace);
            if (schemaObject.isFromWsdl()) {
                ctx.createWsdlImportFor(schemaObject);
            } else if (schemaObject.isFromSchema()) {
                ctx.createchemalImportFor(schemaObject);
            }
        } else {
            prefix = (String)byUri.iterator().next();
        }
        return prefix + ":" + schemaObject.getName();
    }

    public Element createPartnerLinkElement(@NotNull String portTypeName, @NotNull WsdlBuilderContext ctx) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        attrs.put(WsdlBuilder.NAME_ATTR, portTypeName + "PartnerLinkType");
        Element partnerLink = this.factory.create("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "partnerLinkType", attrs);
        this.addPartnerRole(partnerLink, portTypeName + "Provider", "tns:" + portTypeName);
        String callBackPortTypeName = ctx.getCallBackPortTypeName(portTypeName);
        if (callBackPortTypeName != null) {
            this.addPartnerRole(partnerLink, callBackPortTypeName + "Requester", "tns:" + callBackPortTypeName);
        }
        return partnerLink;
    }

    public Operation createOperation(@NotNull String operationName, @Nullable Map<QName, String> attrs, @NotNull String namespace) {
        Map<QName, String> operationAttributes = WsdlUtils.createAttrMap(WsdlBuilder.NAME_ATTR, operationName);
        if (attrs != null && !attrs.isEmpty()) {
            operationAttributes.putAll(attrs);
        }
        return (Operation)this.createElement(7, operationAttributes, namespace);
    }

    public Element createElement(int elementtype, @NotNull Map<QName, String> attributes, @NotNull String namespace) {
        if (this.factory == null) {
            this.factory = new WsdlElementFactory((ElementFactory)new DefaultFactory());
            this.factory.setLocator((Locator)new LocatorImpl());
            this.namespaceCtx.addNamespace("tns", namespace);
            this.factory.setContext(this.namespaceCtx);
        }
        return this.factory.create("http://schemas.xmlsoap.org/wsdl/", ElementType.findByType((int)elementtype), attributes);
    }

    private void addPartnerRole(@NotNull Element partnerLink, @NotNull String roleName, @NotNull String portName) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        attrs.put(WsdlBuilder.NAME_ATTR, roleName);
        Element partnerRole = this.factory.create("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "role", attrs);
        attrs = new HashMap();
        attrs.put(WsdlBuilder.NAME_ATTR, portName);
        Element partnerPortType = this.factory.create("http://schemas.xmlsoap.org/ws/2003/05/partner-link/", "portType", attrs);
        partnerRole.addChild(partnerPortType);
        partnerLink.addChild(partnerRole);
    }

    private Element createMessagePart(@NotNull Map<QName, String> attributesPart, @NotNull SchemaObject schemaObject, @NotNull WsdlBuilderContext ctx, @NotNull String namespace) {
        String attributeValue = this.resolveType(schemaObject, ctx);
        if (schemaObject.isType()) {
            attributesPart.put(WsdlBuilder.TYPE_ATTR, attributeValue);
        } else {
            attributesPart.put(new QName("element"), attributeValue);
        }
        return this.createElement(9, attributesPart, namespace);
    }

    private Element createOperationArgumentElement(@NotNull String message, int argumentType, @Nullable String name, @NotNull String namespace) {
        QName qName = new QName(ElementType.findByType((int)6));
        Map<QName, String> attrs = WsdlUtils.createAttrMap(qName, message);
        if (name != null) {
            attrs.put(new QName("name"), name);
        }
        return this.createElement(argumentType, attrs, namespace);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Message createMessageElement(@NotNull String operationName, @NotNull String name, @Nullable oracle.bpm.collections.Sequence<DataDeclaration> dataDeclarationSequence, @NotNull WsdlBuilderContext ctx, @NotNull String namespace) {
        String messagePayload = this.createTypeName("tns", name);
        if (dataDeclarationSequence != null) {
            int argumentsCount = CollectionUtils.size(dataDeclarationSequence);
            ArrayList<ElementDef> definedType = new ArrayList<ElementDef>();
            boolean areDefinedTypes = true;
            for (DataDeclaration argument : dataDeclarationSequence) {
                ElementDef elementDef;
                block9: {
                    CatalogType type = argument.getType();
                    TypeDescription typeDescription = type.getDelegate();
                    if (typeDescription.hasErrors()) {
                        Log.logWarning((Msg)ProjectCatalogMsg.TYPE_NOT_FOUND((String)type.getName(), (String)operationName));
                        continue;
                    }
                    SchemaObject schemaObject = typeDescription.asSchemaObject();
                    elementDef = null;
                    String attributeValue = this.resolveType(schemaObject, ctx);
                    if (schemaObject.isFromWsdl()) {
                        areDefinedTypes = false;
                        if (argumentsCount > 1) {
                            Log.logWarning((Msg)ProjectCatalogMsg.INVALID_ARGUMENT_FOR_PROCESS_WSDL((String)operationName));
                            break;
                        }
                        if (schemaObject.isElement()) {
                            messagePayload = attributeValue;
                            break block9;
                        } else {
                            Log.logWarning((Msg)ProjectCatalogMsg.INVALID_ARGUMENT_FOR_PROCESS_WSDL((String)operationName));
                            break;
                        }
                    }
                    elementDef = schemaObject.isElement() ? SchemaElementFactory.createElementRef((String)attributeValue, (NamespaceContext)this.namespaceCtx) : SchemaElementFactory.createElementWithType((String)argument.getName(), (String)attributeValue, (boolean)false, null, (NamespaceContext)this.namespaceCtx);
                }
                if (elementDef == null) continue;
                definedType.add(elementDef);
            }
            if (areDefinedTypes) {
                ElementDef element = SchemaElementFactory.createElement((String)name, (NamespaceContext)this.namespaceCtx);
                ComplexType complexType = SchemaElementFactory.createComplexType((NamespaceContext)this.namespaceCtx);
                Sequence sequence = SchemaElementFactory.createSequence((NamespaceContext)this.namespaceCtx);
                complexType.addChild((Element)sequence);
                element.addChild((Element)complexType);
                for (ElementDef elementDef : definedType) {
                    sequence.addChild((Element)elementDef);
                }
                ctx.addDefinedElement(name, (Element)element);
            }
        }
        Map<QName, String> attributes = WsdlUtils.createAttrMap(WsdlBuilder.NAME_ATTR, name);
        Message message = (Message)this.createElement(6, attributes, namespace);
        attributes = WsdlUtils.createAttrMap(WsdlBuilder.NAME_ATTR, "parameters");
        attributes.put(WsdlBuilder.ELEMENT_ATTR, messagePayload);
        Element part = this.createElement(9, attributes, namespace);
        message.addChild(part);
        return message;
    }
}

