/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ConversationHelper;
import oracle.bpm.project.interfaces.Direction;
import oracle.bpm.project.interfaces.WsdlBuilder;
import oracle.bpm.project.interfaces.WsdlBuilderContext;
import oracle.bpm.project.interfaces.WsdlUtils;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProcessWsdlInterfaceBuilder
extends WsdlBuilder<Process> {
    private WsdlBuilderContext builderContext = null;

    protected BaseProcessWsdlInterfaceBuilder(@NotNull Process model) {
        super(model);
        this.wsdlContext.addNamespace("plnk", "http://schemas.xmlsoap.org/ws/2003/05/partner-link/");
        this.builderContext = WsdlBuilderContext.create();
    }

    @Override
    public String build() throws BuilderException {
        return this.buildServiceDefinition().getWsdl();
    }

    @Override
    protected String getTargetNamespace() {
        return ((Process)this.getModel()).getNamespace();
    }

    @Override
    protected void doBuild(@NotNull ServiceDefinition service) throws BuilderException {
        boolean hasSchemaImports;
        Process process = (Process)this.getModel();
        if (process.isCallableSubprocess()) {
            return;
        }
        Sequence allConversationsFrom = ConversationHelper.getAllConversationsFrom((Process)((Process)this.getModel())).select((Predicate)new Predicate<Conversation>(){

            public boolean check(@Nullable Conversation conversation) {
                return conversation != null && conversation.getConversationType() == ConversationType.DEFINE_INTERFACE;
            }
        });
        for (Conversation conversation : allConversationsFrom) {
            this.getBuilderContext().addUnusedConversation(conversation);
        }
        this.generateWsdlElements(this.getRequestOperations(), Direction.REQUEST);
        this.generateWsdlElements(this.getResponseOperations(), Direction.RESPONSE);
        List<Import> wsdlImports = this.getBuilderContext().getWsdlImports();
        if (!wsdlImports.isEmpty()) {
            for (Import anImport : wsdlImports) {
                anImport.setNSContext(service.getNSContext());
                service.addChild((Element)anImport);
            }
        }
        boolean hasDefinedElements = !this.getBuilderContext().getDefinedElements().isEmpty();
        boolean bl = hasSchemaImports = !this.getBuilderContext().getSchemaImports().isEmpty();
        if (hasDefinedElements || hasSchemaImports) {
            DefaultElement types = WsdlElementFactory.createTypes((NamespaceContext)service.getNSContext());
            service.addChild((Element)types);
            Schema schema = SchemaElementFactory.createSchema((String)this.getTargetNamespace());
            types.addChild((Element)schema);
            if (hasSchemaImports) {
                this.generateImports(types, schema);
            }
            if (hasDefinedElements) {
                Collection<Element> definedElements = this.getBuilderContext().getDefinedElements();
                for (Element definedElement : definedElements) {
                    schema.addChild(definedElement);
                }
            }
        }
        WsdlUtils.dumpElements(service, this.getBuilderContext().getMessages());
        Collection<Conversation> unusedConversations = this.getBuilderContext().getUnusedConversations();
        for (Conversation unusedConversation : unusedConversations) {
            String portTypeName = ConversationHelper.getPortTypeName((Process)((Process)this.getModel()), (Conversation)unusedConversation);
            DefaultElement portTypeElement = this.getProcessWsdlElementFactory().buildPortType(portTypeName, this.getBuilderContext(), this.getTargetNamespace());
            DefaultElement portType = this.getBuilderContext().getPortType(portTypeName);
            if (portType != null) continue;
            this.getBuilderContext().addPortType(portTypeName, portTypeElement);
        }
        Collection<DefaultElement> portTypes = this.getBuilderContext().getPortTypes();
        WsdlUtils.dumpElements(service, portTypes);
        for (DefaultElement portType : portTypes) {
            String portTypeName = portType.getAttribute(NAME_ATTR);
            if (portTypeName.endsWith("CallBack")) continue;
            Element partnerLink = this.getProcessWsdlElementFactory().createPartnerLinkElement(portTypeName, this.getBuilderContext());
            service.addChild(partnerLink);
        }
    }

    protected WsdlBuilderContext getBuilderContext() {
        return this.builderContext;
    }

    abstract Sequence<? extends OperationReference> getRequestOperations() throws BuilderException;

    abstract Sequence<? extends OperationReference> getResponseOperations() throws BuilderException;

    abstract <T extends OperationReference> void generateWsdlElements(@NotNull T var1, @NotNull Direction var2) throws BuilderException;

    Sequence<FlowNode> getAllNodes() {
        return ((Process)this.getModel()).getChildrenByType(FlowNode.class).select(PredicateUtils.or((Predicate)ModelUtils.ACTIVITY_FILTER, (Predicate)ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL);
    }

    private void generateWsdlElements(@NotNull Sequence<? extends OperationReference> operations, @NotNull Direction direction) throws BuilderException {
        for (OperationReference operationWrapper : operations) {
            this.generateWsdlElements(operationWrapper, direction);
        }
    }

    private void generateImports(@NotNull DefaultElement type, @NotNull Schema schema) {
        List<oracle.bpm.project.catalog.parser.xsd.Import> elementList = this.getBuilderContext().getSchemaImports();
        if (!elementList.isEmpty()) {
            for (oracle.bpm.project.catalog.parser.xsd.Import anImport : elementList) {
                anImport.setNSContext(new NamespaceContext(type.getNSContext()));
                schema.addChild((Element)anImport);
            }
        }
    }
}

